/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.debug;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.beetl.core.AntlrProgramBuilder;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.debug.DebugBlockEnvContext;
import org.beetl.core.debug.DebugProgramBuilderContext;
import org.beetl.core.debug.DebugProgramMetaData;
import org.beetl.core.debug.WrapDebugHoldonBlockStatement;
import org.beetl.core.debug.WrapDebugHoldonStatement;
import org.beetl.core.engine.GrammarCreator;
import org.beetl.core.statement.BlockStatement;
import org.beetl.core.statement.ProgramMetaData;
import org.beetl.core.statement.Statement;

public class DebugAntlrProgramBuilder
extends AntlrProgramBuilder {
    int lastLine = -1;

    public DebugAntlrProgramBuilder(GroupTemplate gt, GrammarCreator gc) {
        super(gt, gc);
        this.pbCtx = new DebugProgramBuilderContext();
        this.data = new DebugProgramMetaData();
    }

    @Override
    public ProgramMetaData build(ParseTree tree, Resource resource) {
        super.build(tree, resource);
        DebugProgramBuilderContext debugBuilderContext = (DebugProgramBuilderContext)this.pbCtx;
        DebugProgramMetaData debugProgramMetaData = (DebugProgramMetaData)this.data;
        debugProgramMetaData.setBlockEnvContext((DebugBlockEnvContext)debugBuilderContext.root);
        return debugProgramMetaData;
    }

    @Override
    protected Statement parseStatment(ParserRuleContext node) {
        Statement statement = super.parseStatment(node);
        if (this.lastLine < node.getStart().getLine()) {
            this.lastLine = node.getStart().getLine();
            return new WrapDebugHoldonStatement(statement, node.getStart().getLine());
        }
        if (statement instanceof BlockStatement) {
            return new WrapDebugHoldonBlockStatement(statement, node.getStart().getLine(), node.getStop().getLine());
        }
        return statement;
    }
}

