/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.users.UserProfileIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class UserProfile
implements UserProfileIF {
    @Nullable
    private final String username;
    @Nullable
    private final String usernameNormalized;
    @Nullable
    private final String realName;
    @Nullable
    private final String realNameNormalized;
    @Nullable
    private final String email;
    @Nullable
    private final String statusText;
    @Nullable
    private final String statusEmoji;
    @Nullable
    private final String title;
    @Nullable
    private final String phone;
    @Nullable
    private final String skype;
    @Nullable
    private final String teamId;
    @Nullable
    private final String avatarHash;
    @Nullable
    private final String imageOriginal;
    @Nullable
    private final String image24;
    @Nullable
    private final String image32;
    @Nullable
    private final String image48;
    @Nullable
    private final String image72;
    @Nullable
    private final String image192;
    @Nullable
    private final String image512;
    @Nullable
    private final String image1024;

    private UserProfile(@Nullable String username, @Nullable String usernameNormalized, @Nullable String realName, @Nullable String realNameNormalized, @Nullable String email, @Nullable String statusText, @Nullable String statusEmoji, @Nullable String title, @Nullable String phone, @Nullable String skype, @Nullable String teamId, @Nullable String avatarHash, @Nullable String imageOriginal, @Nullable String image24, @Nullable String image32, @Nullable String image48, @Nullable String image72, @Nullable String image192, @Nullable String image512, @Nullable String image1024) {
        this.username = username;
        this.usernameNormalized = usernameNormalized;
        this.realName = realName;
        this.realNameNormalized = realNameNormalized;
        this.email = email;
        this.statusText = statusText;
        this.statusEmoji = statusEmoji;
        this.title = title;
        this.phone = phone;
        this.skype = skype;
        this.teamId = teamId;
        this.avatarHash = avatarHash;
        this.imageOriginal = imageOriginal;
        this.image24 = image24;
        this.image32 = image32;
        this.image48 = image48;
        this.image72 = image72;
        this.image192 = image192;
        this.image512 = image512;
        this.image1024 = image1024;
    }

    @Override
    @JsonProperty(value="display_name")
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Override
    @JsonProperty(value="display_name_normalized")
    public Optional<String> getUsernameNormalized() {
        return Optional.ofNullable(this.usernameNormalized);
    }

    @Override
    @JsonProperty
    public Optional<String> getRealName() {
        return Optional.ofNullable(this.realName);
    }

    @Override
    @JsonProperty
    public Optional<String> getRealNameNormalized() {
        return Optional.ofNullable(this.realNameNormalized);
    }

    @Override
    @JsonProperty
    public Optional<String> getEmail() {
        return Optional.ofNullable(this.email);
    }

    @Override
    @JsonProperty
    public Optional<String> getStatusText() {
        return Optional.ofNullable(this.statusText);
    }

    @Override
    @JsonProperty
    public Optional<String> getStatusEmoji() {
        return Optional.ofNullable(this.statusEmoji);
    }

    @Override
    @JsonProperty
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty
    public Optional<String> getPhone() {
        return Optional.ofNullable(this.phone);
    }

    @Override
    @JsonProperty
    public Optional<String> getSkype() {
        return Optional.ofNullable(this.skype);
    }

    @Override
    @JsonProperty(value="team")
    public Optional<String> getTeamId() {
        return Optional.ofNullable(this.teamId);
    }

    @Override
    @JsonProperty
    public Optional<String> getAvatarHash() {
        return Optional.ofNullable(this.avatarHash);
    }

    @Override
    @JsonProperty
    public Optional<String> getImageOriginal() {
        return Optional.ofNullable(this.imageOriginal);
    }

    @Override
    @JsonProperty(value="image_24")
    public Optional<String> getImage24() {
        return Optional.ofNullable(this.image24);
    }

    @Override
    @JsonProperty(value="image_32")
    public Optional<String> getImage32() {
        return Optional.ofNullable(this.image32);
    }

    @Override
    @JsonProperty(value="image_48")
    public Optional<String> getImage48() {
        return Optional.ofNullable(this.image48);
    }

    @Override
    @JsonProperty(value="image_72")
    public Optional<String> getImage72() {
        return Optional.ofNullable(this.image72);
    }

    @Override
    @JsonProperty(value="image_192")
    public Optional<String> getImage192() {
        return Optional.ofNullable(this.image192);
    }

    @Override
    @JsonProperty(value="image_512")
    public Optional<String> getImage512() {
        return Optional.ofNullable(this.image512);
    }

    @Override
    @JsonProperty(value="image_1024")
    public Optional<String> getImage1024() {
        return Optional.ofNullable(this.image1024);
    }

    public final UserProfile withUsername(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.username, newValue)) {
            return this;
        }
        return new UserProfile(newValue, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withUsername(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return new UserProfile(value, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withUsernameNormalized(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.usernameNormalized, newValue)) {
            return this;
        }
        return new UserProfile(this.username, newValue, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withUsernameNormalized(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameNormalized, value)) {
            return this;
        }
        return new UserProfile(this.username, value, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withRealName(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.realName, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, newValue, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withRealName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.realName, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, value, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withRealNameNormalized(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.realNameNormalized, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, newValue, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withRealNameNormalized(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.realNameNormalized, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, value, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withEmail(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.email, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, newValue, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withEmail(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.email, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, value, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withStatusText(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.statusText, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, newValue, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withStatusText(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.statusText, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, value, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withStatusEmoji(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.statusEmoji, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, newValue, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withStatusEmoji(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.statusEmoji, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, value, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withTitle(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, newValue, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, value, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withPhone(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.phone, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, newValue, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withPhone(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.phone, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, value, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withSkype(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.skype, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, newValue, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withSkype(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.skype, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, value, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withTeamId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.teamId, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, newValue, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withTeamId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.teamId, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, value, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withAvatarHash(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.avatarHash, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, newValue, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withAvatarHash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.avatarHash, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, value, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withImageOriginal(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.imageOriginal, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, newValue, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withImageOriginal(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.imageOriginal, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, value, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withImage24(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.image24, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, newValue, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withImage24(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.image24, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, value, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withImage32(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.image32, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, newValue, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withImage32(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.image32, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, value, this.image48, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withImage48(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.image48, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, newValue, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withImage48(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.image48, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, value, this.image72, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withImage72(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.image72, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, newValue, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withImage72(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.image72, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, value, this.image192, this.image512, this.image1024);
    }

    public final UserProfile withImage192(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.image192, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, newValue, this.image512, this.image1024);
    }

    public final UserProfile withImage192(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.image192, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, value, this.image512, this.image1024);
    }

    public final UserProfile withImage512(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.image512, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, newValue, this.image1024);
    }

    public final UserProfile withImage512(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.image512, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, value, this.image1024);
    }

    public final UserProfile withImage1024(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.image1024, newValue)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, newValue);
    }

    public final UserProfile withImage1024(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.image1024, value)) {
            return this;
        }
        return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UserProfile && this.equalTo((UserProfile)another);
    }

    private boolean equalTo(UserProfile another) {
        return Objects.equals(this.username, another.username) && Objects.equals(this.usernameNormalized, another.usernameNormalized) && Objects.equals(this.realName, another.realName) && Objects.equals(this.realNameNormalized, another.realNameNormalized) && Objects.equals(this.email, another.email) && Objects.equals(this.statusText, another.statusText) && Objects.equals(this.statusEmoji, another.statusEmoji) && Objects.equals(this.title, another.title) && Objects.equals(this.phone, another.phone) && Objects.equals(this.skype, another.skype) && Objects.equals(this.teamId, another.teamId) && Objects.equals(this.avatarHash, another.avatarHash) && Objects.equals(this.imageOriginal, another.imageOriginal) && Objects.equals(this.image24, another.image24) && Objects.equals(this.image32, another.image32) && Objects.equals(this.image48, another.image48) && Objects.equals(this.image72, another.image72) && Objects.equals(this.image192, another.image192) && Objects.equals(this.image512, another.image512) && Objects.equals(this.image1024, another.image1024);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.username);
        h = h * 17 + Objects.hashCode(this.usernameNormalized);
        h = h * 17 + Objects.hashCode(this.realName);
        h = h * 17 + Objects.hashCode(this.realNameNormalized);
        h = h * 17 + Objects.hashCode(this.email);
        h = h * 17 + Objects.hashCode(this.statusText);
        h = h * 17 + Objects.hashCode(this.statusEmoji);
        h = h * 17 + Objects.hashCode(this.title);
        h = h * 17 + Objects.hashCode(this.phone);
        h = h * 17 + Objects.hashCode(this.skype);
        h = h * 17 + Objects.hashCode(this.teamId);
        h = h * 17 + Objects.hashCode(this.avatarHash);
        h = h * 17 + Objects.hashCode(this.imageOriginal);
        h = h * 17 + Objects.hashCode(this.image24);
        h = h * 17 + Objects.hashCode(this.image32);
        h = h * 17 + Objects.hashCode(this.image48);
        h = h * 17 + Objects.hashCode(this.image72);
        h = h * 17 + Objects.hashCode(this.image192);
        h = h * 17 + Objects.hashCode(this.image512);
        h = h * 17 + Objects.hashCode(this.image1024);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UserProfile{");
        if (this.username != null) {
            builder.append("username=").append(this.username);
        }
        if (this.usernameNormalized != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("usernameNormalized=").append(this.usernameNormalized);
        }
        if (this.realName != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("realName=").append(this.realName);
        }
        if (this.realNameNormalized != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("realNameNormalized=").append(this.realNameNormalized);
        }
        if (this.email != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("email=").append(this.email);
        }
        if (this.statusText != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("statusText=").append(this.statusText);
        }
        if (this.statusEmoji != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("statusEmoji=").append(this.statusEmoji);
        }
        if (this.title != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("title=").append(this.title);
        }
        if (this.phone != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("phone=").append(this.phone);
        }
        if (this.skype != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("skype=").append(this.skype);
        }
        if (this.teamId != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("teamId=").append(this.teamId);
        }
        if (this.avatarHash != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("avatarHash=").append(this.avatarHash);
        }
        if (this.imageOriginal != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("imageOriginal=").append(this.imageOriginal);
        }
        if (this.image24 != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("image24=").append(this.image24);
        }
        if (this.image32 != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("image32=").append(this.image32);
        }
        if (this.image48 != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("image48=").append(this.image48);
        }
        if (this.image72 != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("image72=").append(this.image72);
        }
        if (this.image192 != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("image192=").append(this.image192);
        }
        if (this.image512 != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("image512=").append(this.image512);
        }
        if (this.image1024 != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("image1024=").append(this.image1024);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static UserProfile fromJson(Json json) {
        Builder builder = UserProfile.builder();
        if (json.username != null) {
            builder.setUsername(json.username);
        }
        if (json.usernameNormalized != null) {
            builder.setUsernameNormalized(json.usernameNormalized);
        }
        if (json.realName != null) {
            builder.setRealName(json.realName);
        }
        if (json.realNameNormalized != null) {
            builder.setRealNameNormalized(json.realNameNormalized);
        }
        if (json.email != null) {
            builder.setEmail(json.email);
        }
        if (json.statusText != null) {
            builder.setStatusText(json.statusText);
        }
        if (json.statusEmoji != null) {
            builder.setStatusEmoji(json.statusEmoji);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.phone != null) {
            builder.setPhone(json.phone);
        }
        if (json.skype != null) {
            builder.setSkype(json.skype);
        }
        if (json.teamId != null) {
            builder.setTeamId(json.teamId);
        }
        if (json.avatarHash != null) {
            builder.setAvatarHash(json.avatarHash);
        }
        if (json.imageOriginal != null) {
            builder.setImageOriginal(json.imageOriginal);
        }
        if (json.image24 != null) {
            builder.setImage24(json.image24);
        }
        if (json.image32 != null) {
            builder.setImage32(json.image32);
        }
        if (json.image48 != null) {
            builder.setImage48(json.image48);
        }
        if (json.image72 != null) {
            builder.setImage72(json.image72);
        }
        if (json.image192 != null) {
            builder.setImage192(json.image192);
        }
        if (json.image512 != null) {
            builder.setImage512(json.image512);
        }
        if (json.image1024 != null) {
            builder.setImage1024(json.image1024);
        }
        return builder.build();
    }

    public static UserProfile copyOf(UserProfileIF instance) {
        if (instance instanceof UserProfile) {
            return (UserProfile)instance;
        }
        return UserProfile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String username;
        @Nullable
        private String usernameNormalized;
        @Nullable
        private String realName;
        @Nullable
        private String realNameNormalized;
        @Nullable
        private String email;
        @Nullable
        private String statusText;
        @Nullable
        private String statusEmoji;
        @Nullable
        private String title;
        @Nullable
        private String phone;
        @Nullable
        private String skype;
        @Nullable
        private String teamId;
        @Nullable
        private String avatarHash;
        @Nullable
        private String imageOriginal;
        @Nullable
        private String image24;
        @Nullable
        private String image32;
        @Nullable
        private String image48;
        @Nullable
        private String image72;
        @Nullable
        private String image192;
        @Nullable
        private String image512;
        @Nullable
        private String image1024;

        private Builder() {
        }

        public final Builder from(UserProfileIF instance) {
            Optional<String> image1024Optional;
            Optional<String> image512Optional;
            Optional<String> image192Optional;
            Optional<String> image72Optional;
            Optional<String> image48Optional;
            Optional<String> image32Optional;
            Optional<String> image24Optional;
            Optional<String> imageOriginalOptional;
            Optional<String> avatarHashOptional;
            Optional<String> teamIdOptional;
            Optional<String> skypeOptional;
            Optional<String> phoneOptional;
            Optional<String> titleOptional;
            Optional<String> statusEmojiOptional;
            Optional<String> statusTextOptional;
            Optional<String> emailOptional;
            Optional<String> realNameNormalizedOptional;
            Optional<String> realNameOptional;
            Optional<String> usernameNormalizedOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> usernameOptional = instance.getUsername();
            if (usernameOptional.isPresent()) {
                this.setUsername(usernameOptional);
            }
            if ((usernameNormalizedOptional = instance.getUsernameNormalized()).isPresent()) {
                this.setUsernameNormalized(usernameNormalizedOptional);
            }
            if ((realNameOptional = instance.getRealName()).isPresent()) {
                this.setRealName(realNameOptional);
            }
            if ((realNameNormalizedOptional = instance.getRealNameNormalized()).isPresent()) {
                this.setRealNameNormalized(realNameNormalizedOptional);
            }
            if ((emailOptional = instance.getEmail()).isPresent()) {
                this.setEmail(emailOptional);
            }
            if ((statusTextOptional = instance.getStatusText()).isPresent()) {
                this.setStatusText(statusTextOptional);
            }
            if ((statusEmojiOptional = instance.getStatusEmoji()).isPresent()) {
                this.setStatusEmoji(statusEmojiOptional);
            }
            if ((titleOptional = instance.getTitle()).isPresent()) {
                this.setTitle(titleOptional);
            }
            if ((phoneOptional = instance.getPhone()).isPresent()) {
                this.setPhone(phoneOptional);
            }
            if ((skypeOptional = instance.getSkype()).isPresent()) {
                this.setSkype(skypeOptional);
            }
            if ((teamIdOptional = instance.getTeamId()).isPresent()) {
                this.setTeamId(teamIdOptional);
            }
            if ((avatarHashOptional = instance.getAvatarHash()).isPresent()) {
                this.setAvatarHash(avatarHashOptional);
            }
            if ((imageOriginalOptional = instance.getImageOriginal()).isPresent()) {
                this.setImageOriginal(imageOriginalOptional);
            }
            if ((image24Optional = instance.getImage24()).isPresent()) {
                this.setImage24(image24Optional);
            }
            if ((image32Optional = instance.getImage32()).isPresent()) {
                this.setImage32(image32Optional);
            }
            if ((image48Optional = instance.getImage48()).isPresent()) {
                this.setImage48(image48Optional);
            }
            if ((image72Optional = instance.getImage72()).isPresent()) {
                this.setImage72(image72Optional);
            }
            if ((image192Optional = instance.getImage192()).isPresent()) {
                this.setImage192(image192Optional);
            }
            if ((image512Optional = instance.getImage512()).isPresent()) {
                this.setImage512(image512Optional);
            }
            if ((image1024Optional = instance.getImage1024()).isPresent()) {
                this.setImage1024(image1024Optional);
            }
            return this;
        }

        public final Builder setUsername(@Nullable String username) {
            this.username = username;
            return this;
        }

        public final Builder setUsername(Optional<String> username) {
            this.username = username.orElse(null);
            return this;
        }

        public final Builder setUsernameNormalized(@Nullable String usernameNormalized) {
            this.usernameNormalized = usernameNormalized;
            return this;
        }

        public final Builder setUsernameNormalized(Optional<String> usernameNormalized) {
            this.usernameNormalized = usernameNormalized.orElse(null);
            return this;
        }

        public final Builder setRealName(@Nullable String realName) {
            this.realName = realName;
            return this;
        }

        public final Builder setRealName(Optional<String> realName) {
            this.realName = realName.orElse(null);
            return this;
        }

        public final Builder setRealNameNormalized(@Nullable String realNameNormalized) {
            this.realNameNormalized = realNameNormalized;
            return this;
        }

        public final Builder setRealNameNormalized(Optional<String> realNameNormalized) {
            this.realNameNormalized = realNameNormalized.orElse(null);
            return this;
        }

        public final Builder setEmail(@Nullable String email) {
            this.email = email;
            return this;
        }

        public final Builder setEmail(Optional<String> email) {
            this.email = email.orElse(null);
            return this;
        }

        public final Builder setStatusText(@Nullable String statusText) {
            this.statusText = statusText;
            return this;
        }

        public final Builder setStatusText(Optional<String> statusText) {
            this.statusText = statusText.orElse(null);
            return this;
        }

        public final Builder setStatusEmoji(@Nullable String statusEmoji) {
            this.statusEmoji = statusEmoji;
            return this;
        }

        public final Builder setStatusEmoji(Optional<String> statusEmoji) {
            this.statusEmoji = statusEmoji.orElse(null);
            return this;
        }

        public final Builder setTitle(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder setTitle(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        public final Builder setPhone(@Nullable String phone) {
            this.phone = phone;
            return this;
        }

        public final Builder setPhone(Optional<String> phone) {
            this.phone = phone.orElse(null);
            return this;
        }

        public final Builder setSkype(@Nullable String skype) {
            this.skype = skype;
            return this;
        }

        public final Builder setSkype(Optional<String> skype) {
            this.skype = skype.orElse(null);
            return this;
        }

        public final Builder setTeamId(@Nullable String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final Builder setTeamId(Optional<String> teamId) {
            this.teamId = teamId.orElse(null);
            return this;
        }

        public final Builder setAvatarHash(@Nullable String avatarHash) {
            this.avatarHash = avatarHash;
            return this;
        }

        public final Builder setAvatarHash(Optional<String> avatarHash) {
            this.avatarHash = avatarHash.orElse(null);
            return this;
        }

        public final Builder setImageOriginal(@Nullable String imageOriginal) {
            this.imageOriginal = imageOriginal;
            return this;
        }

        public final Builder setImageOriginal(Optional<String> imageOriginal) {
            this.imageOriginal = imageOriginal.orElse(null);
            return this;
        }

        public final Builder setImage24(@Nullable String image24) {
            this.image24 = image24;
            return this;
        }

        public final Builder setImage24(Optional<String> image24) {
            this.image24 = image24.orElse(null);
            return this;
        }

        public final Builder setImage32(@Nullable String image32) {
            this.image32 = image32;
            return this;
        }

        public final Builder setImage32(Optional<String> image32) {
            this.image32 = image32.orElse(null);
            return this;
        }

        public final Builder setImage48(@Nullable String image48) {
            this.image48 = image48;
            return this;
        }

        public final Builder setImage48(Optional<String> image48) {
            this.image48 = image48.orElse(null);
            return this;
        }

        public final Builder setImage72(@Nullable String image72) {
            this.image72 = image72;
            return this;
        }

        public final Builder setImage72(Optional<String> image72) {
            this.image72 = image72.orElse(null);
            return this;
        }

        public final Builder setImage192(@Nullable String image192) {
            this.image192 = image192;
            return this;
        }

        public final Builder setImage192(Optional<String> image192) {
            this.image192 = image192.orElse(null);
            return this;
        }

        public final Builder setImage512(@Nullable String image512) {
            this.image512 = image512;
            return this;
        }

        public final Builder setImage512(Optional<String> image512) {
            this.image512 = image512.orElse(null);
            return this;
        }

        public final Builder setImage1024(@Nullable String image1024) {
            this.image1024 = image1024;
            return this;
        }

        public final Builder setImage1024(Optional<String> image1024) {
            this.image1024 = image1024.orElse(null);
            return this;
        }

        public UserProfile build() throws InvalidImmutableStateException {
            return new UserProfile(this.username, this.usernameNormalized, this.realName, this.realNameNormalized, this.email, this.statusText, this.statusEmoji, this.title, this.phone, this.skype, this.teamId, this.avatarHash, this.imageOriginal, this.image24, this.image32, this.image48, this.image72, this.image192, this.image512, this.image1024);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements UserProfileIF {
        Optional<String> username = Optional.empty();
        Optional<String> usernameNormalized = Optional.empty();
        Optional<String> realName = Optional.empty();
        Optional<String> realNameNormalized = Optional.empty();
        Optional<String> email = Optional.empty();
        Optional<String> statusText = Optional.empty();
        Optional<String> statusEmoji = Optional.empty();
        Optional<String> title = Optional.empty();
        Optional<String> phone = Optional.empty();
        Optional<String> skype = Optional.empty();
        Optional<String> teamId = Optional.empty();
        Optional<String> avatarHash = Optional.empty();
        Optional<String> imageOriginal = Optional.empty();
        Optional<String> image24 = Optional.empty();
        Optional<String> image32 = Optional.empty();
        Optional<String> image48 = Optional.empty();
        Optional<String> image72 = Optional.empty();
        Optional<String> image192 = Optional.empty();
        Optional<String> image512 = Optional.empty();
        Optional<String> image1024 = Optional.empty();

        Json() {
        }

        @JsonProperty(value="display_name")
        public void setUsername(Optional<String> username) {
            this.username = username;
        }

        @JsonProperty(value="display_name_normalized")
        public void setUsernameNormalized(Optional<String> usernameNormalized) {
            this.usernameNormalized = usernameNormalized;
        }

        @JsonProperty
        public void setRealName(Optional<String> realName) {
            this.realName = realName;
        }

        @JsonProperty
        public void setRealNameNormalized(Optional<String> realNameNormalized) {
            this.realNameNormalized = realNameNormalized;
        }

        @JsonProperty
        public void setEmail(Optional<String> email) {
            this.email = email;
        }

        @JsonProperty
        public void setStatusText(Optional<String> statusText) {
            this.statusText = statusText;
        }

        @JsonProperty
        public void setStatusEmoji(Optional<String> statusEmoji) {
            this.statusEmoji = statusEmoji;
        }

        @JsonProperty
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @JsonProperty
        public void setPhone(Optional<String> phone) {
            this.phone = phone;
        }

        @JsonProperty
        public void setSkype(Optional<String> skype) {
            this.skype = skype;
        }

        @JsonProperty(value="team")
        public void setTeamId(Optional<String> teamId) {
            this.teamId = teamId;
        }

        @JsonProperty
        public void setAvatarHash(Optional<String> avatarHash) {
            this.avatarHash = avatarHash;
        }

        @JsonProperty
        public void setImageOriginal(Optional<String> imageOriginal) {
            this.imageOriginal = imageOriginal;
        }

        @JsonProperty(value="image_24")
        public void setImage24(Optional<String> image24) {
            this.image24 = image24;
        }

        @JsonProperty(value="image_32")
        public void setImage32(Optional<String> image32) {
            this.image32 = image32;
        }

        @JsonProperty(value="image_48")
        public void setImage48(Optional<String> image48) {
            this.image48 = image48;
        }

        @JsonProperty(value="image_72")
        public void setImage72(Optional<String> image72) {
            this.image72 = image72;
        }

        @JsonProperty(value="image_192")
        public void setImage192(Optional<String> image192) {
            this.image192 = image192;
        }

        @JsonProperty(value="image_512")
        public void setImage512(Optional<String> image512) {
            this.image512 = image512;
        }

        @JsonProperty(value="image_1024")
        public void setImage1024(Optional<String> image1024) {
            this.image1024 = image1024;
        }

        @Override
        public Optional<String> getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUsernameNormalized() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRealName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRealNameNormalized() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEmail() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getStatusText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getStatusEmoji() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPhone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSkype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTeamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAvatarHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getImageOriginal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getImage24() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getImage32() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getImage48() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getImage72() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getImage192() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getImage512() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getImage1024() {
            throw new UnsupportedOperationException();
        }
    }
}

