/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.teams;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.teams.SlackTeamIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackTeam
implements SlackTeamIF {
    private final String id;
    private final String domain;
    @Nullable
    private final String enterpriseId;
    @Nullable
    private final String enterpriseName;

    private SlackTeam(String id, String domain, @Nullable String enterpriseId, @Nullable String enterpriseName) {
        this.id = id;
        this.domain = domain;
        this.enterpriseId = enterpriseId;
        this.enterpriseName = enterpriseName;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getDomain() {
        return this.domain;
    }

    @Override
    @JsonProperty
    public Optional<String> getEnterpriseId() {
        return Optional.ofNullable(this.enterpriseId);
    }

    @Override
    @JsonProperty
    public Optional<String> getEnterpriseName() {
        return Optional.ofNullable(this.enterpriseName);
    }

    public final SlackTeam withId(String id) {
        if (this.id.equals(id)) {
            return this;
        }
        String newValue = Objects.requireNonNull(id, "id");
        return new SlackTeam(newValue, this.domain, this.enterpriseId, this.enterpriseName);
    }

    public final SlackTeam withDomain(String domain) {
        if (this.domain.equals(domain)) {
            return this;
        }
        String newValue = Objects.requireNonNull(domain, "domain");
        return new SlackTeam(this.id, newValue, this.enterpriseId, this.enterpriseName);
    }

    public final SlackTeam withEnterpriseId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.enterpriseId, newValue)) {
            return this;
        }
        return new SlackTeam(this.id, this.domain, newValue, this.enterpriseName);
    }

    public final SlackTeam withEnterpriseId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.enterpriseId, value)) {
            return this;
        }
        return new SlackTeam(this.id, this.domain, value, this.enterpriseName);
    }

    public final SlackTeam withEnterpriseName(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.enterpriseName, newValue)) {
            return this;
        }
        return new SlackTeam(this.id, this.domain, this.enterpriseId, newValue);
    }

    public final SlackTeam withEnterpriseName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.enterpriseName, value)) {
            return this;
        }
        return new SlackTeam(this.id, this.domain, this.enterpriseId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackTeam && this.equalTo((SlackTeam)another);
    }

    private boolean equalTo(SlackTeam another) {
        return this.id.equals(another.id) && this.domain.equals(another.domain) && Objects.equals(this.enterpriseId, another.enterpriseId) && Objects.equals(this.enterpriseName, another.enterpriseName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.domain.hashCode();
        h = h * 17 + Objects.hashCode(this.enterpriseId);
        h = h * 17 + Objects.hashCode(this.enterpriseName);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackTeam{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("domain=").append(this.domain);
        if (this.enterpriseId != null) {
            builder.append(", ");
            builder.append("enterpriseId=").append(this.enterpriseId);
        }
        if (this.enterpriseName != null) {
            builder.append(", ");
            builder.append("enterpriseName=").append(this.enterpriseName);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackTeam fromJson(Json json) {
        Builder builder = SlackTeam.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.domain != null) {
            builder.setDomain(json.domain);
        }
        if (json.enterpriseId != null) {
            builder.setEnterpriseId(json.enterpriseId);
        }
        if (json.enterpriseName != null) {
            builder.setEnterpriseName(json.enterpriseName);
        }
        return builder.build();
    }

    public static SlackTeam copyOf(SlackTeamIF instance) {
        if (instance instanceof SlackTeam) {
            return (SlackTeam)instance;
        }
        return SlackTeam.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_DOMAIN = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String domain;
        @Nullable
        private String enterpriseId;
        @Nullable
        private String enterpriseName;

        private Builder() {
        }

        public final Builder from(SlackTeamIF instance) {
            Optional<String> enterpriseNameOptional;
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.getId());
            this.setDomain(instance.getDomain());
            Optional<String> enterpriseIdOptional = instance.getEnterpriseId();
            if (enterpriseIdOptional.isPresent()) {
                this.setEnterpriseId(enterpriseIdOptional);
            }
            if ((enterpriseNameOptional = instance.getEnterpriseName()).isPresent()) {
                this.setEnterpriseName(enterpriseNameOptional);
            }
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setDomain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setEnterpriseId(@Nullable String enterpriseId) {
            this.enterpriseId = enterpriseId;
            return this;
        }

        public final Builder setEnterpriseId(Optional<String> enterpriseId) {
            this.enterpriseId = enterpriseId.orElse(null);
            return this;
        }

        public final Builder setEnterpriseName(@Nullable String enterpriseName) {
            this.enterpriseName = enterpriseName;
            return this;
        }

        public final Builder setEnterpriseName(Optional<String> enterpriseName) {
            this.enterpriseName = enterpriseName.orElse(null);
            return this;
        }

        public SlackTeam build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackTeam(this.id, this.domain, this.enterpriseId, this.enterpriseName);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean domainIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.domainIsSet()) {
                attributes.add("domain");
            }
            return "Cannot build SlackTeam, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackTeamIF {
        @Nullable
        String id;
        @Nullable
        String domain;
        Optional<String> enterpriseId = Optional.empty();
        Optional<String> enterpriseName = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setDomain(String domain) {
            this.domain = domain;
        }

        @JsonProperty
        public void setEnterpriseId(Optional<String> enterpriseId) {
            this.enterpriseId = enterpriseId;
        }

        @JsonProperty
        public void setEnterpriseName(Optional<String> enterpriseName) {
            this.enterpriseName = enterpriseName;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDomain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEnterpriseId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEnterpriseName() {
            throw new UnsupportedOperationException();
        }
    }
}

