/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.group;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.group.SlackGroup;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.group.GroupsListResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class GroupsListResponse
implements GroupsListResponseIF {
    private final List<SlackGroup> groups;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private GroupsListResponse(List<SlackGroup> groups, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.groups = groups;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public List<SlackGroup> getGroups() {
        return this.groups;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final GroupsListResponse withGroups(SlackGroup ... elements) {
        List<SlackGroup> newValue = GroupsListResponse.createUnmodifiableList(false, GroupsListResponse.createSafeList(Arrays.asList(elements), true, false));
        return new GroupsListResponse(newValue, this.ok, this.responseMetadata);
    }

    public final GroupsListResponse withGroups(Iterable<? extends SlackGroup> elements) {
        if (this.groups == elements) {
            return this;
        }
        List<SlackGroup> newValue = GroupsListResponse.createUnmodifiableList(false, GroupsListResponse.createSafeList(elements, true, false));
        return new GroupsListResponse(newValue, this.ok, this.responseMetadata);
    }

    public final GroupsListResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new GroupsListResponse(this.groups, ok, this.responseMetadata);
    }

    public final GroupsListResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new GroupsListResponse(this.groups, this.ok, newValue);
    }

    public final GroupsListResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new GroupsListResponse(this.groups, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GroupsListResponse && this.equalTo((GroupsListResponse)another);
    }

    private boolean equalTo(GroupsListResponse another) {
        return this.groups.equals(another.groups) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.groups.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GroupsListResponse{");
        builder.append("groups=").append(this.groups);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static GroupsListResponse fromJson(Json json) {
        Builder builder = GroupsListResponse.builder();
        if (json.groups != null) {
            builder.addAllGroups(json.groups);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static GroupsListResponse copyOf(GroupsListResponseIF instance) {
        if (instance instanceof GroupsListResponse) {
            return (GroupsListResponse)instance;
        }
        return GroupsListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private long initBits = 1L;
        private List<SlackGroup> groups = new ArrayList<SlackGroup>();
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(GroupsListResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof GroupsListResponseIF) {
                instance = (GroupsListResponseIF)object;
                this.addAllGroups(instance.getGroups());
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
        }

        public final Builder addGroups(SlackGroup element) {
            this.groups.add(Objects.requireNonNull(element, "groups element"));
            return this;
        }

        public final Builder addGroups(SlackGroup ... elements) {
            for (SlackGroup element : elements) {
                this.groups.add(Objects.requireNonNull(element, "groups element"));
            }
            return this;
        }

        public final Builder setGroups(Iterable<? extends SlackGroup> elements) {
            this.groups.clear();
            return this.addAllGroups(elements);
        }

        public final Builder addAllGroups(Iterable<? extends SlackGroup> elements) {
            for (SlackGroup slackGroup : elements) {
                this.groups.add(Objects.requireNonNull(slackGroup, "groups element"));
            }
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public GroupsListResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new GroupsListResponse(GroupsListResponse.createUnmodifiableList(true, this.groups), this.ok, this.responseMetadata);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build GroupsListResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements GroupsListResponseIF {
        List<SlackGroup> groups = Collections.emptyList();
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setGroups(List<SlackGroup> groups) {
            this.groups = groups;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public List<SlackGroup> getGroups() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

