/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.files.SlackFile;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.files.FilesSharedPublicUrlResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class FilesSharedPublicUrlResponse
implements FilesSharedPublicUrlResponseIF {
    private final SlackFile file;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private FilesSharedPublicUrlResponse(SlackFile file, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.file = file;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public SlackFile getFile() {
        return this.file;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final FilesSharedPublicUrlResponse withFile(SlackFile file) {
        if (this.file == file) {
            return this;
        }
        SlackFile newValue = Objects.requireNonNull(file, "file");
        return new FilesSharedPublicUrlResponse(newValue, this.ok, this.responseMetadata);
    }

    public final FilesSharedPublicUrlResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new FilesSharedPublicUrlResponse(this.file, ok, this.responseMetadata);
    }

    public final FilesSharedPublicUrlResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new FilesSharedPublicUrlResponse(this.file, this.ok, newValue);
    }

    public final FilesSharedPublicUrlResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new FilesSharedPublicUrlResponse(this.file, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof FilesSharedPublicUrlResponse && this.equalTo((FilesSharedPublicUrlResponse)another);
    }

    private boolean equalTo(FilesSharedPublicUrlResponse another) {
        return this.file.equals(another.file) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.file.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("FilesSharedPublicUrlResponse{");
        builder.append("file=").append(this.file);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static FilesSharedPublicUrlResponse fromJson(Json json) {
        Builder builder = FilesSharedPublicUrlResponse.builder();
        if (json.file != null) {
            builder.setFile(json.file);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static FilesSharedPublicUrlResponse copyOf(FilesSharedPublicUrlResponseIF instance) {
        if (instance instanceof FilesSharedPublicUrlResponse) {
            return (FilesSharedPublicUrlResponse)instance;
        }
        return FilesSharedPublicUrlResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FILE = 1L;
        private static final long INIT_BIT_OK = 2L;
        private long initBits = 3L;
        @Nullable
        private SlackFile file;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FilesSharedPublicUrlResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
            if (object instanceof FilesSharedPublicUrlResponseIF) {
                instance = (FilesSharedPublicUrlResponseIF)object;
                this.setFile(instance.getFile());
            }
        }

        public final Builder setFile(SlackFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public FilesSharedPublicUrlResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new FilesSharedPublicUrlResponse(this.file, this.ok, this.responseMetadata);
        }

        private boolean fileIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.fileIsSet()) {
                attributes.add("file");
            }
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build FilesSharedPublicUrlResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements FilesSharedPublicUrlResponseIF {
        @Nullable
        SlackFile file;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setFile(SlackFile file) {
            this.file = file;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public SlackFile getFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

