/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationsRepliesResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ConversationsRepliesResponse
implements ConversationsRepliesResponseIF {
    private final List<LiteMessage> messages;
    private final boolean hasMore;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private ConversationsRepliesResponse(List<LiteMessage> messages, boolean hasMore, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.messages = messages;
        this.hasMore = hasMore;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public List<LiteMessage> getMessages() {
        return this.messages;
    }

    @Override
    @JsonProperty(value="has_more")
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final ConversationsRepliesResponse withMessages(LiteMessage ... elements) {
        List<LiteMessage> newValue = ConversationsRepliesResponse.createUnmodifiableList(false, ConversationsRepliesResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ConversationsRepliesResponse(newValue, this.hasMore, this.ok, this.responseMetadata);
    }

    public final ConversationsRepliesResponse withMessages(Iterable<? extends LiteMessage> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<LiteMessage> newValue = ConversationsRepliesResponse.createUnmodifiableList(false, ConversationsRepliesResponse.createSafeList(elements, true, false));
        return new ConversationsRepliesResponse(newValue, this.hasMore, this.ok, this.responseMetadata);
    }

    public final ConversationsRepliesResponse withHasMore(boolean hasMore) {
        if (this.hasMore == hasMore) {
            return this;
        }
        return new ConversationsRepliesResponse(this.messages, hasMore, this.ok, this.responseMetadata);
    }

    public final ConversationsRepliesResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new ConversationsRepliesResponse(this.messages, this.hasMore, ok, this.responseMetadata);
    }

    public final ConversationsRepliesResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ConversationsRepliesResponse(this.messages, this.hasMore, this.ok, newValue);
    }

    public final ConversationsRepliesResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ConversationsRepliesResponse(this.messages, this.hasMore, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationsRepliesResponse && this.equalTo((ConversationsRepliesResponse)another);
    }

    private boolean equalTo(ConversationsRepliesResponse another) {
        return this.messages.equals(another.messages) && this.hasMore == another.hasMore && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.messages.hashCode();
        h = h * 17 + Boolean.hashCode(this.hasMore);
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationsRepliesResponse{");
        builder.append("messages=").append(this.messages);
        builder.append(", ");
        builder.append("hasMore=").append(this.hasMore);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ConversationsRepliesResponse fromJson(Json json) {
        Builder builder = ConversationsRepliesResponse.builder();
        if (json.messages != null) {
            builder.addAllMessages(json.messages);
        }
        if (json.hasMoreIsSet) {
            builder.setHasMore(json.hasMore);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static ConversationsRepliesResponse copyOf(ConversationsRepliesResponseIF instance) {
        if (instance instanceof ConversationsRepliesResponse) {
            return (ConversationsRepliesResponse)instance;
        }
        return ConversationsRepliesResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HAS_MORE = 1L;
        private static final long INIT_BIT_OK = 2L;
        private long initBits = 3L;
        private List<LiteMessage> messages = new ArrayList<LiteMessage>();
        private boolean hasMore;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(ConversationsRepliesResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof ConversationsRepliesResponseIF) {
                instance = (ConversationsRepliesResponseIF)object;
                this.setHasMore(instance.hasMore());
                this.addAllMessages(instance.getMessages());
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
        }

        public final Builder addMessages(LiteMessage element) {
            this.messages.add(Objects.requireNonNull(element, "messages element"));
            return this;
        }

        public final Builder addMessages(LiteMessage ... elements) {
            for (LiteMessage element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder setMessages(Iterable<? extends LiteMessage> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<? extends LiteMessage> elements) {
            for (LiteMessage liteMessage : elements) {
                this.messages.add(Objects.requireNonNull(liteMessage, "messages element"));
            }
            return this;
        }

        public final Builder setHasMore(boolean hasMore) {
            this.hasMore = hasMore;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public ConversationsRepliesResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ConversationsRepliesResponse(ConversationsRepliesResponse.createUnmodifiableList(true, this.messages), this.hasMore, this.ok, this.responseMetadata);
        }

        private boolean hasMoreIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.hasMoreIsSet()) {
                attributes.add("hasMore");
            }
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build ConversationsRepliesResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ConversationsRepliesResponseIF {
        List<LiteMessage> messages = Collections.emptyList();
        boolean hasMore;
        boolean hasMoreIsSet;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setMessages(List<LiteMessage> messages) {
            this.messages = messages;
        }

        @JsonProperty(value="has_more")
        public void setHasMore(boolean hasMore) {
            this.hasMore = hasMore;
            this.hasMoreIsSet = true;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public List<LiteMessage> getMessages() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasMore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

