/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.chat.ChatGetPermalinkResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ChatGetPermalinkResponse
implements ChatGetPermalinkResponseIF {
    private final String channel;
    private final String permalink;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private ChatGetPermalinkResponse(String channel, String permalink, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.channel = channel;
        this.permalink = permalink;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public String getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public String getPermalink() {
        return this.permalink;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final ChatGetPermalinkResponse withChannel(String channel) {
        if (this.channel.equals(channel)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channel, "channel");
        return new ChatGetPermalinkResponse(newValue, this.permalink, this.ok, this.responseMetadata);
    }

    public final ChatGetPermalinkResponse withPermalink(String permalink) {
        if (this.permalink.equals(permalink)) {
            return this;
        }
        String newValue = Objects.requireNonNull(permalink, "permalink");
        return new ChatGetPermalinkResponse(this.channel, newValue, this.ok, this.responseMetadata);
    }

    public final ChatGetPermalinkResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new ChatGetPermalinkResponse(this.channel, this.permalink, ok, this.responseMetadata);
    }

    public final ChatGetPermalinkResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ChatGetPermalinkResponse(this.channel, this.permalink, this.ok, newValue);
    }

    public final ChatGetPermalinkResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ChatGetPermalinkResponse(this.channel, this.permalink, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatGetPermalinkResponse && this.equalTo((ChatGetPermalinkResponse)another);
    }

    private boolean equalTo(ChatGetPermalinkResponse another) {
        return this.channel.equals(another.channel) && this.permalink.equals(another.permalink) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channel.hashCode();
        h = h * 17 + this.permalink.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatGetPermalinkResponse{");
        builder.append("channel=").append(this.channel);
        builder.append(", ");
        builder.append("permalink=").append(this.permalink);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ChatGetPermalinkResponse fromJson(Json json) {
        Builder builder = ChatGetPermalinkResponse.builder();
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.permalink != null) {
            builder.setPermalink(json.permalink);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static ChatGetPermalinkResponse copyOf(ChatGetPermalinkResponseIF instance) {
        if (instance instanceof ChatGetPermalinkResponse) {
            return (ChatGetPermalinkResponse)instance;
        }
        return ChatGetPermalinkResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_PERMALINK = 2L;
        private static final long INIT_BIT_OK = 4L;
        private long initBits = 7L;
        @Nullable
        private String channel;
        @Nullable
        private String permalink;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatGetPermalinkResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
            if (object instanceof ChatGetPermalinkResponseIF) {
                instance = (ChatGetPermalinkResponseIF)object;
                this.setChannel(instance.getChannel());
                this.setPermalink(instance.getPermalink());
            }
        }

        public final Builder setChannel(String channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setPermalink(String permalink) {
            this.permalink = Objects.requireNonNull(permalink, "permalink");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public ChatGetPermalinkResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ChatGetPermalinkResponse(this.channel, this.permalink, this.ok, this.responseMetadata);
        }

        private boolean channelIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean permalinkIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            if (!this.permalinkIsSet()) {
                attributes.add("permalink");
            }
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build ChatGetPermalinkResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ChatGetPermalinkResponseIF {
        @Nullable
        String channel;
        @Nullable
        String permalink;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setChannel(String channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setPermalink(String permalink) {
            this.permalink = permalink;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public String getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPermalink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

