/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.chat.ChatDeleteResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ChatDeleteResponse
implements ChatDeleteResponseIF {
    private final String channelId;
    private final String deletedMessageTs;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private ChatDeleteResponse(String channelId, String deletedMessageTs, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.channelId = channelId;
        this.deletedMessageTs = deletedMessageTs;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="ts")
    public String getDeletedMessageTs() {
        return this.deletedMessageTs;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final ChatDeleteResponse withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new ChatDeleteResponse(newValue, this.deletedMessageTs, this.ok, this.responseMetadata);
    }

    public final ChatDeleteResponse withDeletedMessageTs(String deletedMessageTs) {
        if (this.deletedMessageTs.equals(deletedMessageTs)) {
            return this;
        }
        String newValue = Objects.requireNonNull(deletedMessageTs, "deletedMessageTs");
        return new ChatDeleteResponse(this.channelId, newValue, this.ok, this.responseMetadata);
    }

    public final ChatDeleteResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new ChatDeleteResponse(this.channelId, this.deletedMessageTs, ok, this.responseMetadata);
    }

    public final ChatDeleteResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ChatDeleteResponse(this.channelId, this.deletedMessageTs, this.ok, newValue);
    }

    public final ChatDeleteResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ChatDeleteResponse(this.channelId, this.deletedMessageTs, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatDeleteResponse && this.equalTo((ChatDeleteResponse)another);
    }

    private boolean equalTo(ChatDeleteResponse another) {
        return this.channelId.equals(another.channelId) && this.deletedMessageTs.equals(another.deletedMessageTs) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + this.deletedMessageTs.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatDeleteResponse{");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("deletedMessageTs=").append(this.deletedMessageTs);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ChatDeleteResponse fromJson(Json json) {
        Builder builder = ChatDeleteResponse.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.deletedMessageTs != null) {
            builder.setDeletedMessageTs(json.deletedMessageTs);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static ChatDeleteResponse copyOf(ChatDeleteResponseIF instance) {
        if (instance instanceof ChatDeleteResponse) {
            return (ChatDeleteResponse)instance;
        }
        return ChatDeleteResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_DELETED_MESSAGE_TS = 2L;
        private static final long INIT_BIT_OK = 4L;
        private long initBits = 7L;
        @Nullable
        private String channelId;
        @Nullable
        private String deletedMessageTs;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatDeleteResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
            if (object instanceof ChatDeleteResponseIF) {
                instance = (ChatDeleteResponseIF)object;
                this.setDeletedMessageTs(instance.getDeletedMessageTs());
                this.setChannelId(instance.getChannelId());
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setDeletedMessageTs(String deletedMessageTs) {
            this.deletedMessageTs = Objects.requireNonNull(deletedMessageTs, "deletedMessageTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public ChatDeleteResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ChatDeleteResponse(this.channelId, this.deletedMessageTs, this.ok, this.responseMetadata);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean deletedMessageTsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.deletedMessageTsIsSet()) {
                attributes.add("deletedMessageTs");
            }
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build ChatDeleteResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ChatDeleteResponseIF {
        @Nullable
        String channelId;
        @Nullable
        String deletedMessageTs;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="ts")
        public void setDeletedMessageTs(String deletedMessageTs) {
            this.deletedMessageTs = deletedMessageTs;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDeletedMessageTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

