/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.TopLevelMessageResponseType;
import com.hubspot.slack.client.models.interaction.TopLevelMessageInteractionResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class TopLevelMessageInteractionResponse
implements TopLevelMessageInteractionResponseIF {
    private final TopLevelMessageResponseType responseType;
    private final boolean replaceOriginal;
    private final boolean deleteOriginal;
    @Nullable
    private final String text;
    private final List<Attachment> attachments;

    private TopLevelMessageInteractionResponse(Builder builder) {
        this.responseType = builder.responseType;
        this.replaceOriginal = builder.replaceOriginal;
        this.text = builder.text;
        this.attachments = TopLevelMessageInteractionResponse.createUnmodifiableList(true, builder.attachments);
        this.deleteOriginal = builder.deleteOriginalIsSet() ? builder.deleteOriginal : TopLevelMessageInteractionResponseIF.super.getDeleteOriginal();
    }

    private TopLevelMessageInteractionResponse(TopLevelMessageResponseType responseType, boolean replaceOriginal, boolean deleteOriginal, @Nullable String text, List<Attachment> attachments) {
        this.responseType = responseType;
        this.replaceOriginal = replaceOriginal;
        this.deleteOriginal = deleteOriginal;
        this.text = text;
        this.attachments = attachments;
    }

    @Override
    @JsonProperty
    public TopLevelMessageResponseType getResponseType() {
        return this.responseType;
    }

    @Override
    @JsonProperty
    public boolean getReplaceOriginal() {
        return this.replaceOriginal;
    }

    @Override
    @JsonProperty
    public boolean getDeleteOriginal() {
        return this.deleteOriginal;
    }

    @Override
    @JsonProperty
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public final TopLevelMessageInteractionResponse withResponseType(TopLevelMessageResponseType responseType) {
        if (this.responseType == responseType) {
            return this;
        }
        TopLevelMessageResponseType newValue = Objects.requireNonNull(responseType, "responseType");
        return TopLevelMessageInteractionResponse.validate(new TopLevelMessageInteractionResponse(newValue, this.replaceOriginal, this.deleteOriginal, this.text, this.attachments));
    }

    public final TopLevelMessageInteractionResponse withReplaceOriginal(boolean replaceOriginal) {
        if (this.replaceOriginal == replaceOriginal) {
            return this;
        }
        return TopLevelMessageInteractionResponse.validate(new TopLevelMessageInteractionResponse(this.responseType, replaceOriginal, this.deleteOriginal, this.text, this.attachments));
    }

    public final TopLevelMessageInteractionResponse withDeleteOriginal(boolean deleteOriginal) {
        if (this.deleteOriginal == deleteOriginal) {
            return this;
        }
        return TopLevelMessageInteractionResponse.validate(new TopLevelMessageInteractionResponse(this.responseType, this.replaceOriginal, deleteOriginal, this.text, this.attachments));
    }

    public final TopLevelMessageInteractionResponse withText(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.text, newValue)) {
            return this;
        }
        return TopLevelMessageInteractionResponse.validate(new TopLevelMessageInteractionResponse(this.responseType, this.replaceOriginal, this.deleteOriginal, newValue, this.attachments));
    }

    public final TopLevelMessageInteractionResponse withText(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.text, value)) {
            return this;
        }
        return TopLevelMessageInteractionResponse.validate(new TopLevelMessageInteractionResponse(this.responseType, this.replaceOriginal, this.deleteOriginal, value, this.attachments));
    }

    public final TopLevelMessageInteractionResponse withAttachments(Attachment ... elements) {
        List<Attachment> newValue = TopLevelMessageInteractionResponse.createUnmodifiableList(false, TopLevelMessageInteractionResponse.createSafeList(Arrays.asList(elements), true, false));
        return TopLevelMessageInteractionResponse.validate(new TopLevelMessageInteractionResponse(this.responseType, this.replaceOriginal, this.deleteOriginal, this.text, newValue));
    }

    public final TopLevelMessageInteractionResponse withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = TopLevelMessageInteractionResponse.createUnmodifiableList(false, TopLevelMessageInteractionResponse.createSafeList(elements, true, false));
        return TopLevelMessageInteractionResponse.validate(new TopLevelMessageInteractionResponse(this.responseType, this.replaceOriginal, this.deleteOriginal, this.text, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TopLevelMessageInteractionResponse && this.equalTo((TopLevelMessageInteractionResponse)another);
    }

    private boolean equalTo(TopLevelMessageInteractionResponse another) {
        return this.responseType.equals((Object)another.responseType) && this.replaceOriginal == another.replaceOriginal && this.deleteOriginal == another.deleteOriginal && Objects.equals(this.text, another.text) && this.attachments.equals(another.attachments);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.responseType.hashCode();
        h = h * 17 + Boolean.hashCode(this.replaceOriginal);
        h = h * 17 + Boolean.hashCode(this.deleteOriginal);
        h = h * 17 + Objects.hashCode(this.text);
        h = h * 17 + this.attachments.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TopLevelMessageInteractionResponse{");
        builder.append("responseType=").append((Object)this.responseType);
        builder.append(", ");
        builder.append("replaceOriginal=").append(this.replaceOriginal);
        builder.append(", ");
        builder.append("deleteOriginal=").append(this.deleteOriginal);
        if (this.text != null) {
            builder.append(", ");
            builder.append("text=").append(this.text);
        }
        builder.append(", ");
        builder.append("attachments=").append(this.attachments);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static TopLevelMessageInteractionResponse fromJson(Json json) {
        Builder builder = TopLevelMessageInteractionResponse.builder();
        if (json.responseType != null) {
            builder.setResponseType(json.responseType);
        }
        if (json.replaceOriginalIsSet) {
            builder.setReplaceOriginal(json.replaceOriginal);
        }
        if (json.deleteOriginalIsSet) {
            builder.setDeleteOriginal(json.deleteOriginal);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        return builder.build();
    }

    private static TopLevelMessageInteractionResponse validate(TopLevelMessageInteractionResponse instance) {
        instance.check();
        return instance;
    }

    public static TopLevelMessageInteractionResponse copyOf(TopLevelMessageInteractionResponseIF instance) {
        if (instance instanceof TopLevelMessageInteractionResponse) {
            return (TopLevelMessageInteractionResponse)instance;
        }
        return TopLevelMessageInteractionResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESPONSE_TYPE = 1L;
        private static final long INIT_BIT_REPLACE_ORIGINAL = 2L;
        private static final long OPT_BIT_DELETE_ORIGINAL = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private TopLevelMessageResponseType responseType;
        private boolean replaceOriginal;
        private boolean deleteOriginal;
        @Nullable
        private String text;
        private List<Attachment> attachments = new ArrayList<Attachment>();

        private Builder() {
        }

        public final Builder from(TopLevelMessageInteractionResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setResponseType(instance.getResponseType());
            this.setReplaceOriginal(instance.getReplaceOriginal());
            this.setDeleteOriginal(instance.getDeleteOriginal());
            Optional<String> textOptional = instance.getText();
            if (textOptional.isPresent()) {
                this.setText(textOptional);
            }
            this.addAllAttachments(instance.getAttachments());
            return this;
        }

        public final Builder setResponseType(TopLevelMessageResponseType responseType) {
            this.responseType = Objects.requireNonNull(responseType, "responseType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setReplaceOriginal(boolean replaceOriginal) {
            this.replaceOriginal = replaceOriginal;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setDeleteOriginal(boolean deleteOriginal) {
            this.deleteOriginal = deleteOriginal;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setText(@Nullable String text) {
            this.text = text;
            return this;
        }

        public final Builder setText(Optional<String> text) {
            this.text = text.orElse(null);
            return this;
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        public TopLevelMessageInteractionResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return TopLevelMessageInteractionResponse.validate(new TopLevelMessageInteractionResponse(this));
        }

        private boolean deleteOriginalIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean responseTypeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean replaceOriginalIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.responseTypeIsSet()) {
                attributes.add("responseType");
            }
            if (!this.replaceOriginalIsSet()) {
                attributes.add("replaceOriginal");
            }
            return "Cannot build TopLevelMessageInteractionResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements TopLevelMessageInteractionResponseIF {
        @Nullable
        TopLevelMessageResponseType responseType;
        boolean replaceOriginal;
        boolean replaceOriginalIsSet;
        boolean deleteOriginal;
        boolean deleteOriginalIsSet;
        Optional<String> text = Optional.empty();
        List<Attachment> attachments = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setResponseType(TopLevelMessageResponseType responseType) {
            this.responseType = responseType;
        }

        @JsonProperty
        public void setReplaceOriginal(boolean replaceOriginal) {
            this.replaceOriginal = replaceOriginal;
            this.replaceOriginalIsSet = true;
        }

        @JsonProperty
        public void setDeleteOriginal(boolean deleteOriginal) {
            this.deleteOriginal = deleteOriginal;
            this.deleteOriginalIsSet = true;
        }

        @JsonProperty
        public void setText(Optional<String> text) {
            this.text = text;
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @Override
        public TopLevelMessageResponseType getResponseType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getReplaceOriginal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getDeleteOriginal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }
    }
}

