/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.interaction.InteractiveCallbackType;
import com.hubspot.slack.client.models.interaction.MessageActionIF;
import com.hubspot.slack.client.models.interaction.SlackInteractiveCallback;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class MessageAction
implements MessageActionIF {
    private final String triggerId;
    private final String responseUrl;
    private final LiteMessage message;
    private final InteractiveCallbackType type;
    private final String callbackId;
    private final String actionTs;
    private final String token;
    private final SlackTeam team;
    private final SlackChannel channel;
    private final SlackUserLite user;

    private MessageAction(String triggerId, String responseUrl, LiteMessage message, InteractiveCallbackType type, String callbackId, String actionTs, String token, SlackTeam team, SlackChannel channel, SlackUserLite user) {
        this.triggerId = triggerId;
        this.responseUrl = responseUrl;
        this.message = message;
        this.type = type;
        this.callbackId = callbackId;
        this.actionTs = actionTs;
        this.token = token;
        this.team = team;
        this.channel = channel;
        this.user = user;
    }

    @Override
    @JsonProperty
    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    @JsonProperty
    public String getResponseUrl() {
        return this.responseUrl;
    }

    @Override
    @JsonProperty
    public LiteMessage getMessage() {
        return this.message;
    }

    @Override
    @JsonProperty
    public InteractiveCallbackType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getCallbackId() {
        return this.callbackId;
    }

    @Override
    @JsonProperty
    public String getActionTs() {
        return this.actionTs;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public SlackTeam getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public SlackChannel getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public SlackUserLite getUser() {
        return this.user;
    }

    public final MessageAction withTriggerId(String triggerId) {
        if (this.triggerId.equals(triggerId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(triggerId, "triggerId");
        return new MessageAction(newValue, this.responseUrl, this.message, this.type, this.callbackId, this.actionTs, this.token, this.team, this.channel, this.user);
    }

    public final MessageAction withResponseUrl(String responseUrl) {
        if (this.responseUrl.equals(responseUrl)) {
            return this;
        }
        String newValue = Objects.requireNonNull(responseUrl, "responseUrl");
        return new MessageAction(this.triggerId, newValue, this.message, this.type, this.callbackId, this.actionTs, this.token, this.team, this.channel, this.user);
    }

    public final MessageAction withMessage(LiteMessage message) {
        if (this.message == message) {
            return this;
        }
        LiteMessage newValue = Objects.requireNonNull(message, "message");
        return new MessageAction(this.triggerId, this.responseUrl, newValue, this.type, this.callbackId, this.actionTs, this.token, this.team, this.channel, this.user);
    }

    public final MessageAction withType(InteractiveCallbackType type) {
        if (this.type == type) {
            return this;
        }
        InteractiveCallbackType newValue = Objects.requireNonNull(type, "type");
        return new MessageAction(this.triggerId, this.responseUrl, this.message, newValue, this.callbackId, this.actionTs, this.token, this.team, this.channel, this.user);
    }

    public final MessageAction withCallbackId(String callbackId) {
        if (this.callbackId.equals(callbackId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(callbackId, "callbackId");
        return new MessageAction(this.triggerId, this.responseUrl, this.message, this.type, newValue, this.actionTs, this.token, this.team, this.channel, this.user);
    }

    public final MessageAction withActionTs(String actionTs) {
        if (this.actionTs.equals(actionTs)) {
            return this;
        }
        String newValue = Objects.requireNonNull(actionTs, "actionTs");
        return new MessageAction(this.triggerId, this.responseUrl, this.message, this.type, this.callbackId, newValue, this.token, this.team, this.channel, this.user);
    }

    public final MessageAction withToken(String token) {
        if (this.token.equals(token)) {
            return this;
        }
        String newValue = Objects.requireNonNull(token, "token");
        return new MessageAction(this.triggerId, this.responseUrl, this.message, this.type, this.callbackId, this.actionTs, newValue, this.team, this.channel, this.user);
    }

    public final MessageAction withTeam(SlackTeam team) {
        if (this.team == team) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(team, "team");
        return new MessageAction(this.triggerId, this.responseUrl, this.message, this.type, this.callbackId, this.actionTs, this.token, newValue, this.channel, this.user);
    }

    public final MessageAction withChannel(SlackChannel channel) {
        if (this.channel == channel) {
            return this;
        }
        SlackChannel newValue = Objects.requireNonNull(channel, "channel");
        return new MessageAction(this.triggerId, this.responseUrl, this.message, this.type, this.callbackId, this.actionTs, this.token, this.team, newValue, this.user);
    }

    public final MessageAction withUser(SlackUserLite user) {
        if (this.user == user) {
            return this;
        }
        SlackUserLite newValue = Objects.requireNonNull(user, "user");
        return new MessageAction(this.triggerId, this.responseUrl, this.message, this.type, this.callbackId, this.actionTs, this.token, this.team, this.channel, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MessageAction && this.equalTo((MessageAction)another);
    }

    private boolean equalTo(MessageAction another) {
        return this.triggerId.equals(another.triggerId) && this.responseUrl.equals(another.responseUrl) && this.message.equals(another.message) && this.type.equals((Object)another.type) && this.callbackId.equals(another.callbackId) && this.actionTs.equals(another.actionTs) && this.token.equals(another.token) && this.team.equals(another.team) && this.channel.equals(another.channel) && this.user.equals(another.user);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.triggerId.hashCode();
        h = h * 17 + this.responseUrl.hashCode();
        h = h * 17 + this.message.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.callbackId.hashCode();
        h = h * 17 + this.actionTs.hashCode();
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.team.hashCode();
        h = h * 17 + this.channel.hashCode();
        h = h * 17 + this.user.hashCode();
        return h;
    }

    public String toString() {
        return "MessageAction{triggerId=" + this.triggerId + ", responseUrl=" + this.responseUrl + ", message=" + this.message + ", type=" + (Object)((Object)this.type) + ", callbackId=" + this.callbackId + ", actionTs=" + this.actionTs + ", token=" + this.token + ", team=" + this.team + ", channel=" + this.channel + ", user=" + this.user + "}";
    }

    @Deprecated
    @JsonCreator
    static MessageAction fromJson(Json json) {
        Builder builder = MessageAction.builder();
        if (json.triggerId != null) {
            builder.setTriggerId(json.triggerId);
        }
        if (json.responseUrl != null) {
            builder.setResponseUrl(json.responseUrl);
        }
        if (json.message != null) {
            builder.setMessage(json.message);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.actionTs != null) {
            builder.setActionTs(json.actionTs);
        }
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        return builder.build();
    }

    public static MessageAction copyOf(MessageActionIF instance) {
        if (instance instanceof MessageAction) {
            return (MessageAction)instance;
        }
        return MessageAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRIGGER_ID = 1L;
        private static final long INIT_BIT_RESPONSE_URL = 2L;
        private static final long INIT_BIT_MESSAGE = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private static final long INIT_BIT_CALLBACK_ID = 16L;
        private static final long INIT_BIT_ACTION_TS = 32L;
        private static final long INIT_BIT_TOKEN = 64L;
        private static final long INIT_BIT_TEAM = 128L;
        private static final long INIT_BIT_CHANNEL = 256L;
        private static final long INIT_BIT_USER = 512L;
        private long initBits = 1023L;
        @Nullable
        private String triggerId;
        @Nullable
        private String responseUrl;
        @Nullable
        private LiteMessage message;
        @Nullable
        private InteractiveCallbackType type;
        @Nullable
        private String callbackId;
        @Nullable
        private String actionTs;
        @Nullable
        private String token;
        @Nullable
        private SlackTeam team;
        @Nullable
        private SlackChannel channel;
        @Nullable
        private SlackUserLite user;

        private Builder() {
        }

        public final Builder from(SlackInteractiveCallback instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackInteractiveCallback instance;
            if (object instanceof SlackInteractiveCallback) {
                instance = (SlackInteractiveCallback)object;
                this.setCallbackId(instance.getCallbackId());
                this.setChannel(instance.getChannel());
                this.setTeam(instance.getTeam());
                this.setType(instance.getType());
                this.setActionTs(instance.getActionTs());
                this.setUser(instance.getUser());
                this.setToken(instance.getToken());
            }
            if (object instanceof MessageActionIF) {
                instance = (MessageActionIF)object;
                this.setMessage(instance.getMessage());
                this.setResponseUrl(instance.getResponseUrl());
                this.setTriggerId(instance.getTriggerId());
            }
        }

        public final Builder setTriggerId(String triggerId) {
            this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseUrl(String responseUrl) {
            this.responseUrl = Objects.requireNonNull(responseUrl, "responseUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setMessage(LiteMessage message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setType(InteractiveCallbackType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setCallbackId(String callbackId) {
            this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setActionTs(String actionTs) {
            this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setTeam(SlackTeam team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setChannel(SlackChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder setUser(SlackUserLite user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public MessageAction build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new MessageAction(this.triggerId, this.responseUrl, this.message, this.type, this.callbackId, this.actionTs, this.token, this.team, this.channel, this.user);
        }

        private boolean triggerIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean responseUrlIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean messageIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean callbackIdIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean actionTsIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean tokenIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 0x100L) == 0L;
        }

        private boolean userIsSet() {
            return (this.initBits & 0x200L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.triggerIdIsSet()) {
                attributes.add("triggerId");
            }
            if (!this.responseUrlIsSet()) {
                attributes.add("responseUrl");
            }
            if (!this.messageIsSet()) {
                attributes.add("message");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.callbackIdIsSet()) {
                attributes.add("callbackId");
            }
            if (!this.actionTsIsSet()) {
                attributes.add("actionTs");
            }
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            return "Cannot build MessageAction, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements MessageActionIF {
        @Nullable
        String triggerId;
        @Nullable
        String responseUrl;
        @Nullable
        LiteMessage message;
        @Nullable
        InteractiveCallbackType type;
        @Nullable
        String callbackId;
        @Nullable
        String actionTs;
        @Nullable
        String token;
        @Nullable
        SlackTeam team;
        @Nullable
        SlackChannel channel;
        @Nullable
        SlackUserLite user;

        Json() {
        }

        @JsonProperty
        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        @JsonProperty
        public void setResponseUrl(String responseUrl) {
            this.responseUrl = responseUrl;
        }

        @JsonProperty
        public void setMessage(LiteMessage message) {
            this.message = message;
        }

        @JsonProperty
        public void setType(InteractiveCallbackType type) {
            this.type = type;
        }

        @JsonProperty
        public void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setActionTs(String actionTs) {
            this.actionTs = actionTs;
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setTeam(SlackTeam team) {
            this.team = team;
        }

        @JsonProperty
        public void setChannel(SlackChannel channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setUser(SlackUserLite user) {
            this.user = user;
        }

        @Override
        public String getTriggerId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getResponseUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LiteMessage getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InteractiveCallbackType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeam getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackChannel getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUserLite getUser() {
            throw new UnsupportedOperationException();
        }
    }
}

