/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.files.SlackFile;
import com.hubspot.slack.client.models.files.SlackFileType;
import com.hubspot.slack.client.models.files.SlackUnknownFiletypeIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackUnknownFiletype
implements SlackUnknownFiletypeIF {
    private final String id;
    private final long createdEpochSeconds;
    private final long timestampEpochSeconds;
    private final String name;
    private final String title;
    private final String mimetype;
    private final SlackFileType filetype;
    private final String prettyType;
    private final String userId;
    private final boolean editable;
    private final long size;
    private final String mode;
    private final boolean external;
    private final boolean isPublic;
    private final boolean publicUrlShared;
    private final boolean displayAsBot;
    private final String username;
    private final String urlPrivate;
    @Nullable
    private final String urlPrivateDownload;
    private final String permalink;
    @Nullable
    private final String permalinkPublic;
    private final int commentsCount;
    @Nullable
    private final Boolean starred;
    private final List<String> channelIds;
    private final List<String> groupIds;
    private final List<String> imIds;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SlackUnknownFiletype(Builder builder) {
        this.urlPrivateDownload = builder.urlPrivateDownload;
        this.permalinkPublic = builder.permalinkPublic;
        this.starred = builder.starred;
        this.channelIds = SlackUnknownFiletype.createUnmodifiableList(true, builder.channelIds);
        this.groupIds = SlackUnknownFiletype.createUnmodifiableList(true, builder.groupIds);
        this.imIds = SlackUnknownFiletype.createUnmodifiableList(true, builder.imIds);
        if (builder.id != null) {
            this.initShim.setId(builder.id);
        }
        if (builder.createdEpochSecondsIsSet()) {
            this.initShim.setCreatedEpochSeconds(builder.createdEpochSeconds);
        }
        if (builder.timestampEpochSecondsIsSet()) {
            this.initShim.setTimestampEpochSeconds(builder.timestampEpochSeconds);
        }
        if (builder.name != null) {
            this.initShim.setName(builder.name);
        }
        if (builder.title != null) {
            this.initShim.setTitle(builder.title);
        }
        if (builder.mimetype != null) {
            this.initShim.setMimetype(builder.mimetype);
        }
        if (builder.filetype != null) {
            this.initShim.setFiletype(builder.filetype);
        }
        if (builder.prettyType != null) {
            this.initShim.setPrettyType(builder.prettyType);
        }
        if (builder.userId != null) {
            this.initShim.setUserId(builder.userId);
        }
        if (builder.editableIsSet()) {
            this.initShim.setEditable(builder.editable);
        }
        if (builder.sizeIsSet()) {
            this.initShim.setSize(builder.size);
        }
        if (builder.mode != null) {
            this.initShim.setMode(builder.mode);
        }
        if (builder.externalIsSet()) {
            this.initShim.setExternal(builder.external);
        }
        if (builder.isPublicIsSet()) {
            this.initShim.setIsPublic(builder.isPublic);
        }
        if (builder.publicUrlSharedIsSet()) {
            this.initShim.setPublicUrlShared(builder.publicUrlShared);
        }
        if (builder.displayAsBotIsSet()) {
            this.initShim.setDisplayAsBot(builder.displayAsBot);
        }
        if (builder.username != null) {
            this.initShim.setUsername(builder.username);
        }
        if (builder.urlPrivate != null) {
            this.initShim.setUrlPrivate(builder.urlPrivate);
        }
        if (builder.permalink != null) {
            this.initShim.setPermalink(builder.permalink);
        }
        if (builder.commentsCountIsSet()) {
            this.initShim.setCommentsCount(builder.commentsCount);
        }
        this.id = this.initShim.getId();
        this.createdEpochSeconds = this.initShim.getCreatedEpochSeconds();
        this.timestampEpochSeconds = this.initShim.getTimestampEpochSeconds();
        this.name = this.initShim.getName();
        this.title = this.initShim.getTitle();
        this.mimetype = this.initShim.getMimetype();
        this.filetype = this.initShim.getFiletype();
        this.prettyType = this.initShim.getPrettyType();
        this.userId = this.initShim.getUserId();
        this.editable = this.initShim.isEditable();
        this.size = this.initShim.getSize();
        this.mode = this.initShim.getMode();
        this.external = this.initShim.isExternal();
        this.isPublic = this.initShim.isPublic();
        this.publicUrlShared = this.initShim.isPublicUrlShared();
        this.displayAsBot = this.initShim.getDisplayAsBot();
        this.username = this.initShim.getUsername();
        this.urlPrivate = this.initShim.getUrlPrivate();
        this.permalink = this.initShim.getPermalink();
        this.commentsCount = this.initShim.getCommentsCount();
        this.initShim = null;
    }

    private SlackUnknownFiletype(String id, long createdEpochSeconds, long timestampEpochSeconds, String name, String title, String mimetype, SlackFileType filetype, String prettyType, String userId, boolean editable, long size, String mode, boolean external, boolean isPublic, boolean publicUrlShared, boolean displayAsBot, String username, String urlPrivate, @Nullable String urlPrivateDownload, String permalink, @Nullable String permalinkPublic, int commentsCount, @Nullable Boolean starred, List<String> channelIds, List<String> groupIds, List<String> imIds) {
        this.id = id;
        this.createdEpochSeconds = createdEpochSeconds;
        this.timestampEpochSeconds = timestampEpochSeconds;
        this.name = name;
        this.title = title;
        this.mimetype = mimetype;
        this.filetype = filetype;
        this.prettyType = prettyType;
        this.userId = userId;
        this.editable = editable;
        this.size = size;
        this.mode = mode;
        this.external = external;
        this.isPublic = isPublic;
        this.publicUrlShared = publicUrlShared;
        this.displayAsBot = displayAsBot;
        this.username = username;
        this.urlPrivate = urlPrivate;
        this.urlPrivateDownload = urlPrivateDownload;
        this.permalink = permalink;
        this.permalinkPublic = permalinkPublic;
        this.commentsCount = commentsCount;
        this.starred = starred;
        this.channelIds = channelIds;
        this.groupIds = groupIds;
        this.imIds = imIds;
        this.initShim = null;
    }

    private String getIdInitialize() {
        return SlackUnknownFiletypeIF.super.getId();
    }

    private long getCreatedEpochSecondsInitialize() {
        return SlackUnknownFiletypeIF.super.getCreatedEpochSeconds();
    }

    private long getTimestampEpochSecondsInitialize() {
        return SlackUnknownFiletypeIF.super.getTimestampEpochSeconds();
    }

    private String getNameInitialize() {
        return SlackUnknownFiletypeIF.super.getName();
    }

    private String getTitleInitialize() {
        return SlackUnknownFiletypeIF.super.getTitle();
    }

    private String getMimetypeInitialize() {
        return SlackUnknownFiletypeIF.super.getMimetype();
    }

    private SlackFileType getFiletypeInitialize() {
        return SlackUnknownFiletypeIF.super.getFiletype();
    }

    private String getPrettyTypeInitialize() {
        return SlackUnknownFiletypeIF.super.getPrettyType();
    }

    private String getUserIdInitialize() {
        return SlackUnknownFiletypeIF.super.getUserId();
    }

    private boolean isEditableInitialize() {
        return SlackUnknownFiletypeIF.super.isEditable();
    }

    private long getSizeInitialize() {
        return SlackUnknownFiletypeIF.super.getSize();
    }

    private String getModeInitialize() {
        return SlackUnknownFiletypeIF.super.getMode();
    }

    private boolean isExternalInitialize() {
        return SlackUnknownFiletypeIF.super.isExternal();
    }

    private boolean isPublicInitialize() {
        return SlackUnknownFiletypeIF.super.isPublic();
    }

    private boolean isPublicUrlSharedInitialize() {
        return SlackUnknownFiletypeIF.super.isPublicUrlShared();
    }

    private boolean getDisplayAsBotInitialize() {
        return SlackUnknownFiletypeIF.super.getDisplayAsBot();
    }

    private String getUsernameInitialize() {
        return SlackUnknownFiletypeIF.super.getUsername();
    }

    private String getUrlPrivateInitialize() {
        return SlackUnknownFiletypeIF.super.getUrlPrivate();
    }

    private String getPermalinkInitialize() {
        return SlackUnknownFiletypeIF.super.getPermalink();
    }

    private int getCommentsCountInitialize() {
        return SlackUnknownFiletypeIF.super.getCommentsCount();
    }

    @Override
    @JsonProperty
    public String getId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getId() : this.id;
    }

    @Override
    @JsonProperty
    public long getCreatedEpochSeconds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCreatedEpochSeconds() : this.createdEpochSeconds;
    }

    @Override
    @JsonProperty
    public long getTimestampEpochSeconds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTimestampEpochSeconds() : this.timestampEpochSeconds;
    }

    @Override
    @JsonProperty
    public String getName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getName() : this.name;
    }

    @Override
    @JsonProperty
    public String getTitle() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTitle() : this.title;
    }

    @Override
    @JsonProperty
    public String getMimetype() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMimetype() : this.mimetype;
    }

    @Override
    @JsonProperty
    public SlackFileType getFiletype() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFiletype() : this.filetype;
    }

    @Override
    @JsonProperty
    public String getPrettyType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPrettyType() : this.prettyType;
    }

    @Override
    @JsonProperty
    public String getUserId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUserId() : this.userId;
    }

    @Override
    @JsonProperty
    public boolean isEditable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isEditable() : this.editable;
    }

    @Override
    @JsonProperty
    public long getSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSize() : this.size;
    }

    @Override
    @JsonProperty
    public String getMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMode() : this.mode;
    }

    @Override
    @JsonProperty
    public boolean isExternal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isExternal() : this.external;
    }

    @Override
    @JsonProperty
    public boolean isPublic() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPublic() : this.isPublic;
    }

    @Override
    @JsonProperty
    public boolean isPublicUrlShared() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPublicUrlShared() : this.publicUrlShared;
    }

    @Override
    @JsonProperty
    public boolean getDisplayAsBot() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDisplayAsBot() : this.displayAsBot;
    }

    @Override
    @JsonProperty
    public String getUsername() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUsername() : this.username;
    }

    @Override
    @JsonProperty
    public String getUrlPrivate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUrlPrivate() : this.urlPrivate;
    }

    @Override
    @JsonProperty
    public Optional<String> getUrlPrivateDownload() {
        return Optional.ofNullable(this.urlPrivateDownload);
    }

    @Override
    @JsonProperty
    public String getPermalink() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPermalink() : this.permalink;
    }

    @Override
    @JsonProperty
    public Optional<String> getPermalinkPublic() {
        return Optional.ofNullable(this.permalinkPublic);
    }

    @Override
    @JsonProperty
    public int getCommentsCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCommentsCount() : this.commentsCount;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> isStarred() {
        return Optional.ofNullable(this.starred);
    }

    @Override
    @JsonProperty
    public List<String> getChannelIds() {
        return this.channelIds;
    }

    @Override
    @JsonProperty
    public List<String> getGroupIds() {
        return this.groupIds;
    }

    @Override
    @JsonProperty
    public List<String> getImIds() {
        return this.imIds;
    }

    public final SlackUnknownFiletype withId(String id) {
        if (this.id.equals(id)) {
            return this;
        }
        String newValue = Objects.requireNonNull(id, "id");
        return new SlackUnknownFiletype(newValue, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withCreatedEpochSeconds(long createdEpochSeconds) {
        if (this.createdEpochSeconds == createdEpochSeconds) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withTimestampEpochSeconds(long timestampEpochSeconds) {
        if (this.timestampEpochSeconds == timestampEpochSeconds) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        String newValue = Objects.requireNonNull(name, "name");
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, newValue, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withTitle(String title) {
        if (this.title.equals(title)) {
            return this;
        }
        String newValue = Objects.requireNonNull(title, "title");
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, newValue, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withMimetype(String mimetype) {
        if (this.mimetype.equals(mimetype)) {
            return this;
        }
        String newValue = Objects.requireNonNull(mimetype, "mimetype");
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, newValue, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withFiletype(SlackFileType filetype) {
        if (this.filetype == filetype) {
            return this;
        }
        SlackFileType newValue = Objects.requireNonNull(filetype, "filetype");
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, newValue, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withPrettyType(String prettyType) {
        if (this.prettyType.equals(prettyType)) {
            return this;
        }
        String newValue = Objects.requireNonNull(prettyType, "prettyType");
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, newValue, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withUserId(String userId) {
        if (this.userId.equals(userId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(userId, "userId");
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, newValue, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withEditable(boolean editable) {
        if (this.editable == editable) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withSize(long size) {
        if (this.size == size) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withMode(String mode) {
        if (this.mode.equals(mode)) {
            return this;
        }
        String newValue = Objects.requireNonNull(mode, "mode");
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, newValue, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withExternal(boolean external) {
        if (this.external == external) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withIsPublic(boolean isPublic) {
        if (this.isPublic == isPublic) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withPublicUrlShared(boolean publicUrlShared) {
        if (this.publicUrlShared == publicUrlShared) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withDisplayAsBot(boolean displayAsBot) {
        if (this.displayAsBot == displayAsBot) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withUsername(String username) {
        if (this.username.equals(username)) {
            return this;
        }
        String newValue = Objects.requireNonNull(username, "username");
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, newValue, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withUrlPrivate(String urlPrivate) {
        if (this.urlPrivate.equals(urlPrivate)) {
            return this;
        }
        String newValue = Objects.requireNonNull(urlPrivate, "urlPrivate");
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, newValue, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withUrlPrivateDownload(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.urlPrivateDownload, newValue)) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, newValue, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withUrlPrivateDownload(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.urlPrivateDownload, value)) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, value, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withPermalink(String permalink) {
        if (this.permalink.equals(permalink)) {
            return this;
        }
        String newValue = Objects.requireNonNull(permalink, "permalink");
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, newValue, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withPermalinkPublic(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.permalinkPublic, newValue)) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, newValue, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withPermalinkPublic(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.permalinkPublic, value)) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, value, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withCommentsCount(int commentsCount) {
        if (this.commentsCount == commentsCount) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withStarred(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.starred, newValue)) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, newValue, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withStarred(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.starred, value)) {
            return this;
        }
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, value, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withChannelIds(String ... elements) {
        List<String> newValue = SlackUnknownFiletype.createUnmodifiableList(false, SlackUnknownFiletype.createSafeList(Arrays.asList(elements), true, false));
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, newValue, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withChannelIds(Iterable<String> elements) {
        if (this.channelIds == elements) {
            return this;
        }
        List<String> newValue = SlackUnknownFiletype.createUnmodifiableList(false, SlackUnknownFiletype.createSafeList(elements, true, false));
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, newValue, this.groupIds, this.imIds);
    }

    public final SlackUnknownFiletype withGroupIds(String ... elements) {
        List<String> newValue = SlackUnknownFiletype.createUnmodifiableList(false, SlackUnknownFiletype.createSafeList(Arrays.asList(elements), true, false));
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, newValue, this.imIds);
    }

    public final SlackUnknownFiletype withGroupIds(Iterable<String> elements) {
        if (this.groupIds == elements) {
            return this;
        }
        List<String> newValue = SlackUnknownFiletype.createUnmodifiableList(false, SlackUnknownFiletype.createSafeList(elements, true, false));
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, newValue, this.imIds);
    }

    public final SlackUnknownFiletype withImIds(String ... elements) {
        List<String> newValue = SlackUnknownFiletype.createUnmodifiableList(false, SlackUnknownFiletype.createSafeList(Arrays.asList(elements), true, false));
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, newValue);
    }

    public final SlackUnknownFiletype withImIds(Iterable<String> elements) {
        if (this.imIds == elements) {
            return this;
        }
        List<String> newValue = SlackUnknownFiletype.createUnmodifiableList(false, SlackUnknownFiletype.createSafeList(elements, true, false));
        return new SlackUnknownFiletype(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackUnknownFiletype && this.equalTo((SlackUnknownFiletype)another);
    }

    private boolean equalTo(SlackUnknownFiletype another) {
        return this.id.equals(another.id) && this.createdEpochSeconds == another.createdEpochSeconds && this.timestampEpochSeconds == another.timestampEpochSeconds && this.name.equals(another.name) && this.title.equals(another.title) && this.mimetype.equals(another.mimetype) && this.filetype.equals((Object)another.filetype) && this.prettyType.equals(another.prettyType) && this.userId.equals(another.userId) && this.editable == another.editable && this.size == another.size && this.mode.equals(another.mode) && this.external == another.external && this.isPublic == another.isPublic && this.publicUrlShared == another.publicUrlShared && this.displayAsBot == another.displayAsBot && this.username.equals(another.username) && this.urlPrivate.equals(another.urlPrivate) && Objects.equals(this.urlPrivateDownload, another.urlPrivateDownload) && this.permalink.equals(another.permalink) && Objects.equals(this.permalinkPublic, another.permalinkPublic) && this.commentsCount == another.commentsCount && Objects.equals(this.starred, another.starred) && this.channelIds.equals(another.channelIds) && this.groupIds.equals(another.groupIds) && this.imIds.equals(another.imIds);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + Long.hashCode(this.createdEpochSeconds);
        h = h * 17 + Long.hashCode(this.timestampEpochSeconds);
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.title.hashCode();
        h = h * 17 + this.mimetype.hashCode();
        h = h * 17 + this.filetype.hashCode();
        h = h * 17 + this.prettyType.hashCode();
        h = h * 17 + this.userId.hashCode();
        h = h * 17 + Boolean.hashCode(this.editable);
        h = h * 17 + Long.hashCode(this.size);
        h = h * 17 + this.mode.hashCode();
        h = h * 17 + Boolean.hashCode(this.external);
        h = h * 17 + Boolean.hashCode(this.isPublic);
        h = h * 17 + Boolean.hashCode(this.publicUrlShared);
        h = h * 17 + Boolean.hashCode(this.displayAsBot);
        h = h * 17 + this.username.hashCode();
        h = h * 17 + this.urlPrivate.hashCode();
        h = h * 17 + Objects.hashCode(this.urlPrivateDownload);
        h = h * 17 + this.permalink.hashCode();
        h = h * 17 + Objects.hashCode(this.permalinkPublic);
        h = h * 17 + this.commentsCount;
        h = h * 17 + Objects.hashCode(this.starred);
        h = h * 17 + this.channelIds.hashCode();
        h = h * 17 + this.groupIds.hashCode();
        h = h * 17 + this.imIds.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackUnknownFiletype{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("createdEpochSeconds=").append(this.createdEpochSeconds);
        builder.append(", ");
        builder.append("timestampEpochSeconds=").append(this.timestampEpochSeconds);
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("title=").append(this.title);
        builder.append(", ");
        builder.append("mimetype=").append(this.mimetype);
        builder.append(", ");
        builder.append("filetype=").append((Object)this.filetype);
        builder.append(", ");
        builder.append("prettyType=").append(this.prettyType);
        builder.append(", ");
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("editable=").append(this.editable);
        builder.append(", ");
        builder.append("size=").append(this.size);
        builder.append(", ");
        builder.append("mode=").append(this.mode);
        builder.append(", ");
        builder.append("external=").append(this.external);
        builder.append(", ");
        builder.append("isPublic=").append(this.isPublic);
        builder.append(", ");
        builder.append("publicUrlShared=").append(this.publicUrlShared);
        builder.append(", ");
        builder.append("displayAsBot=").append(this.displayAsBot);
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("urlPrivate=").append(this.urlPrivate);
        if (this.urlPrivateDownload != null) {
            builder.append(", ");
            builder.append("urlPrivateDownload=").append(this.urlPrivateDownload);
        }
        builder.append(", ");
        builder.append("permalink=").append(this.permalink);
        if (this.permalinkPublic != null) {
            builder.append(", ");
            builder.append("permalinkPublic=").append(this.permalinkPublic);
        }
        builder.append(", ");
        builder.append("commentsCount=").append(this.commentsCount);
        if (this.starred != null) {
            builder.append(", ");
            builder.append("starred=").append(this.starred);
        }
        builder.append(", ");
        builder.append("channelIds=").append(this.channelIds);
        builder.append(", ");
        builder.append("groupIds=").append(this.groupIds);
        builder.append(", ");
        builder.append("imIds=").append(this.imIds);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackUnknownFiletype fromJson(Json json) {
        Builder builder = SlackUnknownFiletype.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.createdEpochSecondsIsSet) {
            builder.setCreatedEpochSeconds(json.createdEpochSeconds);
        }
        if (json.timestampEpochSecondsIsSet) {
            builder.setTimestampEpochSeconds(json.timestampEpochSeconds);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.mimetype != null) {
            builder.setMimetype(json.mimetype);
        }
        if (json.filetype != null) {
            builder.setFiletype(json.filetype);
        }
        if (json.prettyType != null) {
            builder.setPrettyType(json.prettyType);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.editableIsSet) {
            builder.setEditable(json.editable);
        }
        if (json.sizeIsSet) {
            builder.setSize(json.size);
        }
        if (json.mode != null) {
            builder.setMode(json.mode);
        }
        if (json.externalIsSet) {
            builder.setExternal(json.external);
        }
        if (json.isPublicIsSet) {
            builder.setIsPublic(json.isPublic);
        }
        if (json.publicUrlSharedIsSet) {
            builder.setPublicUrlShared(json.publicUrlShared);
        }
        if (json.displayAsBotIsSet) {
            builder.setDisplayAsBot(json.displayAsBot);
        }
        if (json.username != null) {
            builder.setUsername(json.username);
        }
        if (json.urlPrivate != null) {
            builder.setUrlPrivate(json.urlPrivate);
        }
        if (json.urlPrivateDownload != null) {
            builder.setUrlPrivateDownload(json.urlPrivateDownload);
        }
        if (json.permalink != null) {
            builder.setPermalink(json.permalink);
        }
        if (json.permalinkPublic != null) {
            builder.setPermalinkPublic(json.permalinkPublic);
        }
        if (json.commentsCountIsSet) {
            builder.setCommentsCount(json.commentsCount);
        }
        if (json.starred != null) {
            builder.setStarred(json.starred);
        }
        if (json.channelIds != null) {
            builder.addAllChannelIds(json.channelIds);
        }
        if (json.groupIds != null) {
            builder.addAllGroupIds(json.groupIds);
        }
        if (json.imIds != null) {
            builder.addAllImIds(json.imIds);
        }
        return builder.build();
    }

    public static SlackUnknownFiletype copyOf(SlackUnknownFiletypeIF instance) {
        if (instance instanceof SlackUnknownFiletype) {
            return (SlackUnknownFiletype)instance;
        }
        return SlackUnknownFiletype.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_CREATED_EPOCH_SECONDS = 1L;
        private static final long OPT_BIT_TIMESTAMP_EPOCH_SECONDS = 2L;
        private static final long OPT_BIT_EDITABLE = 4L;
        private static final long OPT_BIT_SIZE = 8L;
        private static final long OPT_BIT_EXTERNAL = 16L;
        private static final long OPT_BIT_IS_PUBLIC = 32L;
        private static final long OPT_BIT_PUBLIC_URL_SHARED = 64L;
        private static final long OPT_BIT_DISPLAY_AS_BOT = 128L;
        private static final long OPT_BIT_COMMENTS_COUNT = 256L;
        private long optBits;
        @Nullable
        private String id;
        private long createdEpochSeconds;
        private long timestampEpochSeconds;
        @Nullable
        private String name;
        @Nullable
        private String title;
        @Nullable
        private String mimetype;
        @Nullable
        private SlackFileType filetype;
        @Nullable
        private String prettyType;
        @Nullable
        private String userId;
        private boolean editable;
        private long size;
        @Nullable
        private String mode;
        private boolean external;
        private boolean isPublic;
        private boolean publicUrlShared;
        private boolean displayAsBot;
        @Nullable
        private String username;
        @Nullable
        private String urlPrivate;
        @Nullable
        private String urlPrivateDownload;
        @Nullable
        private String permalink;
        @Nullable
        private String permalinkPublic;
        private int commentsCount;
        @Nullable
        private Boolean starred;
        private List<String> channelIds = new ArrayList<String>();
        private List<String> groupIds = new ArrayList<String>();
        private List<String> imIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(SlackUnknownFiletypeIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<String> permalinkPublicOptional;
            Optional<Boolean> starredOptional;
            Optional<String> urlPrivateDownloadOptional;
            SlackFile instance;
            long bits = 0L;
            if (object instanceof SlackUnknownFiletypeIF) {
                instance = (SlackUnknownFiletypeIF)object;
                if ((bits & 1L) == 0L) {
                    this.setFiletype(instance.getFiletype());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setTitle(instance.getTitle());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.setDisplayAsBot(instance.getDisplayAsBot());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllImIds(instance.getImIds());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    urlPrivateDownloadOptional = instance.getUrlPrivateDownload();
                    if (urlPrivateDownloadOptional.isPresent()) {
                        this.setUrlPrivateDownload(urlPrivateDownloadOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setMode(instance.getMode());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    starredOptional = instance.isStarred();
                    if (starredOptional.isPresent()) {
                        this.setStarred(starredOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.setUrlPrivate(instance.getUrlPrivate());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.setPrettyType(instance.getPrettyType());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.addAllGroupIds(instance.getGroupIds());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.setPublicUrlShared(instance.isPublicUrlShared());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.setTimestampEpochSeconds(instance.getTimestampEpochSeconds());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.setIsPublic(instance.isPublic());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.setId(instance.getId());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.addAllChannelIds(instance.getChannelIds());
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    this.setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    this.setEditable(instance.isEditable());
                    bits |= 0x10000L;
                }
                if ((bits & 0x20000L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 0x20000L;
                }
                if ((bits & 0x40000L) == 0L) {
                    this.setExternal(instance.isExternal());
                    bits |= 0x40000L;
                }
                if ((bits & 0x80000L) == 0L) {
                    this.setSize(instance.getSize());
                    bits |= 0x80000L;
                }
                if ((bits & 0x100000L) == 0L) {
                    this.setCommentsCount(instance.getCommentsCount());
                    bits |= 0x100000L;
                }
                if ((bits & 0x200000L) == 0L) {
                    this.setName(instance.getName());
                    bits |= 0x200000L;
                }
                if ((bits & 0x400000L) == 0L) {
                    this.setMimetype(instance.getMimetype());
                    bits |= 0x400000L;
                }
                if ((bits & 0x800000L) == 0L) {
                    permalinkPublicOptional = instance.getPermalinkPublic();
                    if (permalinkPublicOptional.isPresent()) {
                        this.setPermalinkPublic(permalinkPublicOptional);
                    }
                    bits |= 0x800000L;
                }
                if ((bits & 0x1000000L) == 0L) {
                    this.setPermalink(instance.getPermalink());
                    bits |= 0x1000000L;
                }
                if ((bits & 0x2000000L) == 0L) {
                    this.setUsername(instance.getUsername());
                    bits |= 0x2000000L;
                }
            }
            if (object instanceof SlackFile) {
                instance = (SlackFile)object;
                if ((bits & 1L) == 0L) {
                    this.setFiletype(instance.getFiletype());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setTitle(instance.getTitle());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.setDisplayAsBot(instance.getDisplayAsBot());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllImIds(instance.getImIds());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    urlPrivateDownloadOptional = instance.getUrlPrivateDownload();
                    if (urlPrivateDownloadOptional.isPresent()) {
                        this.setUrlPrivateDownload(urlPrivateDownloadOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setMode(instance.getMode());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    starredOptional = instance.isStarred();
                    if (starredOptional.isPresent()) {
                        this.setStarred(starredOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.setUrlPrivate(instance.getUrlPrivate());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.setPrettyType(instance.getPrettyType());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.addAllGroupIds(instance.getGroupIds());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.setPublicUrlShared(instance.isPublicUrlShared());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.setTimestampEpochSeconds(instance.getTimestampEpochSeconds());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.setIsPublic(instance.isPublic());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.setId(instance.getId());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.addAllChannelIds(instance.getChannelIds());
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    this.setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    this.setEditable(instance.isEditable());
                    bits |= 0x10000L;
                }
                if ((bits & 0x20000L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 0x20000L;
                }
                if ((bits & 0x40000L) == 0L) {
                    this.setExternal(instance.isExternal());
                    bits |= 0x40000L;
                }
                if ((bits & 0x80000L) == 0L) {
                    this.setSize(instance.getSize());
                    bits |= 0x80000L;
                }
                if ((bits & 0x100000L) == 0L) {
                    this.setCommentsCount(instance.getCommentsCount());
                    bits |= 0x100000L;
                }
                if ((bits & 0x200000L) == 0L) {
                    this.setName(instance.getName());
                    bits |= 0x200000L;
                }
                if ((bits & 0x400000L) == 0L) {
                    this.setMimetype(instance.getMimetype());
                    bits |= 0x400000L;
                }
                if ((bits & 0x800000L) == 0L) {
                    permalinkPublicOptional = instance.getPermalinkPublic();
                    if (permalinkPublicOptional.isPresent()) {
                        this.setPermalinkPublic(permalinkPublicOptional);
                    }
                    bits |= 0x800000L;
                }
                if ((bits & 0x1000000L) == 0L) {
                    this.setPermalink(instance.getPermalink());
                    bits |= 0x1000000L;
                }
                if ((bits & 0x2000000L) == 0L) {
                    this.setUsername(instance.getUsername());
                    bits |= 0x2000000L;
                }
            }
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        public final Builder setCreatedEpochSeconds(long createdEpochSeconds) {
            this.createdEpochSeconds = createdEpochSeconds;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setTimestampEpochSeconds(long timestampEpochSeconds) {
            this.timestampEpochSeconds = timestampEpochSeconds;
            this.optBits |= 2L;
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        public final Builder setMimetype(String mimetype) {
            this.mimetype = Objects.requireNonNull(mimetype, "mimetype");
            return this;
        }

        public final Builder setFiletype(SlackFileType filetype) {
            this.filetype = Objects.requireNonNull(filetype, "filetype");
            return this;
        }

        public final Builder setPrettyType(String prettyType) {
            this.prettyType = Objects.requireNonNull(prettyType, "prettyType");
            return this;
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            return this;
        }

        public final Builder setEditable(boolean editable) {
            this.editable = editable;
            this.optBits |= 4L;
            return this;
        }

        public final Builder setSize(long size) {
            this.size = size;
            this.optBits |= 8L;
            return this;
        }

        public final Builder setMode(String mode) {
            this.mode = Objects.requireNonNull(mode, "mode");
            return this;
        }

        public final Builder setExternal(boolean external) {
            this.external = external;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder setIsPublic(boolean isPublic) {
            this.isPublic = isPublic;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder setPublicUrlShared(boolean publicUrlShared) {
            this.publicUrlShared = publicUrlShared;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder setDisplayAsBot(boolean displayAsBot) {
            this.displayAsBot = displayAsBot;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder setUsername(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder setUrlPrivate(String urlPrivate) {
            this.urlPrivate = Objects.requireNonNull(urlPrivate, "urlPrivate");
            return this;
        }

        public final Builder setUrlPrivateDownload(@Nullable String urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload;
            return this;
        }

        public final Builder setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload.orElse(null);
            return this;
        }

        public final Builder setPermalink(String permalink) {
            this.permalink = Objects.requireNonNull(permalink, "permalink");
            return this;
        }

        public final Builder setPermalinkPublic(@Nullable String permalinkPublic) {
            this.permalinkPublic = permalinkPublic;
            return this;
        }

        public final Builder setPermalinkPublic(Optional<String> permalinkPublic) {
            this.permalinkPublic = permalinkPublic.orElse(null);
            return this;
        }

        public final Builder setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder setStarred(@Nullable Boolean starred) {
            this.starred = starred;
            return this;
        }

        public final Builder setStarred(Optional<Boolean> starred) {
            this.starred = starred.orElse(null);
            return this;
        }

        public final Builder addChannelIds(String element) {
            this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            return this;
        }

        public final Builder addChannelIds(String ... elements) {
            for (String element : elements) {
                this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            }
            return this;
        }

        public final Builder setChannelIds(Iterable<String> elements) {
            this.channelIds.clear();
            return this.addAllChannelIds(elements);
        }

        public final Builder addAllChannelIds(Iterable<String> elements) {
            for (String element : elements) {
                this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            }
            return this;
        }

        public final Builder addGroupIds(String element) {
            this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            return this;
        }

        public final Builder addGroupIds(String ... elements) {
            for (String element : elements) {
                this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            }
            return this;
        }

        public final Builder setGroupIds(Iterable<String> elements) {
            this.groupIds.clear();
            return this.addAllGroupIds(elements);
        }

        public final Builder addAllGroupIds(Iterable<String> elements) {
            for (String element : elements) {
                this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            }
            return this;
        }

        public final Builder addImIds(String element) {
            this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            return this;
        }

        public final Builder addImIds(String ... elements) {
            for (String element : elements) {
                this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            }
            return this;
        }

        public final Builder setImIds(Iterable<String> elements) {
            this.imIds.clear();
            return this.addAllImIds(elements);
        }

        public final Builder addAllImIds(Iterable<String> elements) {
            for (String element : elements) {
                this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            }
            return this;
        }

        public SlackUnknownFiletype build() throws InvalidImmutableStateException {
            return new SlackUnknownFiletype(this);
        }

        private boolean createdEpochSecondsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean timestampEpochSecondsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean editableIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean sizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean externalIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean isPublicIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean publicUrlSharedIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean displayAsBotIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean commentsCountIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackUnknownFiletypeIF {
        @Nullable
        String id;
        long createdEpochSeconds;
        boolean createdEpochSecondsIsSet;
        long timestampEpochSeconds;
        boolean timestampEpochSecondsIsSet;
        @Nullable
        String name;
        @Nullable
        String title;
        @Nullable
        String mimetype;
        @Nullable
        SlackFileType filetype;
        @Nullable
        String prettyType;
        @Nullable
        String userId;
        boolean editable;
        boolean editableIsSet;
        long size;
        boolean sizeIsSet;
        @Nullable
        String mode;
        boolean external;
        boolean externalIsSet;
        boolean isPublic;
        boolean isPublicIsSet;
        boolean publicUrlShared;
        boolean publicUrlSharedIsSet;
        boolean displayAsBot;
        boolean displayAsBotIsSet;
        @Nullable
        String username;
        @Nullable
        String urlPrivate;
        Optional<String> urlPrivateDownload = Optional.empty();
        @Nullable
        String permalink;
        Optional<String> permalinkPublic = Optional.empty();
        int commentsCount;
        boolean commentsCountIsSet;
        Optional<Boolean> starred = Optional.empty();
        List<String> channelIds = Collections.emptyList();
        List<String> groupIds = Collections.emptyList();
        List<String> imIds = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setCreatedEpochSeconds(long createdEpochSeconds) {
            this.createdEpochSeconds = createdEpochSeconds;
            this.createdEpochSecondsIsSet = true;
        }

        @JsonProperty
        public void setTimestampEpochSeconds(long timestampEpochSeconds) {
            this.timestampEpochSeconds = timestampEpochSeconds;
            this.timestampEpochSecondsIsSet = true;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty
        public void setMimetype(String mimetype) {
            this.mimetype = mimetype;
        }

        @JsonProperty
        public void setFiletype(SlackFileType filetype) {
            this.filetype = filetype;
        }

        @JsonProperty
        public void setPrettyType(String prettyType) {
            this.prettyType = prettyType;
        }

        @JsonProperty
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty
        public void setEditable(boolean editable) {
            this.editable = editable;
            this.editableIsSet = true;
        }

        @JsonProperty
        public void setSize(long size) {
            this.size = size;
            this.sizeIsSet = true;
        }

        @JsonProperty
        public void setMode(String mode) {
            this.mode = mode;
        }

        @JsonProperty
        public void setExternal(boolean external) {
            this.external = external;
            this.externalIsSet = true;
        }

        @JsonProperty
        public void setIsPublic(boolean isPublic) {
            this.isPublic = isPublic;
            this.isPublicIsSet = true;
        }

        @JsonProperty
        public void setPublicUrlShared(boolean publicUrlShared) {
            this.publicUrlShared = publicUrlShared;
            this.publicUrlSharedIsSet = true;
        }

        @JsonProperty
        public void setDisplayAsBot(boolean displayAsBot) {
            this.displayAsBot = displayAsBot;
            this.displayAsBotIsSet = true;
        }

        @JsonProperty
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty
        public void setUrlPrivate(String urlPrivate) {
            this.urlPrivate = urlPrivate;
        }

        @JsonProperty
        public void setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload;
        }

        @JsonProperty
        public void setPermalink(String permalink) {
            this.permalink = permalink;
        }

        @JsonProperty
        public void setPermalinkPublic(Optional<String> permalinkPublic) {
            this.permalinkPublic = permalinkPublic;
        }

        @JsonProperty
        public void setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.commentsCountIsSet = true;
        }

        @JsonProperty
        public void setStarred(Optional<Boolean> starred) {
            this.starred = starred;
        }

        @JsonProperty
        public void setChannelIds(List<String> channelIds) {
            this.channelIds = channelIds;
        }

        @JsonProperty
        public void setGroupIds(List<String> groupIds) {
            this.groupIds = groupIds;
        }

        @JsonProperty
        public void setImIds(List<String> imIds) {
            this.imIds = imIds;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getCreatedEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTimestampEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMimetype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackFileType getFiletype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPrettyType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEditable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isExternal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPublic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPublicUrlShared() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getDisplayAsBot() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUrlPrivate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUrlPrivateDownload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPermalink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPermalinkPublic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getCommentsCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isStarred() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getChannelIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getGroupIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getImIds() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private String id;
        private int idStage;
        private long createdEpochSeconds;
        private int createdEpochSecondsStage;
        private long timestampEpochSeconds;
        private int timestampEpochSecondsStage;
        private String name;
        private int nameStage;
        private String title;
        private int titleStage;
        private String mimetype;
        private int mimetypeStage;
        private SlackFileType filetype;
        private int filetypeStage;
        private String prettyType;
        private int prettyTypeStage;
        private String userId;
        private int userIdStage;
        private boolean editable;
        private int editableStage;
        private long size;
        private int sizeStage;
        private String mode;
        private int modeStage;
        private boolean external;
        private int externalStage;
        private boolean isPublic;
        private int isPublicStage;
        private boolean publicUrlShared;
        private int publicUrlSharedStage;
        private boolean displayAsBot;
        private int displayAsBotStage;
        private String username;
        private int usernameStage;
        private String urlPrivate;
        private int urlPrivateStage;
        private String permalink;
        private int permalinkStage;
        private int commentsCount;
        private int commentsCountStage;

        private InitShim() {
        }

        String getId() {
            if (this.idStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.idStage == 0) {
                this.idStage = -1;
                this.id = Objects.requireNonNull(SlackUnknownFiletype.this.getIdInitialize(), "id");
                this.idStage = 1;
            }
            return this.id;
        }

        void setId(String id) {
            this.id = id;
            this.idStage = 1;
        }

        long getCreatedEpochSeconds() {
            if (this.createdEpochSecondsStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.createdEpochSecondsStage == 0) {
                this.createdEpochSecondsStage = -1;
                this.createdEpochSeconds = SlackUnknownFiletype.this.getCreatedEpochSecondsInitialize();
                this.createdEpochSecondsStage = 1;
            }
            return this.createdEpochSeconds;
        }

        void setCreatedEpochSeconds(long createdEpochSeconds) {
            this.createdEpochSeconds = createdEpochSeconds;
            this.createdEpochSecondsStage = 1;
        }

        long getTimestampEpochSeconds() {
            if (this.timestampEpochSecondsStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.timestampEpochSecondsStage == 0) {
                this.timestampEpochSecondsStage = -1;
                this.timestampEpochSeconds = SlackUnknownFiletype.this.getTimestampEpochSecondsInitialize();
                this.timestampEpochSecondsStage = 1;
            }
            return this.timestampEpochSeconds;
        }

        void setTimestampEpochSeconds(long timestampEpochSeconds) {
            this.timestampEpochSeconds = timestampEpochSeconds;
            this.timestampEpochSecondsStage = 1;
        }

        String getName() {
            if (this.nameStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.nameStage == 0) {
                this.nameStage = -1;
                this.name = Objects.requireNonNull(SlackUnknownFiletype.this.getNameInitialize(), "name");
                this.nameStage = 1;
            }
            return this.name;
        }

        void setName(String name) {
            this.name = name;
            this.nameStage = 1;
        }

        String getTitle() {
            if (this.titleStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.titleStage == 0) {
                this.titleStage = -1;
                this.title = Objects.requireNonNull(SlackUnknownFiletype.this.getTitleInitialize(), "title");
                this.titleStage = 1;
            }
            return this.title;
        }

        void setTitle(String title) {
            this.title = title;
            this.titleStage = 1;
        }

        String getMimetype() {
            if (this.mimetypeStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.mimetypeStage == 0) {
                this.mimetypeStage = -1;
                this.mimetype = Objects.requireNonNull(SlackUnknownFiletype.this.getMimetypeInitialize(), "mimetype");
                this.mimetypeStage = 1;
            }
            return this.mimetype;
        }

        void setMimetype(String mimetype) {
            this.mimetype = mimetype;
            this.mimetypeStage = 1;
        }

        SlackFileType getFiletype() {
            if (this.filetypeStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.filetypeStage == 0) {
                this.filetypeStage = -1;
                this.filetype = Objects.requireNonNull(SlackUnknownFiletype.this.getFiletypeInitialize(), "filetype");
                this.filetypeStage = 1;
            }
            return this.filetype;
        }

        void setFiletype(SlackFileType filetype) {
            this.filetype = filetype;
            this.filetypeStage = 1;
        }

        String getPrettyType() {
            if (this.prettyTypeStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.prettyTypeStage == 0) {
                this.prettyTypeStage = -1;
                this.prettyType = Objects.requireNonNull(SlackUnknownFiletype.this.getPrettyTypeInitialize(), "prettyType");
                this.prettyTypeStage = 1;
            }
            return this.prettyType;
        }

        void setPrettyType(String prettyType) {
            this.prettyType = prettyType;
            this.prettyTypeStage = 1;
        }

        String getUserId() {
            if (this.userIdStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.userIdStage == 0) {
                this.userIdStage = -1;
                this.userId = Objects.requireNonNull(SlackUnknownFiletype.this.getUserIdInitialize(), "userId");
                this.userIdStage = 1;
            }
            return this.userId;
        }

        void setUserId(String userId) {
            this.userId = userId;
            this.userIdStage = 1;
        }

        boolean isEditable() {
            if (this.editableStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.editableStage == 0) {
                this.editableStage = -1;
                this.editable = SlackUnknownFiletype.this.isEditableInitialize();
                this.editableStage = 1;
            }
            return this.editable;
        }

        void setEditable(boolean editable) {
            this.editable = editable;
            this.editableStage = 1;
        }

        long getSize() {
            if (this.sizeStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.sizeStage == 0) {
                this.sizeStage = -1;
                this.size = SlackUnknownFiletype.this.getSizeInitialize();
                this.sizeStage = 1;
            }
            return this.size;
        }

        void setSize(long size) {
            this.size = size;
            this.sizeStage = 1;
        }

        String getMode() {
            if (this.modeStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.modeStage == 0) {
                this.modeStage = -1;
                this.mode = Objects.requireNonNull(SlackUnknownFiletype.this.getModeInitialize(), "mode");
                this.modeStage = 1;
            }
            return this.mode;
        }

        void setMode(String mode) {
            this.mode = mode;
            this.modeStage = 1;
        }

        boolean isExternal() {
            if (this.externalStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.externalStage == 0) {
                this.externalStage = -1;
                this.external = SlackUnknownFiletype.this.isExternalInitialize();
                this.externalStage = 1;
            }
            return this.external;
        }

        void setExternal(boolean external) {
            this.external = external;
            this.externalStage = 1;
        }

        boolean isPublic() {
            if (this.isPublicStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.isPublicStage == 0) {
                this.isPublicStage = -1;
                this.isPublic = SlackUnknownFiletype.this.isPublicInitialize();
                this.isPublicStage = 1;
            }
            return this.isPublic;
        }

        void setIsPublic(boolean isPublic) {
            this.isPublic = isPublic;
            this.isPublicStage = 1;
        }

        boolean isPublicUrlShared() {
            if (this.publicUrlSharedStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.publicUrlSharedStage == 0) {
                this.publicUrlSharedStage = -1;
                this.publicUrlShared = SlackUnknownFiletype.this.isPublicUrlSharedInitialize();
                this.publicUrlSharedStage = 1;
            }
            return this.publicUrlShared;
        }

        void setPublicUrlShared(boolean publicUrlShared) {
            this.publicUrlShared = publicUrlShared;
            this.publicUrlSharedStage = 1;
        }

        boolean getDisplayAsBot() {
            if (this.displayAsBotStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.displayAsBotStage == 0) {
                this.displayAsBotStage = -1;
                this.displayAsBot = SlackUnknownFiletype.this.getDisplayAsBotInitialize();
                this.displayAsBotStage = 1;
            }
            return this.displayAsBot;
        }

        void setDisplayAsBot(boolean displayAsBot) {
            this.displayAsBot = displayAsBot;
            this.displayAsBotStage = 1;
        }

        String getUsername() {
            if (this.usernameStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.usernameStage == 0) {
                this.usernameStage = -1;
                this.username = Objects.requireNonNull(SlackUnknownFiletype.this.getUsernameInitialize(), "username");
                this.usernameStage = 1;
            }
            return this.username;
        }

        void setUsername(String username) {
            this.username = username;
            this.usernameStage = 1;
        }

        String getUrlPrivate() {
            if (this.urlPrivateStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.urlPrivateStage == 0) {
                this.urlPrivateStage = -1;
                this.urlPrivate = Objects.requireNonNull(SlackUnknownFiletype.this.getUrlPrivateInitialize(), "urlPrivate");
                this.urlPrivateStage = 1;
            }
            return this.urlPrivate;
        }

        void setUrlPrivate(String urlPrivate) {
            this.urlPrivate = urlPrivate;
            this.urlPrivateStage = 1;
        }

        String getPermalink() {
            if (this.permalinkStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.permalinkStage == 0) {
                this.permalinkStage = -1;
                this.permalink = Objects.requireNonNull(SlackUnknownFiletype.this.getPermalinkInitialize(), "permalink");
                this.permalinkStage = 1;
            }
            return this.permalink;
        }

        void setPermalink(String permalink) {
            this.permalink = permalink;
            this.permalinkStage = 1;
        }

        int getCommentsCount() {
            if (this.commentsCountStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.commentsCountStage == 0) {
                this.commentsCountStage = -1;
                this.commentsCount = SlackUnknownFiletype.this.getCommentsCountInitialize();
                this.commentsCountStage = 1;
            }
            return this.commentsCount;
        }

        void setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.commentsCountStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.idStage == -1) {
                attributes.add("id");
            }
            if (this.createdEpochSecondsStage == -1) {
                attributes.add("createdEpochSeconds");
            }
            if (this.timestampEpochSecondsStage == -1) {
                attributes.add("timestampEpochSeconds");
            }
            if (this.nameStage == -1) {
                attributes.add("name");
            }
            if (this.titleStage == -1) {
                attributes.add("title");
            }
            if (this.mimetypeStage == -1) {
                attributes.add("mimetype");
            }
            if (this.filetypeStage == -1) {
                attributes.add("filetype");
            }
            if (this.prettyTypeStage == -1) {
                attributes.add("prettyType");
            }
            if (this.userIdStage == -1) {
                attributes.add("userId");
            }
            if (this.editableStage == -1) {
                attributes.add("editable");
            }
            if (this.sizeStage == -1) {
                attributes.add("size");
            }
            if (this.modeStage == -1) {
                attributes.add("mode");
            }
            if (this.externalStage == -1) {
                attributes.add("external");
            }
            if (this.isPublicStage == -1) {
                attributes.add("isPublic");
            }
            if (this.publicUrlSharedStage == -1) {
                attributes.add("publicUrlShared");
            }
            if (this.displayAsBotStage == -1) {
                attributes.add("displayAsBot");
            }
            if (this.usernameStage == -1) {
                attributes.add("username");
            }
            if (this.urlPrivateStage == -1) {
                attributes.add("urlPrivate");
            }
            if (this.permalinkStage == -1) {
                attributes.add("permalink");
            }
            if (this.commentsCountStage == -1) {
                attributes.add("commentsCount");
            }
            return "Cannot build SlackUnknownFiletype, attribute initializers form cycle" + attributes;
        }
    }
}

