/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.interceptor.HasUser;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventMessageBase;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.SlackMessageSubtype;
import com.hubspot.slack.client.models.events.util.AbstractSlackReplyMessage;
import com.hubspot.slack.client.models.events.util.Reply;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackReplyMessage
extends AbstractSlackReplyMessage {
    private final String threadTs;
    private final String userId;
    private final String channelId;
    private final int replyCount;
    @Nullable
    private final List<String> replyUserIds;
    @Nullable
    private final Integer replyUsersCount;
    @Nullable
    private final String latestReplyTimestamp;
    private final List<Reply> replies;
    @Nullable
    private final SlackMessageSubtype subtype;
    private final SlackEventType type;
    private final String ts;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SlackReplyMessage(Builder builder) {
        this.threadTs = builder.threadTs;
        this.userId = builder.userId;
        this.channelId = builder.channelId;
        this.replyUserIds = builder.replyUserIds;
        this.replyUsersCount = builder.replyUsersCount;
        this.latestReplyTimestamp = builder.latestReplyTimestamp;
        this.subtype = builder.subtype;
        this.type = builder.type;
        this.ts = builder.ts;
        if (builder.replyCountIsSet()) {
            this.initShim.setReplyCount(builder.replyCount);
        }
        if (builder.repliesIsSet()) {
            this.initShim.setReplies(SlackReplyMessage.createUnmodifiableList(true, builder.replies));
        }
        this.replyCount = this.initShim.getReplyCount();
        this.replies = this.initShim.getReplies();
        this.initShim = null;
    }

    private SlackReplyMessage(String threadTs, String userId, String channelId, int replyCount, @Nullable List<String> replyUserIds, @Nullable Integer replyUsersCount, @Nullable String latestReplyTimestamp, List<Reply> replies, @Nullable SlackMessageSubtype subtype, SlackEventType type, String ts) {
        this.threadTs = threadTs;
        this.userId = userId;
        this.channelId = channelId;
        this.replyCount = replyCount;
        this.replyUserIds = replyUserIds;
        this.replyUsersCount = replyUsersCount;
        this.latestReplyTimestamp = latestReplyTimestamp;
        this.replies = replies;
        this.subtype = subtype;
        this.type = type;
        this.ts = ts;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public String getThreadTs() {
        return this.threadTs;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public int getReplyCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getReplyCount() : this.replyCount;
    }

    @Override
    @JsonProperty(value="reply_users")
    public Optional<List<String>> getReplyUserIds() {
        return Optional.ofNullable(this.replyUserIds);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getReplyUsersCount() {
        return Optional.ofNullable(this.replyUsersCount);
    }

    @Override
    @JsonProperty(value="latest_reply")
    public Optional<String> getLatestReplyTimestamp() {
        return Optional.ofNullable(this.latestReplyTimestamp);
    }

    @Override
    @JsonProperty
    @Deprecated
    public List<Reply> getReplies() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getReplies() : this.replies;
    }

    @Override
    @JsonProperty
    public Optional<SlackMessageSubtype> getSubtype() {
        return Optional.ofNullable(this.subtype);
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    public final SlackReplyMessage withThreadTs(String threadTs) {
        if (this.threadTs.equals(threadTs)) {
            return this;
        }
        String newValue = Objects.requireNonNull(threadTs, "threadTs");
        return new SlackReplyMessage(newValue, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies, this.subtype, this.type, this.ts);
    }

    public final SlackReplyMessage withUserId(String userId) {
        if (this.userId.equals(userId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(userId, "userId");
        return new SlackReplyMessage(this.threadTs, newValue, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies, this.subtype, this.type, this.ts);
    }

    public final SlackReplyMessage withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new SlackReplyMessage(this.threadTs, this.userId, newValue, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies, this.subtype, this.type, this.ts);
    }

    public final SlackReplyMessage withReplyCount(int replyCount) {
        if (this.replyCount == replyCount) {
            return this;
        }
        return new SlackReplyMessage(this.threadTs, this.userId, this.channelId, replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies, this.subtype, this.type, this.ts);
    }

    public final SlackReplyMessage withReplyUserIds(@Nullable List<String> value) {
        List<String> newValue = value;
        if (this.replyUserIds == newValue) {
            return this;
        }
        return new SlackReplyMessage(this.threadTs, this.userId, this.channelId, this.replyCount, newValue, this.replyUsersCount, this.latestReplyTimestamp, this.replies, this.subtype, this.type, this.ts);
    }

    public final SlackReplyMessage withReplyUserIds(Optional<List<String>> optional) {
        List value = optional.orElse(null);
        if (this.replyUserIds == value) {
            return this;
        }
        return new SlackReplyMessage(this.threadTs, this.userId, this.channelId, this.replyCount, value, this.replyUsersCount, this.latestReplyTimestamp, this.replies, this.subtype, this.type, this.ts);
    }

    public final SlackReplyMessage withReplyUsersCount(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.replyUsersCount, newValue)) {
            return this;
        }
        return new SlackReplyMessage(this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, newValue, this.latestReplyTimestamp, this.replies, this.subtype, this.type, this.ts);
    }

    public final SlackReplyMessage withReplyUsersCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.replyUsersCount, value)) {
            return this;
        }
        return new SlackReplyMessage(this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, value, this.latestReplyTimestamp, this.replies, this.subtype, this.type, this.ts);
    }

    public final SlackReplyMessage withLatestReplyTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.latestReplyTimestamp, newValue)) {
            return this;
        }
        return new SlackReplyMessage(this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, newValue, this.replies, this.subtype, this.type, this.ts);
    }

    public final SlackReplyMessage withLatestReplyTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.latestReplyTimestamp, value)) {
            return this;
        }
        return new SlackReplyMessage(this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, value, this.replies, this.subtype, this.type, this.ts);
    }

    @Deprecated
    public final SlackReplyMessage withReplies(Reply ... elements) {
        List<Reply> newValue = SlackReplyMessage.createUnmodifiableList(false, SlackReplyMessage.createSafeList(Arrays.asList(elements), true, false));
        return new SlackReplyMessage(this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, newValue, this.subtype, this.type, this.ts);
    }

    @Deprecated
    public final SlackReplyMessage withReplies(Iterable<? extends Reply> elements) {
        if (this.replies == elements) {
            return this;
        }
        List<Reply> newValue = SlackReplyMessage.createUnmodifiableList(false, SlackReplyMessage.createSafeList(elements, true, false));
        return new SlackReplyMessage(this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, newValue, this.subtype, this.type, this.ts);
    }

    public final SlackReplyMessage withSubtype(@Nullable SlackMessageSubtype value) {
        SlackMessageSubtype newValue = value;
        if (Objects.equals((Object)this.subtype, (Object)newValue)) {
            return this;
        }
        return new SlackReplyMessage(this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies, newValue, this.type, this.ts);
    }

    public final SlackReplyMessage withSubtype(Optional<SlackMessageSubtype> optional) {
        SlackMessageSubtype value = optional.orElse(null);
        if (Objects.equals((Object)this.subtype, (Object)value)) {
            return this;
        }
        return new SlackReplyMessage(this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies, value, this.type, this.ts);
    }

    public final SlackReplyMessage withType(SlackEventType type) {
        if (this.type == type) {
            return this;
        }
        SlackEventType newValue = Objects.requireNonNull(type, "type");
        return new SlackReplyMessage(this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies, this.subtype, newValue, this.ts);
    }

    public final SlackReplyMessage withTs(String ts) {
        if (this.ts.equals(ts)) {
            return this;
        }
        String newValue = Objects.requireNonNull(ts, "ts");
        return new SlackReplyMessage(this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies, this.subtype, this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackReplyMessage && this.equalTo((SlackReplyMessage)another);
    }

    private boolean equalTo(SlackReplyMessage another) {
        return this.threadTs.equals(another.threadTs) && this.userId.equals(another.userId) && this.channelId.equals(another.channelId) && this.replyCount == another.replyCount && Objects.equals(this.replyUserIds, another.replyUserIds) && Objects.equals(this.replyUsersCount, another.replyUsersCount) && Objects.equals(this.latestReplyTimestamp, another.latestReplyTimestamp) && this.replies.equals(another.replies) && Objects.equals((Object)this.subtype, (Object)another.subtype) && this.type.equals((Object)another.type) && this.ts.equals(another.ts);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.threadTs.hashCode();
        h = h * 17 + this.userId.hashCode();
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + this.replyCount;
        h = h * 17 + Objects.hashCode(this.replyUserIds);
        h = h * 17 + Objects.hashCode(this.replyUsersCount);
        h = h * 17 + Objects.hashCode(this.latestReplyTimestamp);
        h = h * 17 + this.replies.hashCode();
        h = h * 17 + Objects.hashCode((Object)this.subtype);
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.ts.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackReplyMessage{");
        builder.append("threadTs=").append(this.threadTs);
        builder.append(", ");
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("replyCount=").append(this.replyCount);
        if (this.replyUserIds != null) {
            builder.append(", ");
            builder.append("replyUserIds=").append(this.replyUserIds);
        }
        if (this.replyUsersCount != null) {
            builder.append(", ");
            builder.append("replyUsersCount=").append(this.replyUsersCount);
        }
        if (this.latestReplyTimestamp != null) {
            builder.append(", ");
            builder.append("latestReplyTimestamp=").append(this.latestReplyTimestamp);
        }
        builder.append(", ");
        builder.append("replies=").append(this.replies);
        if (this.subtype != null) {
            builder.append(", ");
            builder.append("subtype=").append((Object)this.subtype);
        }
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackReplyMessage fromJson(Json json) {
        Builder builder = SlackReplyMessage.builder();
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.replyCountIsSet) {
            builder.setReplyCount(json.replyCount);
        }
        if (json.replyUserIds != null) {
            builder.setReplyUserIds(json.replyUserIds);
        }
        if (json.replyUsersCount != null) {
            builder.setReplyUsersCount(json.replyUsersCount);
        }
        if (json.latestReplyTimestamp != null) {
            builder.setLatestReplyTimestamp(json.latestReplyTimestamp);
        }
        if (json.repliesIsSet) {
            builder.setReplies(json.replies);
        }
        if (json.subtype != null) {
            builder.setSubtype(json.subtype);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        return builder.build();
    }

    public static SlackReplyMessage copyOf(AbstractSlackReplyMessage instance) {
        if (instance instanceof SlackReplyMessage) {
            return (SlackReplyMessage)instance;
        }
        return SlackReplyMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_THREAD_TS = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_CHANNEL_ID = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private static final long INIT_BIT_TS = 16L;
        private static final long OPT_BIT_REPLY_COUNT = 1L;
        private static final long OPT_BIT_REPLIES = 2L;
        private long initBits = 31L;
        private long optBits;
        @Nullable
        private String threadTs;
        @Nullable
        private String userId;
        @Nullable
        private String channelId;
        private int replyCount;
        @Nullable
        private List<String> replyUserIds;
        @Nullable
        private Integer replyUsersCount;
        @Nullable
        private String latestReplyTimestamp;
        private List<Reply> replies = new ArrayList<Reply>();
        @Nullable
        private SlackMessageSubtype subtype;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String ts;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEventMessageBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HasUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractSlackReplyMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<SlackMessageSubtype> subtypeOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackEventMessageBase && (subtypeOptional = ((SlackEventMessageBase)(instance = (SlackEventMessageBase)object)).getSubtype()).isPresent()) {
                this.setSubtype(subtypeOptional);
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                this.setType(instance.getType());
                this.setTs(instance.getTs());
            }
            if (object instanceof HasUser) {
                instance = (HasUser)object;
                if ((bits & 1L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractSlackReplyMessage) {
                Optional<List<String>> replyUserIdsOptional;
                instance = (AbstractSlackReplyMessage)object;
                this.setReplyCount(((AbstractSlackReplyMessage)instance).getReplyCount());
                Optional<Integer> replyUsersCountOptional = ((AbstractSlackReplyMessage)instance).getReplyUsersCount();
                if (replyUsersCountOptional.isPresent()) {
                    this.setReplyUsersCount(replyUsersCountOptional);
                }
                if ((replyUserIdsOptional = ((AbstractSlackReplyMessage)instance).getReplyUserIds()).isPresent()) {
                    this.setReplyUserIds(replyUserIdsOptional);
                }
                this.addAllReplies(((AbstractSlackReplyMessage)instance).getReplies());
                Optional<String> latestReplyTimestampOptional = ((AbstractSlackReplyMessage)instance).getLatestReplyTimestamp();
                if (latestReplyTimestampOptional.isPresent()) {
                    this.setLatestReplyTimestamp(latestReplyTimestampOptional);
                }
                this.setThreadTs(((AbstractSlackReplyMessage)instance).getThreadTs());
                if ((bits & 1L) == 0L) {
                    this.setUserId(((AbstractSlackReplyMessage)instance).getUserId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setChannelId(((AbstractSlackReplyMessage)instance).getChannelId());
                    bits |= 2L;
                }
            }
        }

        public final Builder setThreadTs(String threadTs) {
            this.threadTs = Objects.requireNonNull(threadTs, "threadTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setReplyCount(int replyCount) {
            this.replyCount = replyCount;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setReplyUserIds(@Nullable List<String> replyUserIds) {
            this.replyUserIds = replyUserIds;
            return this;
        }

        public final Builder setReplyUserIds(Optional<List<String>> replyUserIds) {
            this.replyUserIds = replyUserIds.orElse(null);
            return this;
        }

        public final Builder setReplyUsersCount(@Nullable Integer replyUsersCount) {
            this.replyUsersCount = replyUsersCount;
            return this;
        }

        public final Builder setReplyUsersCount(Optional<Integer> replyUsersCount) {
            this.replyUsersCount = replyUsersCount.orElse(null);
            return this;
        }

        public final Builder setLatestReplyTimestamp(@Nullable String latestReplyTimestamp) {
            this.latestReplyTimestamp = latestReplyTimestamp;
            return this;
        }

        public final Builder setLatestReplyTimestamp(Optional<String> latestReplyTimestamp) {
            this.latestReplyTimestamp = latestReplyTimestamp.orElse(null);
            return this;
        }

        @Deprecated
        public final Builder addReplies(Reply element) {
            this.replies.add(Objects.requireNonNull(element, "replies element"));
            this.optBits |= 2L;
            return this;
        }

        @Deprecated
        public final Builder addReplies(Reply ... elements) {
            for (Reply element : elements) {
                this.replies.add(Objects.requireNonNull(element, "replies element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @Deprecated
        public final Builder setReplies(Iterable<? extends Reply> elements) {
            this.replies.clear();
            return this.addAllReplies(elements);
        }

        @Deprecated
        public final Builder addAllReplies(Iterable<? extends Reply> elements) {
            for (Reply reply : elements) {
                this.replies.add(Objects.requireNonNull(reply, "replies element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
            this.subtype = subtype;
            return this;
        }

        public final Builder setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype.orElse(null);
            return this;
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public SlackReplyMessage build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackReplyMessage(this);
        }

        private boolean replyCountIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean repliesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean threadTsIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.threadTsIsSet()) {
                attributes.add("threadTs");
            }
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            return "Cannot build SlackReplyMessage, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AbstractSlackReplyMessage {
        @Nullable
        String threadTs;
        @Nullable
        String userId;
        @Nullable
        String channelId;
        int replyCount;
        boolean replyCountIsSet;
        Optional<List<String>> replyUserIds = Optional.empty();
        Optional<Integer> replyUsersCount = Optional.empty();
        Optional<String> latestReplyTimestamp = Optional.empty();
        List<Reply> replies = Collections.emptyList();
        boolean repliesIsSet;
        Optional<SlackMessageSubtype> subtype = Optional.empty();
        @Nullable
        SlackEventType type;
        @Nullable
        String ts;

        Json() {
        }

        @JsonProperty
        public void setThreadTs(String threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setReplyCount(int replyCount) {
            this.replyCount = replyCount;
            this.replyCountIsSet = true;
        }

        @JsonProperty(value="reply_users")
        public void setReplyUserIds(Optional<List<String>> replyUserIds) {
            this.replyUserIds = replyUserIds;
        }

        @JsonProperty
        public void setReplyUsersCount(Optional<Integer> replyUsersCount) {
            this.replyUsersCount = replyUsersCount;
        }

        @JsonProperty(value="latest_reply")
        public void setLatestReplyTimestamp(Optional<String> latestReplyTimestamp) {
            this.latestReplyTimestamp = latestReplyTimestamp;
        }

        @JsonProperty
        public void setReplies(List<Reply> replies) {
            this.replies = replies;
            this.repliesIsSet = true;
        }

        @JsonProperty
        public void setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype;
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @Override
        public String getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getReplyCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> getReplyUserIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getReplyUsersCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLatestReplyTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Reply> getReplies() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackMessageSubtype> getSubtype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private int replyCount;
        private int replyCountStage;
        private List<Reply> replies;
        private int repliesStage;

        private InitShim() {
        }

        int getReplyCount() {
            if (this.replyCountStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.replyCountStage == 0) {
                this.replyCountStage = -1;
                this.replyCount = SlackReplyMessage.super.getReplyCount();
                this.replyCountStage = 1;
            }
            return this.replyCount;
        }

        void setReplyCount(int replyCount) {
            this.replyCount = replyCount;
            this.replyCountStage = 1;
        }

        List<Reply> getReplies() {
            if (this.repliesStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.repliesStage == 0) {
                this.repliesStage = -1;
                this.replies = SlackReplyMessage.createUnmodifiableList(false, SlackReplyMessage.createSafeList(SlackReplyMessage.super.getReplies(), true, false));
                this.repliesStage = 1;
            }
            return this.replies;
        }

        void setReplies(List<Reply> replies) {
            this.replies = replies;
            this.repliesStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.replyCountStage == -1) {
                attributes.add("replyCount");
            }
            if (this.repliesStage == -1) {
                attributes.add("replies");
            }
            return "Cannot build SlackReplyMessage, attribute initializers form cycle" + attributes;
        }
    }
}

