/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.user;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.user.SlackUserChangeEventIF;
import com.hubspot.slack.client.models.users.SlackUser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackUserChangeEvent
implements SlackUserChangeEventIF {
    private final SlackUser user;
    private final SlackEventType type;

    private SlackUserChangeEvent(SlackUser user, SlackEventType type) {
        this.user = user;
        this.type = type;
    }

    @Override
    @JsonProperty
    public SlackUser getUser() {
        return this.user;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    public final SlackUserChangeEvent withUser(SlackUser user) {
        if (this.user == user) {
            return this;
        }
        SlackUser newValue = Objects.requireNonNull(user, "user");
        return new SlackUserChangeEvent(newValue, this.type);
    }

    public final SlackUserChangeEvent withType(SlackEventType type) {
        if (this.type == type) {
            return this;
        }
        SlackEventType newValue = Objects.requireNonNull(type, "type");
        return new SlackUserChangeEvent(this.user, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackUserChangeEvent && this.equalTo((SlackUserChangeEvent)another);
    }

    private boolean equalTo(SlackUserChangeEvent another) {
        return this.user.equals(another.user) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.user.hashCode();
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "SlackUserChangeEvent{user=" + this.user + ", type=" + (Object)((Object)this.type) + "}";
    }

    @Deprecated
    @JsonCreator
    static SlackUserChangeEvent fromJson(Json json) {
        Builder builder = SlackUserChangeEvent.builder();
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    public static SlackUserChangeEvent copyOf(SlackUserChangeEventIF instance) {
        if (instance instanceof SlackUserChangeEvent) {
            return (SlackUserChangeEvent)instance;
        }
        return SlackUserChangeEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private SlackUser user;
        @Nullable
        private SlackEventType type;

        private Builder() {
        }

        public final Builder from(SlackUserChangeEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackEvent instance;
            if (object instanceof SlackUserChangeEventIF) {
                instance = (SlackUserChangeEventIF)object;
                this.setUser(instance.getUser());
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                this.setType(instance.getType());
            }
        }

        public final Builder setUser(SlackUser user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public SlackUserChangeEvent build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackUserChangeEvent(this.user, this.type);
        }

        private boolean userIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build SlackUserChangeEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackUserChangeEventIF {
        @Nullable
        SlackUser user;
        @Nullable
        SlackEventType type;

        Json() {
        }

        @JsonProperty
        public void setUser(SlackUser user) {
            this.user = user;
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @Override
        public SlackUser getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

