/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.channel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.channel.SlackChannelCreatedEventIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackChannelCreatedEvent
implements SlackChannelCreatedEventIF {
    private final SlackChannel channel;
    private final SlackEventType type;

    private SlackChannelCreatedEvent(SlackChannel channel, SlackEventType type) {
        this.channel = channel;
        this.type = type;
    }

    @Override
    @JsonProperty
    public SlackChannel getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    public final SlackChannelCreatedEvent withChannel(SlackChannel channel) {
        if (this.channel == channel) {
            return this;
        }
        SlackChannel newValue = Objects.requireNonNull(channel, "channel");
        return new SlackChannelCreatedEvent(newValue, this.type);
    }

    public final SlackChannelCreatedEvent withType(SlackEventType type) {
        if (this.type == type) {
            return this;
        }
        SlackEventType newValue = Objects.requireNonNull(type, "type");
        return new SlackChannelCreatedEvent(this.channel, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackChannelCreatedEvent && this.equalTo((SlackChannelCreatedEvent)another);
    }

    private boolean equalTo(SlackChannelCreatedEvent another) {
        return this.channel.equals(another.channel) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channel.hashCode();
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "SlackChannelCreatedEvent{channel=" + this.channel + ", type=" + (Object)((Object)this.type) + "}";
    }

    @Deprecated
    @JsonCreator
    static SlackChannelCreatedEvent fromJson(Json json) {
        Builder builder = SlackChannelCreatedEvent.builder();
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    public static SlackChannelCreatedEvent copyOf(SlackChannelCreatedEventIF instance) {
        if (instance instanceof SlackChannelCreatedEvent) {
            return (SlackChannelCreatedEvent)instance;
        }
        return SlackChannelCreatedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private SlackChannel channel;
        @Nullable
        private SlackEventType type;

        private Builder() {
        }

        public final Builder from(SlackChannelCreatedEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackEvent instance;
            if (object instanceof SlackChannelCreatedEventIF) {
                instance = (SlackChannelCreatedEventIF)object;
                this.setChannel(instance.getChannel());
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                this.setType(instance.getType());
            }
        }

        public final Builder setChannel(SlackChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public SlackChannelCreatedEvent build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackChannelCreatedEvent(this.channel, this.type);
        }

        private boolean channelIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build SlackChannelCreatedEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackChannelCreatedEventIF {
        @Nullable
        SlackChannel channel;
        @Nullable
        SlackEventType type;

        Json() {
        }

        @JsonProperty
        public void setChannel(SlackChannel channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @Override
        public SlackChannel getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

