/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.SlackEventWrapperIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackEventWrapper<T extends SlackEvent>
implements SlackEventWrapperIF<T> {
    private final String token;
    private final String teamId;
    private final SlackEventType type;
    private final List<String> authedUsers;
    private final String eventId;
    private final String eventTime;
    private final T event;

    private SlackEventWrapper(String token, String teamId, SlackEventType type, List<String> authedUsers, String eventId, String eventTime, T event) {
        this.token = token;
        this.teamId = teamId;
        this.type = type;
        this.authedUsers = authedUsers;
        this.eventId = eventId;
        this.eventTime = eventTime;
        this.event = event;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public String getTeamId() {
        return this.teamId;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public List<String> getAuthedUsers() {
        return this.authedUsers;
    }

    @Override
    @JsonProperty
    public String getEventId() {
        return this.eventId;
    }

    @Override
    @JsonProperty
    public String getEventTime() {
        return this.eventTime;
    }

    @Override
    @JsonProperty
    public T getEvent() {
        return this.event;
    }

    public final SlackEventWrapper<T> withToken(String token) {
        if (this.token.equals(token)) {
            return this;
        }
        String newValue = Objects.requireNonNull(token, "token");
        return new SlackEventWrapper<T>(newValue, this.teamId, this.type, this.authedUsers, this.eventId, this.eventTime, this.event);
    }

    public final SlackEventWrapper<T> withTeamId(String teamId) {
        if (this.teamId.equals(teamId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(teamId, "teamId");
        return new SlackEventWrapper<T>(this.token, newValue, this.type, this.authedUsers, this.eventId, this.eventTime, this.event);
    }

    public final SlackEventWrapper<T> withType(SlackEventType type) {
        if (this.type == type) {
            return this;
        }
        SlackEventType newValue = Objects.requireNonNull(type, "type");
        return new SlackEventWrapper<T>(this.token, this.teamId, newValue, this.authedUsers, this.eventId, this.eventTime, this.event);
    }

    public final SlackEventWrapper<T> withAuthedUsers(String ... elements) {
        List<String> newValue = SlackEventWrapper.createUnmodifiableList(false, SlackEventWrapper.createSafeList(Arrays.asList(elements), true, false));
        return new SlackEventWrapper<T>(this.token, this.teamId, this.type, newValue, this.eventId, this.eventTime, this.event);
    }

    public final SlackEventWrapper<T> withAuthedUsers(Iterable<String> elements) {
        if (this.authedUsers == elements) {
            return this;
        }
        List<String> newValue = SlackEventWrapper.createUnmodifiableList(false, SlackEventWrapper.createSafeList(elements, true, false));
        return new SlackEventWrapper<T>(this.token, this.teamId, this.type, newValue, this.eventId, this.eventTime, this.event);
    }

    public final SlackEventWrapper<T> withEventId(String eventId) {
        if (this.eventId.equals(eventId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(eventId, "eventId");
        return new SlackEventWrapper<T>(this.token, this.teamId, this.type, this.authedUsers, newValue, this.eventTime, this.event);
    }

    public final SlackEventWrapper<T> withEventTime(String eventTime) {
        if (this.eventTime.equals(eventTime)) {
            return this;
        }
        String newValue = Objects.requireNonNull(eventTime, "eventTime");
        return new SlackEventWrapper<T>(this.token, this.teamId, this.type, this.authedUsers, this.eventId, newValue, this.event);
    }

    public final SlackEventWrapper<T> withEvent(T event) {
        if (this.event == event) {
            return this;
        }
        SlackEvent newValue = (SlackEvent)Objects.requireNonNull(event, "event");
        return new SlackEventWrapper<SlackEvent>(this.token, this.teamId, this.type, this.authedUsers, this.eventId, this.eventTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackEventWrapper && this.equalTo((SlackEventWrapper)another);
    }

    private boolean equalTo(SlackEventWrapper<?> another) {
        return this.token.equals(another.token) && this.teamId.equals(another.teamId) && this.type.equals((Object)another.type) && this.authedUsers.equals(another.authedUsers) && this.eventId.equals(another.eventId) && this.eventTime.equals(another.eventTime) && this.event.equals(another.event);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.teamId.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.authedUsers.hashCode();
        h = h * 17 + this.eventId.hashCode();
        h = h * 17 + this.eventTime.hashCode();
        h = h * 17 + this.event.hashCode();
        return h;
    }

    public String toString() {
        return "SlackEventWrapper{token=" + this.token + ", teamId=" + this.teamId + ", type=" + (Object)((Object)this.type) + ", authedUsers=" + this.authedUsers + ", eventId=" + this.eventId + ", eventTime=" + this.eventTime + ", event=" + this.event + "}";
    }

    @Deprecated
    @JsonCreator
    static <T extends SlackEvent> SlackEventWrapper<T> fromJson(Json<T> json) {
        Builder builder = SlackEventWrapper.builder();
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.teamId != null) {
            builder.setTeamId(json.teamId);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.authedUsers != null) {
            builder.addAllAuthedUsers(json.authedUsers);
        }
        if (json.eventId != null) {
            builder.setEventId(json.eventId);
        }
        if (json.eventTime != null) {
            builder.setEventTime(json.eventTime);
        }
        if (json.event != null) {
            builder.setEvent(json.event);
        }
        return builder.build();
    }

    public static <T extends SlackEvent> SlackEventWrapper<T> copyOf(SlackEventWrapperIF<T> instance) {
        if (instance instanceof SlackEventWrapper) {
            return (SlackEventWrapper)instance;
        }
        return SlackEventWrapper.builder().from(instance).build();
    }

    public static <T extends SlackEvent> Builder<T> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    /* synthetic */ SlackEventWrapper(String x0, String x1, SlackEventType x2, List x3, String x4, String x5, SlackEvent x6, 1 x7) {
        this(x0, x1, x2, x3, x4, x5, x6);
    }

    @NotThreadSafe
    public static final class Builder<T extends SlackEvent> {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_TEAM_ID = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private static final long INIT_BIT_EVENT_ID = 8L;
        private static final long INIT_BIT_EVENT_TIME = 16L;
        private static final long INIT_BIT_EVENT = 32L;
        private long initBits = 63L;
        @Nullable
        private String token;
        @Nullable
        private String teamId;
        @Nullable
        private SlackEventType type;
        private List<String> authedUsers = new ArrayList<String>();
        @Nullable
        private String eventId;
        @Nullable
        private String eventTime;
        @Nullable
        private T event;

        private Builder() {
        }

        public final Builder<T> from(SlackEventWrapperIF<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.setToken(instance.getToken());
            this.setTeamId(instance.getTeamId());
            this.setType(instance.getType());
            this.addAllAuthedUsers(instance.getAuthedUsers());
            this.setEventId(instance.getEventId());
            this.setEventTime(instance.getEventTime());
            this.setEvent(instance.getEvent());
            return this;
        }

        public final Builder<T> setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<T> setTeamId(String teamId) {
            this.teamId = Objects.requireNonNull(teamId, "teamId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<T> setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder<T> addAuthedUsers(String element) {
            this.authedUsers.add(Objects.requireNonNull(element, "authedUsers element"));
            return this;
        }

        public final Builder<T> addAuthedUsers(String ... elements) {
            for (String element : elements) {
                this.authedUsers.add(Objects.requireNonNull(element, "authedUsers element"));
            }
            return this;
        }

        public final Builder<T> setAuthedUsers(Iterable<String> elements) {
            this.authedUsers.clear();
            return this.addAllAuthedUsers(elements);
        }

        public final Builder<T> addAllAuthedUsers(Iterable<String> elements) {
            for (String element : elements) {
                this.authedUsers.add(Objects.requireNonNull(element, "authedUsers element"));
            }
            return this;
        }

        public final Builder<T> setEventId(String eventId) {
            this.eventId = Objects.requireNonNull(eventId, "eventId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder<T> setEventTime(String eventTime) {
            this.eventTime = Objects.requireNonNull(eventTime, "eventTime");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder<T> setEvent(T event) {
            this.event = (SlackEvent)Objects.requireNonNull(event, "event");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public SlackEventWrapper<T> build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackEventWrapper(this.token, this.teamId, this.type, SlackEventWrapper.createUnmodifiableList(true, this.authedUsers), this.eventId, this.eventTime, (SlackEvent)this.event, null);
        }

        private boolean tokenIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean teamIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean eventIdIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean eventTimeIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean eventIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.teamIdIsSet()) {
                attributes.add("teamId");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.eventIdIsSet()) {
                attributes.add("eventId");
            }
            if (!this.eventTimeIsSet()) {
                attributes.add("eventTime");
            }
            if (!this.eventIsSet()) {
                attributes.add("event");
            }
            return "Cannot build SlackEventWrapper, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json<T extends SlackEvent>
    implements SlackEventWrapperIF<T> {
        @Nullable
        String token;
        @Nullable
        String teamId;
        @Nullable
        SlackEventType type;
        List<String> authedUsers = Collections.emptyList();
        @Nullable
        String eventId;
        @Nullable
        String eventTime;
        @Nullable
        T event;

        Json() {
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setAuthedUsers(List<String> authedUsers) {
            this.authedUsers = authedUsers;
        }

        @JsonProperty
        public void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @JsonProperty
        public void setEventTime(String eventTime) {
            this.eventTime = eventTime;
        }

        @JsonProperty
        public void setEvent(T event) {
            this.event = event;
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAuthedUsers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEventId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEventTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T getEvent() {
            throw new UnsupportedOperationException();
        }
    }
}

