/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.events.AbstractSlackEventMessageReplied;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventMessageBase;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.SlackMessageSubtype;
import com.hubspot.slack.client.models.events.util.SlackReplyMessage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackEventMessageReplied
extends AbstractSlackEventMessageReplied {
    private final String channelId;
    private final SlackReplyMessage message;
    @Nullable
    private final SlackMessageSubtype subtype;
    private final SlackEventType type;
    private final String ts;

    private SlackEventMessageReplied(String channelId, SlackReplyMessage message, @Nullable SlackMessageSubtype subtype, SlackEventType type, String ts) {
        this.channelId = channelId;
        this.message = message;
        this.subtype = subtype;
        this.type = type;
        this.ts = ts;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public SlackReplyMessage getMessage() {
        return this.message;
    }

    @Override
    @JsonProperty
    public Optional<SlackMessageSubtype> getSubtype() {
        return Optional.ofNullable(this.subtype);
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    public final SlackEventMessageReplied withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new SlackEventMessageReplied(newValue, this.message, this.subtype, this.type, this.ts);
    }

    public final SlackEventMessageReplied withMessage(SlackReplyMessage message) {
        if (this.message == message) {
            return this;
        }
        SlackReplyMessage newValue = Objects.requireNonNull(message, "message");
        return new SlackEventMessageReplied(this.channelId, newValue, this.subtype, this.type, this.ts);
    }

    public final SlackEventMessageReplied withSubtype(@Nullable SlackMessageSubtype value) {
        SlackMessageSubtype newValue = value;
        if (Objects.equals((Object)this.subtype, (Object)newValue)) {
            return this;
        }
        return new SlackEventMessageReplied(this.channelId, this.message, newValue, this.type, this.ts);
    }

    public final SlackEventMessageReplied withSubtype(Optional<SlackMessageSubtype> optional) {
        SlackMessageSubtype value = optional.orElse(null);
        if (Objects.equals((Object)this.subtype, (Object)value)) {
            return this;
        }
        return new SlackEventMessageReplied(this.channelId, this.message, value, this.type, this.ts);
    }

    public final SlackEventMessageReplied withType(SlackEventType type) {
        if (this.type == type) {
            return this;
        }
        SlackEventType newValue = Objects.requireNonNull(type, "type");
        return new SlackEventMessageReplied(this.channelId, this.message, this.subtype, newValue, this.ts);
    }

    public final SlackEventMessageReplied withTs(String ts) {
        if (this.ts.equals(ts)) {
            return this;
        }
        String newValue = Objects.requireNonNull(ts, "ts");
        return new SlackEventMessageReplied(this.channelId, this.message, this.subtype, this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackEventMessageReplied && this.equalTo((SlackEventMessageReplied)another);
    }

    private boolean equalTo(SlackEventMessageReplied another) {
        return this.channelId.equals(another.channelId) && this.message.equals(another.message) && Objects.equals((Object)this.subtype, (Object)another.subtype) && this.type.equals((Object)another.type) && this.ts.equals(another.ts);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + this.message.hashCode();
        h = h * 17 + Objects.hashCode((Object)this.subtype);
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.ts.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackEventMessageReplied{");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("message=").append(this.message);
        if (this.subtype != null) {
            builder.append(", ");
            builder.append("subtype=").append((Object)this.subtype);
        }
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackEventMessageReplied fromJson(Json json) {
        Builder builder = SlackEventMessageReplied.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.message != null) {
            builder.setMessage(json.message);
        }
        if (json.subtype != null) {
            builder.setSubtype(json.subtype);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        return builder.build();
    }

    public static SlackEventMessageReplied copyOf(AbstractSlackEventMessageReplied instance) {
        if (instance instanceof SlackEventMessageReplied) {
            return (SlackEventMessageReplied)instance;
        }
        return SlackEventMessageReplied.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_MESSAGE = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private static final long INIT_BIT_TS = 8L;
        private long initBits = 15L;
        @Nullable
        private String channelId;
        @Nullable
        private SlackReplyMessage message;
        @Nullable
        private SlackMessageSubtype subtype;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String ts;

        private Builder() {
        }

        public final Builder from(AbstractSlackEventMessageReplied instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEventMessageBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<SlackMessageSubtype> subtypeOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof AbstractSlackEventMessageReplied) {
                instance = (AbstractSlackEventMessageReplied)object;
                this.setMessage(((AbstractSlackEventMessageReplied)instance).getMessage());
                if ((bits & 1L) == 0L) {
                    this.setChannelId(((AbstractSlackEventMessageReplied)instance).getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof SlackEventMessageBase && (subtypeOptional = ((SlackEventMessageBase)(instance = (SlackEventMessageBase)object)).getSubtype()).isPresent()) {
                this.setSubtype(subtypeOptional);
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                this.setType(instance.getType());
                this.setTs(instance.getTs());
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setMessage(SlackReplyMessage message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
            this.subtype = subtype;
            return this;
        }

        public final Builder setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype.orElse(null);
            return this;
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public SlackEventMessageReplied build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackEventMessageReplied(this.channelId, this.message, this.subtype, this.type, this.ts);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean messageIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.messageIsSet()) {
                attributes.add("message");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            return "Cannot build SlackEventMessageReplied, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AbstractSlackEventMessageReplied {
        @Nullable
        String channelId;
        @Nullable
        SlackReplyMessage message;
        Optional<SlackMessageSubtype> subtype = Optional.empty();
        @Nullable
        SlackEventType type;
        @Nullable
        String ts;

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setMessage(SlackReplyMessage message) {
            this.message = message;
        }

        @JsonProperty
        public void setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype;
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackReplyMessage getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackMessageSubtype> getSubtype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }
    }
}

