/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements;

import com.hubspot.slack.client.models.dialog.form.SlackFormElementSubtypes;
import com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElement;
import java.util.Optional;
import org.immutables.value.Value;

public abstract class AbstractSlackDialogFormTextElement
extends SlackDialogFormElement {
    public abstract Optional<SlackFormElementSubtypes> getSubtype();

    public abstract Optional<String> getHint();

    @Value.Default
    public int getMinLength() {
        return 0;
    }

    @Value.Default
    public int getMaxLength() {
        return 150;
    }

    public abstract Optional<String> getValue();

    protected void validateBaseTextElementProps() {
        super.validateBaseElementProperties();
        if (this.getMinLength() < 0) {
            throw new IllegalStateException("Min length cannot be negative, got " + this.getMinLength());
        }
        if (this.getMaxLength() < 0) {
            throw new IllegalStateException("Max length cannot be negative, got " + this.getMaxLength());
        }
        if (this.getMinLength() > this.getMaxLength()) {
            throw new IllegalStateException("Min length must be <= max length, got " + this.getMinLength() + ", " + this.getMaxLength());
        }
        if (this.getHint().isPresent() && this.getHint().get().length() > 150) {
            throw new IllegalStateException("Hint cannot exceed 150 chars, got '" + this.getHint().get() + "'");
        }
    }
}

