/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.ImageIF;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class Image
implements ImageIF {
    private final String type;
    private final String imageUrl;
    private final String altText;
    @Nullable
    private final Text title;
    @Nullable
    private final String blockId;

    private Image(String imageUrl, String altText) {
        this.imageUrl = Objects.requireNonNull(imageUrl, "imageUrl");
        this.altText = Objects.requireNonNull(altText, "altText");
        this.title = null;
        this.blockId = null;
        this.type = Objects.requireNonNull(ImageIF.super.getType(), "type");
    }

    private Image(String imageUrl, String altText, @Nullable Text title, @Nullable String blockId) {
        this.imageUrl = imageUrl;
        this.altText = altText;
        this.title = title;
        this.blockId = blockId;
        this.type = Objects.requireNonNull(ImageIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Override
    @JsonProperty
    public String getAltText() {
        return this.altText;
    }

    @Override
    @JsonProperty
    public Optional<Text> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    public final Image withImageUrl(String imageUrl) {
        if (this.imageUrl.equals(imageUrl)) {
            return this;
        }
        String newValue = Objects.requireNonNull(imageUrl, "imageUrl");
        return new Image(newValue, this.altText, this.title, this.blockId);
    }

    public final Image withAltText(String altText) {
        if (this.altText.equals(altText)) {
            return this;
        }
        String newValue = Objects.requireNonNull(altText, "altText");
        return new Image(this.imageUrl, newValue, this.title, this.blockId);
    }

    public final Image withTitle(@Nullable Text value) {
        Text newValue = value;
        if (this.title == newValue) {
            return this;
        }
        return new Image(this.imageUrl, this.altText, newValue, this.blockId);
    }

    public final Image withTitle(Optional<Text> optional) {
        Text value = optional.orElse(null);
        if (this.title == value) {
            return this;
        }
        return new Image(this.imageUrl, this.altText, value, this.blockId);
    }

    public final Image withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return new Image(this.imageUrl, this.altText, this.title, newValue);
    }

    public final Image withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return new Image(this.imageUrl, this.altText, this.title, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Image && this.equalTo((Image)another);
    }

    private boolean equalTo(Image another) {
        return this.type.equals(another.type) && this.imageUrl.equals(another.imageUrl) && this.altText.equals(another.altText) && Objects.equals(this.title, another.title) && Objects.equals(this.blockId, another.blockId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.imageUrl.hashCode();
        h = h * 17 + this.altText.hashCode();
        h = h * 17 + Objects.hashCode(this.title);
        h = h * 17 + Objects.hashCode(this.blockId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Image{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("imageUrl=").append(this.imageUrl);
        builder.append(", ");
        builder.append("altText=").append(this.altText);
        if (this.title != null) {
            builder.append(", ");
            builder.append("title=").append(this.title);
        }
        if (this.blockId != null) {
            builder.append(", ");
            builder.append("blockId=").append(this.blockId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static Image fromJson(Json json) {
        Builder builder = Image.builder();
        if (json.imageUrl != null) {
            builder.setImageUrl(json.imageUrl);
        }
        if (json.altText != null) {
            builder.setAltText(json.altText);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        return builder.build();
    }

    public static Image of(String imageUrl, String altText) {
        return new Image(imageUrl, altText);
    }

    public static Image copyOf(ImageIF instance) {
        if (instance instanceof Image) {
            return (Image)instance;
        }
        return Image.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IMAGE_URL = 1L;
        private static final long INIT_BIT_ALT_TEXT = 2L;
        private long initBits = 3L;
        @Nullable
        private String imageUrl;
        @Nullable
        private String altText;
        @Nullable
        private Text title;
        @Nullable
        private String blockId;

        private Builder() {
        }

        public final Builder from(ImageIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<String> blockIdOptional;
            Block instance;
            if (object instanceof ImageIF) {
                instance = (ImageIF)object;
                this.setAltText(instance.getAltText());
                Optional<Text> titleOptional = instance.getTitle();
                if (titleOptional.isPresent()) {
                    this.setTitle(titleOptional);
                }
                this.setImageUrl(instance.getImageUrl());
            }
            if (object instanceof Block && (blockIdOptional = (instance = (Block)object).getBlockId()).isPresent()) {
                this.setBlockId(blockIdOptional);
            }
        }

        public final Builder setImageUrl(String imageUrl) {
            this.imageUrl = Objects.requireNonNull(imageUrl, "imageUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setAltText(String altText) {
            this.altText = Objects.requireNonNull(altText, "altText");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setTitle(@Nullable Text title) {
            this.title = title;
            return this;
        }

        public final Builder setTitle(Optional<Text> title) {
            this.title = title.orElse(null);
            return this;
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public Image build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new Image(this.imageUrl, this.altText, this.title, this.blockId);
        }

        private boolean imageUrlIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean altTextIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.imageUrlIsSet()) {
                attributes.add("imageUrl");
            }
            if (!this.altTextIsSet()) {
                attributes.add("altText");
            }
            return "Cannot build Image, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ImageIF {
        @Nullable
        String imageUrl;
        @Nullable
        String altText;
        Optional<Text> title = Optional.empty();
        Optional<String> blockId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        @JsonProperty
        public void setAltText(String altText) {
            this.altText = altText;
        }

        @JsonProperty
        public void setTitle(Optional<Text> title) {
            this.title = title;
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getImageUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAltText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }
    }
}

