/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.ActionsIF;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.elements.BlockElement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class Actions
implements ActionsIF {
    private final String type;
    private final List<BlockElement> elements;
    @Nullable
    private final String blockId;

    private Actions(Iterable<? extends BlockElement> elements) {
        this.elements = Actions.createUnmodifiableList(false, Actions.createSafeList(elements, true, false));
        this.blockId = null;
        this.type = Objects.requireNonNull(ActionsIF.super.getType(), "type");
    }

    private Actions(List<BlockElement> elements, @Nullable String blockId) {
        this.elements = elements;
        this.blockId = blockId;
        this.type = Objects.requireNonNull(ActionsIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public List<BlockElement> getElements() {
        return this.elements;
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    public final Actions withElements(BlockElement ... elements) {
        List<BlockElement> newValue = Actions.createUnmodifiableList(false, Actions.createSafeList(Arrays.asList(elements), true, false));
        return new Actions(newValue, this.blockId);
    }

    public final Actions withElements(Iterable<? extends BlockElement> elements) {
        if (this.elements == elements) {
            return this;
        }
        List<BlockElement> newValue = Actions.createUnmodifiableList(false, Actions.createSafeList(elements, true, false));
        return new Actions(newValue, this.blockId);
    }

    public final Actions withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return new Actions(this.elements, newValue);
    }

    public final Actions withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return new Actions(this.elements, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Actions && this.equalTo((Actions)another);
    }

    private boolean equalTo(Actions another) {
        return this.type.equals(another.type) && this.elements.equals(another.elements) && Objects.equals(this.blockId, another.blockId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.elements.hashCode();
        h = h * 17 + Objects.hashCode(this.blockId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Actions{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("elements=").append(this.elements);
        if (this.blockId != null) {
            builder.append(", ");
            builder.append("blockId=").append(this.blockId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static Actions fromJson(Json json) {
        Builder builder = Actions.builder();
        if (json.elements != null) {
            builder.addAllElements(json.elements);
        }
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        return builder.build();
    }

    public static Actions of(List<BlockElement> elements) {
        return Actions.of(elements);
    }

    public static Actions of(Iterable<? extends BlockElement> elements) {
        return new Actions(elements);
    }

    public static Actions copyOf(ActionsIF instance) {
        if (instance instanceof Actions) {
            return (Actions)instance;
        }
        return Actions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private List<BlockElement> elements = new ArrayList<BlockElement>();
        @Nullable
        private String blockId;

        private Builder() {
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ActionsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Block instance;
            Optional<String> blockIdOptional;
            if (object instanceof Block && (blockIdOptional = (instance = (Block)object).getBlockId()).isPresent()) {
                this.setBlockId(blockIdOptional);
            }
            if (object instanceof ActionsIF) {
                instance = (ActionsIF)object;
                this.addAllElements(instance.getElements());
            }
        }

        public final Builder addElements(BlockElement element) {
            this.elements.add(Objects.requireNonNull(element, "elements element"));
            return this;
        }

        public final Builder addElements(BlockElement ... elements) {
            for (BlockElement element : elements) {
                this.elements.add(Objects.requireNonNull(element, "elements element"));
            }
            return this;
        }

        public final Builder setElements(Iterable<? extends BlockElement> elements) {
            this.elements.clear();
            return this.addAllElements(elements);
        }

        public final Builder addAllElements(Iterable<? extends BlockElement> elements) {
            for (BlockElement blockElement : elements) {
                this.elements.add(Objects.requireNonNull(blockElement, "elements element"));
            }
            return this;
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public Actions build() throws InvalidImmutableStateException {
            return new Actions(Actions.createUnmodifiableList(true, this.elements), this.blockId);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ActionsIF {
        List<BlockElement> elements = Collections.emptyList();
        Optional<String> blockId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setElements(List<BlockElement> elements) {
            this.elements = elements;
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<BlockElement> getElements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }
    }
}

