/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.auth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.auth.BotCredentialsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class BotCredentials
implements BotCredentialsIF {
    private final String botUserId;
    private final String botAccessToken;

    private BotCredentials(String botUserId, String botAccessToken) {
        this.botUserId = botUserId;
        this.botAccessToken = botAccessToken;
    }

    @Override
    @JsonProperty
    public String getBotUserId() {
        return this.botUserId;
    }

    @Override
    @JsonProperty
    public String getBotAccessToken() {
        return this.botAccessToken;
    }

    public final BotCredentials withBotUserId(String botUserId) {
        if (this.botUserId.equals(botUserId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(botUserId, "botUserId");
        return new BotCredentials(newValue, this.botAccessToken);
    }

    public final BotCredentials withBotAccessToken(String botAccessToken) {
        if (this.botAccessToken.equals(botAccessToken)) {
            return this;
        }
        String newValue = Objects.requireNonNull(botAccessToken, "botAccessToken");
        return new BotCredentials(this.botUserId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BotCredentials && this.equalTo((BotCredentials)another);
    }

    private boolean equalTo(BotCredentials another) {
        return this.botUserId.equals(another.botUserId) && this.botAccessToken.equals(another.botAccessToken);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.botUserId.hashCode();
        h = h * 17 + this.botAccessToken.hashCode();
        return h;
    }

    public String toString() {
        return "BotCredentials{botUserId=" + this.botUserId + ", botAccessToken=" + this.botAccessToken + "}";
    }

    @Deprecated
    @JsonCreator
    static BotCredentials fromJson(Json json) {
        Builder builder = BotCredentials.builder();
        if (json.botUserId != null) {
            builder.setBotUserId(json.botUserId);
        }
        if (json.botAccessToken != null) {
            builder.setBotAccessToken(json.botAccessToken);
        }
        return builder.build();
    }

    public static BotCredentials copyOf(BotCredentialsIF instance) {
        if (instance instanceof BotCredentials) {
            return (BotCredentials)instance;
        }
        return BotCredentials.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BOT_USER_ID = 1L;
        private static final long INIT_BIT_BOT_ACCESS_TOKEN = 2L;
        private long initBits = 3L;
        @Nullable
        private String botUserId;
        @Nullable
        private String botAccessToken;

        private Builder() {
        }

        public final Builder from(BotCredentialsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setBotUserId(instance.getBotUserId());
            this.setBotAccessToken(instance.getBotAccessToken());
            return this;
        }

        public final Builder setBotUserId(String botUserId) {
            this.botUserId = Objects.requireNonNull(botUserId, "botUserId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setBotAccessToken(String botAccessToken) {
            this.botAccessToken = Objects.requireNonNull(botAccessToken, "botAccessToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public BotCredentials build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new BotCredentials(this.botUserId, this.botAccessToken);
        }

        private boolean botUserIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean botAccessTokenIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.botUserIdIsSet()) {
                attributes.add("botUserId");
            }
            if (!this.botAccessTokenIsSet()) {
                attributes.add("botAccessToken");
            }
            return "Cannot build BotCredentials, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements BotCredentialsIF {
        @Nullable
        String botUserId;
        @Nullable
        String botAccessToken;

        Json() {
        }

        @JsonProperty
        public void setBotUserId(String botUserId) {
            this.botUserId = botUserId;
        }

        @JsonProperty
        public void setBotAccessToken(String botAccessToken) {
            this.botAccessToken = botAccessToken;
        }

        @Override
        public String getBotUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBotAccessToken() {
            throw new UnsupportedOperationException();
        }
    }
}

