/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.LiteMessageIF;
import com.hubspot.slack.client.models.ReplySkeleton;
import com.hubspot.slack.client.models.files.SlackFile;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class LiteMessage
implements LiteMessageIF {
    private final String type;
    @Nullable
    private final String subtype;
    @Nullable
    private final String user;
    @Nullable
    private final String botId;
    @Nullable
    private final String username;
    private final String text;
    private final List<Attachment> attachments;
    private final List<SlackFile> files;
    private final String timestamp;
    @Nullable
    private final String threadTimestamp;
    @Nullable
    private final Integer replyCount;
    @Nullable
    private final List<String> replyUserIds;
    @Nullable
    private final Integer replyUsersCount;
    @Nullable
    private final String latestReplyTimestamp;
    private final List<ReplySkeleton> replies;

    private LiteMessage(Builder builder) {
        this.type = builder.type;
        this.subtype = builder.subtype;
        this.user = builder.user;
        this.botId = builder.botId;
        this.username = builder.username;
        this.text = builder.text;
        this.attachments = LiteMessage.createUnmodifiableList(true, builder.attachments);
        this.files = LiteMessage.createUnmodifiableList(true, builder.files);
        this.timestamp = builder.timestamp;
        this.threadTimestamp = builder.threadTimestamp;
        this.replyCount = builder.replyCount;
        this.replyUserIds = builder.replyUserIds;
        this.replyUsersCount = builder.replyUsersCount;
        this.latestReplyTimestamp = builder.latestReplyTimestamp;
        this.replies = builder.repliesIsSet() ? LiteMessage.createUnmodifiableList(true, builder.replies) : LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(LiteMessageIF.super.getReplies(), true, false));
    }

    private LiteMessage(String type, @Nullable String subtype, @Nullable String user, @Nullable String botId, @Nullable String username, String text, List<Attachment> attachments, List<SlackFile> files, String timestamp, @Nullable String threadTimestamp, @Nullable Integer replyCount, @Nullable List<String> replyUserIds, @Nullable Integer replyUsersCount, @Nullable String latestReplyTimestamp, List<ReplySkeleton> replies) {
        this.type = type;
        this.subtype = subtype;
        this.user = user;
        this.botId = botId;
        this.username = username;
        this.text = text;
        this.attachments = attachments;
        this.files = files;
        this.timestamp = timestamp;
        this.threadTimestamp = threadTimestamp;
        this.replyCount = replyCount;
        this.replyUserIds = replyUserIds;
        this.replyUsersCount = replyUsersCount;
        this.latestReplyTimestamp = latestReplyTimestamp;
        this.replies = replies;
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Optional<String> getSubtype() {
        return Optional.ofNullable(this.subtype);
    }

    @Override
    @JsonProperty
    public Optional<String> getUser() {
        return Optional.ofNullable(this.user);
    }

    @Override
    @JsonProperty
    public Optional<String> getBotId() {
        return Optional.ofNullable(this.botId);
    }

    @Override
    @JsonProperty
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Override
    @JsonProperty
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty
    public List<SlackFile> getFiles() {
        return this.files;
    }

    @Override
    @JsonProperty(value="ts")
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty(value="thread_ts")
    public Optional<String> getThreadTimestamp() {
        return Optional.ofNullable(this.threadTimestamp);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getReplyCount() {
        return Optional.ofNullable(this.replyCount);
    }

    @Override
    @JsonProperty(value="reply_users")
    public Optional<List<String>> getReplyUserIds() {
        return Optional.ofNullable(this.replyUserIds);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getReplyUsersCount() {
        return Optional.ofNullable(this.replyUsersCount);
    }

    @Override
    @JsonProperty(value="latest_reply")
    public Optional<String> getLatestReplyTimestamp() {
        return Optional.ofNullable(this.latestReplyTimestamp);
    }

    @Override
    @JsonProperty
    @Deprecated
    public List<ReplySkeleton> getReplies() {
        return this.replies;
    }

    public final LiteMessage withType(String type) {
        if (this.type.equals(type)) {
            return this;
        }
        String newValue = Objects.requireNonNull(type, "type");
        return new LiteMessage(newValue, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withSubtype(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.subtype, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, newValue, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withSubtype(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.subtype, value)) {
            return this;
        }
        return new LiteMessage(this.type, value, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withUser(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.user, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, newValue, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withUser(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.user, value)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, value, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withBotId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.botId, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, newValue, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withBotId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.botId, value)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, value, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withUsername(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.username, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, newValue, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withUsername(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, value, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withText(String text) {
        if (this.text.equals(text)) {
            return this;
        }
        String newValue = Objects.requireNonNull(text, "text");
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, newValue, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withAttachments(Attachment ... elements) {
        List<Attachment> newValue = LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(Arrays.asList(elements), true, false));
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, newValue, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(elements, true, false));
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, newValue, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withFiles(SlackFile ... elements) {
        List<SlackFile> newValue = LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(Arrays.asList(elements), true, false));
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, newValue, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withFiles(Iterable<? extends SlackFile> elements) {
        if (this.files == elements) {
            return this;
        }
        List<SlackFile> newValue = LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(elements, true, false));
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, newValue, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withTimestamp(String timestamp) {
        if (this.timestamp.equals(timestamp)) {
            return this;
        }
        String newValue = Objects.requireNonNull(timestamp, "timestamp");
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, newValue, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withThreadTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.threadTimestamp, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, newValue, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withThreadTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.threadTimestamp, value)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, value, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withReplyCount(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.replyCount, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, newValue, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withReplyCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.replyCount, value)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, value, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withReplyUserIds(@Nullable List<String> value) {
        List<String> newValue = value;
        if (this.replyUserIds == newValue) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, newValue, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withReplyUserIds(Optional<List<String>> optional) {
        List value = optional.orElse(null);
        if (this.replyUserIds == value) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, value, this.replyUsersCount, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withReplyUsersCount(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.replyUsersCount, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, newValue, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withReplyUsersCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.replyUsersCount, value)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, value, this.latestReplyTimestamp, this.replies);
    }

    public final LiteMessage withLatestReplyTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.latestReplyTimestamp, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, newValue, this.replies);
    }

    public final LiteMessage withLatestReplyTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.latestReplyTimestamp, value)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, value, this.replies);
    }

    @Deprecated
    public final LiteMessage withReplies(ReplySkeleton ... elements) {
        List<ReplySkeleton> newValue = LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(Arrays.asList(elements), true, false));
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, newValue);
    }

    @Deprecated
    public final LiteMessage withReplies(Iterable<? extends ReplySkeleton> elements) {
        if (this.replies == elements) {
            return this;
        }
        List<ReplySkeleton> newValue = LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(elements, true, false));
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof LiteMessage && this.equalTo((LiteMessage)another);
    }

    private boolean equalTo(LiteMessage another) {
        return this.type.equals(another.type) && Objects.equals(this.subtype, another.subtype) && Objects.equals(this.user, another.user) && Objects.equals(this.botId, another.botId) && Objects.equals(this.username, another.username) && this.text.equals(another.text) && this.attachments.equals(another.attachments) && this.files.equals(another.files) && this.timestamp.equals(another.timestamp) && Objects.equals(this.threadTimestamp, another.threadTimestamp) && Objects.equals(this.replyCount, another.replyCount) && Objects.equals(this.replyUserIds, another.replyUserIds) && Objects.equals(this.replyUsersCount, another.replyUsersCount) && Objects.equals(this.latestReplyTimestamp, another.latestReplyTimestamp) && this.replies.equals(another.replies);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + Objects.hashCode(this.subtype);
        h = h * 17 + Objects.hashCode(this.user);
        h = h * 17 + Objects.hashCode(this.botId);
        h = h * 17 + Objects.hashCode(this.username);
        h = h * 17 + this.text.hashCode();
        h = h * 17 + this.attachments.hashCode();
        h = h * 17 + this.files.hashCode();
        h = h * 17 + this.timestamp.hashCode();
        h = h * 17 + Objects.hashCode(this.threadTimestamp);
        h = h * 17 + Objects.hashCode(this.replyCount);
        h = h * 17 + Objects.hashCode(this.replyUserIds);
        h = h * 17 + Objects.hashCode(this.replyUsersCount);
        h = h * 17 + Objects.hashCode(this.latestReplyTimestamp);
        h = h * 17 + this.replies.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LiteMessage{");
        builder.append("type=").append(this.type);
        if (this.subtype != null) {
            builder.append(", ");
            builder.append("subtype=").append(this.subtype);
        }
        if (this.user != null) {
            builder.append(", ");
            builder.append("user=").append(this.user);
        }
        if (this.botId != null) {
            builder.append(", ");
            builder.append("botId=").append(this.botId);
        }
        if (this.username != null) {
            builder.append(", ");
            builder.append("username=").append(this.username);
        }
        builder.append(", ");
        builder.append("text=").append(this.text);
        builder.append(", ");
        builder.append("attachments=").append(this.attachments);
        builder.append(", ");
        builder.append("files=").append(this.files);
        builder.append(", ");
        builder.append("timestamp=").append(this.timestamp);
        if (this.threadTimestamp != null) {
            builder.append(", ");
            builder.append("threadTimestamp=").append(this.threadTimestamp);
        }
        if (this.replyCount != null) {
            builder.append(", ");
            builder.append("replyCount=").append(this.replyCount);
        }
        if (this.replyUserIds != null) {
            builder.append(", ");
            builder.append("replyUserIds=").append(this.replyUserIds);
        }
        if (this.replyUsersCount != null) {
            builder.append(", ");
            builder.append("replyUsersCount=").append(this.replyUsersCount);
        }
        if (this.latestReplyTimestamp != null) {
            builder.append(", ");
            builder.append("latestReplyTimestamp=").append(this.latestReplyTimestamp);
        }
        builder.append(", ");
        builder.append("replies=").append(this.replies);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static LiteMessage fromJson(Json json) {
        Builder builder = LiteMessage.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.subtype != null) {
            builder.setSubtype(json.subtype);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.botId != null) {
            builder.setBotId(json.botId);
        }
        if (json.username != null) {
            builder.setUsername(json.username);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.files != null) {
            builder.addAllFiles(json.files);
        }
        if (json.timestamp != null) {
            builder.setTimestamp(json.timestamp);
        }
        if (json.threadTimestamp != null) {
            builder.setThreadTimestamp(json.threadTimestamp);
        }
        if (json.replyCount != null) {
            builder.setReplyCount(json.replyCount);
        }
        if (json.replyUserIds != null) {
            builder.setReplyUserIds(json.replyUserIds);
        }
        if (json.replyUsersCount != null) {
            builder.setReplyUsersCount(json.replyUsersCount);
        }
        if (json.latestReplyTimestamp != null) {
            builder.setLatestReplyTimestamp(json.latestReplyTimestamp);
        }
        if (json.repliesIsSet) {
            builder.setReplies(json.replies);
        }
        return builder.build();
    }

    public static LiteMessage copyOf(LiteMessageIF instance) {
        if (instance instanceof LiteMessage) {
            return (LiteMessage)instance;
        }
        return LiteMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private static final long INIT_BIT_TIMESTAMP = 4L;
        private static final long OPT_BIT_REPLIES = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private String type;
        @Nullable
        private String subtype;
        @Nullable
        private String user;
        @Nullable
        private String botId;
        @Nullable
        private String username;
        @Nullable
        private String text;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        private List<SlackFile> files = new ArrayList<SlackFile>();
        @Nullable
        private String timestamp;
        @Nullable
        private String threadTimestamp;
        @Nullable
        private Integer replyCount;
        @Nullable
        private List<String> replyUserIds;
        @Nullable
        private Integer replyUsersCount;
        @Nullable
        private String latestReplyTimestamp;
        private List<ReplySkeleton> replies = new ArrayList<ReplySkeleton>();

        private Builder() {
        }

        public final Builder from(LiteMessageIF instance) {
            Optional<String> latestReplyTimestampOptional;
            Optional<Integer> replyUsersCountOptional;
            Optional<List<String>> replyUserIdsOptional;
            Optional<Integer> replyCountOptional;
            Optional<String> usernameOptional;
            Optional<String> botIdOptional;
            Optional<String> userOptional;
            Objects.requireNonNull(instance, "instance");
            this.setType(instance.getType());
            Optional<String> subtypeOptional = instance.getSubtype();
            if (subtypeOptional.isPresent()) {
                this.setSubtype(subtypeOptional);
            }
            if ((userOptional = instance.getUser()).isPresent()) {
                this.setUser(userOptional);
            }
            if ((botIdOptional = instance.getBotId()).isPresent()) {
                this.setBotId(botIdOptional);
            }
            if ((usernameOptional = instance.getUsername()).isPresent()) {
                this.setUsername(usernameOptional);
            }
            this.setText(instance.getText());
            this.addAllAttachments(instance.getAttachments());
            this.addAllFiles(instance.getFiles());
            this.setTimestamp(instance.getTimestamp());
            Optional<String> threadTimestampOptional = instance.getThreadTimestamp();
            if (threadTimestampOptional.isPresent()) {
                this.setThreadTimestamp(threadTimestampOptional);
            }
            if ((replyCountOptional = instance.getReplyCount()).isPresent()) {
                this.setReplyCount(replyCountOptional);
            }
            if ((replyUserIdsOptional = instance.getReplyUserIds()).isPresent()) {
                this.setReplyUserIds(replyUserIdsOptional);
            }
            if ((replyUsersCountOptional = instance.getReplyUsersCount()).isPresent()) {
                this.setReplyUsersCount(replyUsersCountOptional);
            }
            if ((latestReplyTimestampOptional = instance.getLatestReplyTimestamp()).isPresent()) {
                this.setLatestReplyTimestamp(latestReplyTimestampOptional);
            }
            this.addAllReplies(instance.getReplies());
            return this;
        }

        public final Builder setType(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setSubtype(@Nullable String subtype) {
            this.subtype = subtype;
            return this;
        }

        public final Builder setSubtype(Optional<String> subtype) {
            this.subtype = subtype.orElse(null);
            return this;
        }

        public final Builder setUser(@Nullable String user) {
            this.user = user;
            return this;
        }

        public final Builder setUser(Optional<String> user) {
            this.user = user.orElse(null);
            return this;
        }

        public final Builder setBotId(@Nullable String botId) {
            this.botId = botId;
            return this;
        }

        public final Builder setBotId(Optional<String> botId) {
            this.botId = botId.orElse(null);
            return this;
        }

        public final Builder setUsername(@Nullable String username) {
            this.username = username;
            return this;
        }

        public final Builder setUsername(Optional<String> username) {
            this.username = username.orElse(null);
            return this;
        }

        public final Builder setText(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        public final Builder addFiles(SlackFile element) {
            this.files.add(Objects.requireNonNull(element, "files element"));
            return this;
        }

        public final Builder addFiles(SlackFile ... elements) {
            for (SlackFile element : elements) {
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            return this;
        }

        public final Builder setFiles(Iterable<? extends SlackFile> elements) {
            this.files.clear();
            return this.addAllFiles(elements);
        }

        public final Builder addAllFiles(Iterable<? extends SlackFile> elements) {
            for (SlackFile slackFile : elements) {
                this.files.add(Objects.requireNonNull(slackFile, "files element"));
            }
            return this;
        }

        public final Builder setTimestamp(String timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setThreadTimestamp(@Nullable String threadTimestamp) {
            this.threadTimestamp = threadTimestamp;
            return this;
        }

        public final Builder setThreadTimestamp(Optional<String> threadTimestamp) {
            this.threadTimestamp = threadTimestamp.orElse(null);
            return this;
        }

        public final Builder setReplyCount(@Nullable Integer replyCount) {
            this.replyCount = replyCount;
            return this;
        }

        public final Builder setReplyCount(Optional<Integer> replyCount) {
            this.replyCount = replyCount.orElse(null);
            return this;
        }

        public final Builder setReplyUserIds(@Nullable List<String> replyUserIds) {
            this.replyUserIds = replyUserIds;
            return this;
        }

        public final Builder setReplyUserIds(Optional<List<String>> replyUserIds) {
            this.replyUserIds = replyUserIds.orElse(null);
            return this;
        }

        public final Builder setReplyUsersCount(@Nullable Integer replyUsersCount) {
            this.replyUsersCount = replyUsersCount;
            return this;
        }

        public final Builder setReplyUsersCount(Optional<Integer> replyUsersCount) {
            this.replyUsersCount = replyUsersCount.orElse(null);
            return this;
        }

        public final Builder setLatestReplyTimestamp(@Nullable String latestReplyTimestamp) {
            this.latestReplyTimestamp = latestReplyTimestamp;
            return this;
        }

        public final Builder setLatestReplyTimestamp(Optional<String> latestReplyTimestamp) {
            this.latestReplyTimestamp = latestReplyTimestamp.orElse(null);
            return this;
        }

        @Deprecated
        public final Builder addReplies(ReplySkeleton element) {
            this.replies.add(Objects.requireNonNull(element, "replies element"));
            this.optBits |= 1L;
            return this;
        }

        @Deprecated
        public final Builder addReplies(ReplySkeleton ... elements) {
            for (ReplySkeleton element : elements) {
                this.replies.add(Objects.requireNonNull(element, "replies element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @Deprecated
        public final Builder setReplies(Iterable<? extends ReplySkeleton> elements) {
            this.replies.clear();
            return this.addAllReplies(elements);
        }

        @Deprecated
        public final Builder addAllReplies(Iterable<? extends ReplySkeleton> elements) {
            for (ReplySkeleton replySkeleton : elements) {
                this.replies.add(Objects.requireNonNull(replySkeleton, "replies element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public LiteMessage build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new LiteMessage(this);
        }

        private boolean repliesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean textIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean timestampIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            if (!this.timestampIsSet()) {
                attributes.add("timestamp");
            }
            return "Cannot build LiteMessage, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements LiteMessageIF {
        @Nullable
        String type;
        Optional<String> subtype = Optional.empty();
        Optional<String> user = Optional.empty();
        Optional<String> botId = Optional.empty();
        Optional<String> username = Optional.empty();
        @Nullable
        String text;
        List<Attachment> attachments = Collections.emptyList();
        List<SlackFile> files = Collections.emptyList();
        @Nullable
        String timestamp;
        Optional<String> threadTimestamp = Optional.empty();
        Optional<Integer> replyCount = Optional.empty();
        Optional<List<String>> replyUserIds = Optional.empty();
        Optional<Integer> replyUsersCount = Optional.empty();
        Optional<String> latestReplyTimestamp = Optional.empty();
        List<ReplySkeleton> replies = Collections.emptyList();
        boolean repliesIsSet;

        Json() {
        }

        @JsonProperty
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty
        public void setSubtype(Optional<String> subtype) {
            this.subtype = subtype;
        }

        @JsonProperty
        public void setUser(Optional<String> user) {
            this.user = user;
        }

        @JsonProperty
        public void setBotId(Optional<String> botId) {
            this.botId = botId;
        }

        @JsonProperty
        public void setUsername(Optional<String> username) {
            this.username = username;
        }

        @JsonProperty
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty
        public void setFiles(List<SlackFile> files) {
            this.files = files;
        }

        @JsonProperty(value="ts")
        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @JsonProperty(value="thread_ts")
        public void setThreadTimestamp(Optional<String> threadTimestamp) {
            this.threadTimestamp = threadTimestamp;
        }

        @JsonProperty
        public void setReplyCount(Optional<Integer> replyCount) {
            this.replyCount = replyCount;
        }

        @JsonProperty(value="reply_users")
        public void setReplyUserIds(Optional<List<String>> replyUserIds) {
            this.replyUserIds = replyUserIds;
        }

        @JsonProperty
        public void setReplyUsersCount(Optional<Integer> replyUsersCount) {
            this.replyUsersCount = replyUsersCount;
        }

        @JsonProperty(value="latest_reply")
        public void setLatestReplyTimestamp(Optional<String> latestReplyTimestamp) {
            this.latestReplyTimestamp = latestReplyTimestamp;
        }

        @JsonProperty
        public void setReplies(List<ReplySkeleton> replies) {
            this.replies = replies;
            this.repliesIsSet = true;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSubtype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getBotId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackFile> getFiles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThreadTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getReplyCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> getReplyUserIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getReplyUsersCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLatestReplyTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ReplySkeleton> getReplies() {
            throw new UnsupportedOperationException();
        }
    }
}

