/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.usergroups.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasCommaSeperatedUserIds;
import com.hubspot.slack.client.methods.interceptor.HasUsergroup;
import com.hubspot.slack.client.methods.params.usergroups.users.AbstractUsergroupUsersUpdateParams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class UsergroupUsersUpdateParams
extends AbstractUsergroupUsersUpdateParams {
    private final String usergroupId;
    @Nullable
    private final Boolean includeCount;
    private final List<String> rawUserIds;
    private final Optional<String> encodedUsers;

    private UsergroupUsersUpdateParams(String usergroupId, @Nullable Boolean includeCount, List<String> rawUserIds) {
        this.usergroupId = usergroupId;
        this.includeCount = includeCount;
        this.rawUserIds = rawUserIds;
        this.encodedUsers = Objects.requireNonNull(super.getEncodedUsers(), "encodedUsers");
    }

    @Override
    @JsonProperty(value="usergroup")
    public String getUsergroupId() {
        return this.usergroupId;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIncludeCount() {
        return Optional.ofNullable(this.includeCount);
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public List<String> getRawUserIds() {
        return this.rawUserIds;
    }

    @Override
    @JsonProperty(value="users")
    public Optional<String> getEncodedUsers() {
        return this.encodedUsers;
    }

    public final UsergroupUsersUpdateParams withUsergroupId(String usergroupId) {
        if (this.usergroupId.equals(usergroupId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(usergroupId, "usergroupId");
        return new UsergroupUsersUpdateParams(newValue, this.includeCount, this.rawUserIds);
    }

    public final UsergroupUsersUpdateParams withIncludeCount(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.includeCount, newValue)) {
            return this;
        }
        return new UsergroupUsersUpdateParams(this.usergroupId, newValue, this.rawUserIds);
    }

    public final UsergroupUsersUpdateParams withIncludeCount(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.includeCount, value)) {
            return this;
        }
        return new UsergroupUsersUpdateParams(this.usergroupId, value, this.rawUserIds);
    }

    public final UsergroupUsersUpdateParams withRawUserIds(String ... elements) {
        List<String> newValue = UsergroupUsersUpdateParams.createUnmodifiableList(false, UsergroupUsersUpdateParams.createSafeList(Arrays.asList(elements), true, false));
        return new UsergroupUsersUpdateParams(this.usergroupId, this.includeCount, newValue);
    }

    public final UsergroupUsersUpdateParams withRawUserIds(Iterable<String> elements) {
        if (this.rawUserIds == elements) {
            return this;
        }
        List<String> newValue = UsergroupUsersUpdateParams.createUnmodifiableList(false, UsergroupUsersUpdateParams.createSafeList(elements, true, false));
        return new UsergroupUsersUpdateParams(this.usergroupId, this.includeCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsergroupUsersUpdateParams && this.equalTo((UsergroupUsersUpdateParams)another);
    }

    private boolean equalTo(UsergroupUsersUpdateParams another) {
        return this.usergroupId.equals(another.usergroupId) && Objects.equals(this.includeCount, another.includeCount) && this.rawUserIds.equals(another.rawUserIds) && this.encodedUsers.equals(another.encodedUsers);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.usergroupId.hashCode();
        h = h * 17 + Objects.hashCode(this.includeCount);
        h = h * 17 + this.rawUserIds.hashCode();
        h = h * 17 + this.encodedUsers.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsergroupUsersUpdateParams{");
        builder.append("usergroupId=").append(this.usergroupId);
        if (this.includeCount != null) {
            builder.append(", ");
            builder.append("includeCount=").append(this.includeCount);
        }
        builder.append(", ");
        builder.append("rawUserIds=").append(this.rawUserIds);
        builder.append(", ");
        builder.append("encodedUsers=").append(this.encodedUsers);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static UsergroupUsersUpdateParams fromJson(Json json) {
        Builder builder = UsergroupUsersUpdateParams.builder();
        if (json.usergroupId != null) {
            builder.setUsergroupId(json.usergroupId);
        }
        if (json.includeCount != null) {
            builder.setIncludeCount(json.includeCount);
        }
        if (json.rawUserIds != null) {
            builder.addAllRawUserIds(json.rawUserIds);
        }
        return builder.build();
    }

    public static UsergroupUsersUpdateParams copyOf(AbstractUsergroupUsersUpdateParams instance) {
        if (instance instanceof UsergroupUsersUpdateParams) {
            return (UsergroupUsersUpdateParams)instance;
        }
        return UsergroupUsersUpdateParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USERGROUP_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String usergroupId;
        @Nullable
        private Boolean includeCount;
        private List<String> rawUserIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(HasUsergroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractUsergroupUsersUpdateParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HasCommaSeperatedUserIds instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof HasUsergroup) {
                instance = (HasUsergroup)object;
                if ((bits & 1L) == 0L) {
                    this.setUsergroupId(instance.getUsergroupId());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractUsergroupUsersUpdateParams) {
                Optional<Boolean> includeCountOptional;
                instance = (AbstractUsergroupUsersUpdateParams)object;
                if ((bits & 1L) == 0L) {
                    this.setUsergroupId(((AbstractUsergroupUsersUpdateParams)instance).getUsergroupId());
                    bits |= 1L;
                }
                if ((includeCountOptional = ((AbstractUsergroupUsersUpdateParams)instance).getIncludeCount()).isPresent()) {
                    this.setIncludeCount(includeCountOptional);
                }
            }
            if (object instanceof HasCommaSeperatedUserIds) {
                instance = (HasCommaSeperatedUserIds)object;
                this.addAllRawUserIds(instance.getRawUserIds());
            }
        }

        public final Builder setUsergroupId(String usergroupId) {
            this.usergroupId = Objects.requireNonNull(usergroupId, "usergroupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setIncludeCount(@Nullable Boolean includeCount) {
            this.includeCount = includeCount;
            return this;
        }

        public final Builder setIncludeCount(Optional<Boolean> includeCount) {
            this.includeCount = includeCount.orElse(null);
            return this;
        }

        public final Builder addRawUserIds(String element) {
            this.rawUserIds.add(Objects.requireNonNull(element, "rawUserIds element"));
            return this;
        }

        public final Builder addRawUserIds(String ... elements) {
            for (String element : elements) {
                this.rawUserIds.add(Objects.requireNonNull(element, "rawUserIds element"));
            }
            return this;
        }

        public final Builder setRawUserIds(Iterable<String> elements) {
            this.rawUserIds.clear();
            return this.addAllRawUserIds(elements);
        }

        public final Builder addAllRawUserIds(Iterable<String> elements) {
            for (String element : elements) {
                this.rawUserIds.add(Objects.requireNonNull(element, "rawUserIds element"));
            }
            return this;
        }

        public UsergroupUsersUpdateParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new UsergroupUsersUpdateParams(this.usergroupId, this.includeCount, UsergroupUsersUpdateParams.createUnmodifiableList(true, this.rawUserIds));
        }

        private boolean usergroupIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.usergroupIdIsSet()) {
                attributes.add("usergroupId");
            }
            return "Cannot build UsergroupUsersUpdateParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AbstractUsergroupUsersUpdateParams {
        @Nullable
        String usergroupId;
        Optional<Boolean> includeCount = Optional.empty();
        List<String> rawUserIds = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="usergroup")
        public void setUsergroupId(String usergroupId) {
            this.usergroupId = usergroupId;
        }

        @JsonProperty
        public void setIncludeCount(Optional<Boolean> includeCount) {
            this.includeCount = includeCount;
        }

        @JsonProperty
        @JsonIgnore
        public void setRawUserIds(List<String> rawUserIds) {
            this.rawUserIds = rawUserIds;
        }

        @Override
        public String getUsergroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIncludeCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getRawUserIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEncodedUsers() {
            throw new UnsupportedOperationException();
        }
    }
}

