/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.usergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasCommaSeperatedChannelIds;
import com.hubspot.slack.client.methods.interceptor.HasUsergroup;
import com.hubspot.slack.client.methods.params.usergroups.AbstractUsergroupUpdateParams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class UsergroupUpdateParams
extends AbstractUsergroupUpdateParams {
    private final String usergroupId;
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String handle;
    @Nullable
    private final Boolean includeCount;
    private final List<String> rawChannelIds;
    private final Optional<String> encodedChannels;

    private UsergroupUpdateParams(String usergroupId, @Nullable String name, @Nullable String description, @Nullable String handle, @Nullable Boolean includeCount, List<String> rawChannelIds) {
        this.usergroupId = usergroupId;
        this.name = name;
        this.description = description;
        this.handle = handle;
        this.includeCount = includeCount;
        this.rawChannelIds = rawChannelIds;
        this.encodedChannels = Objects.requireNonNull(super.getEncodedChannels(), "encodedChannels");
    }

    @Override
    @JsonProperty(value="usergroup")
    public String getUsergroupId() {
        return this.usergroupId;
    }

    @Override
    @JsonProperty
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty
    public Optional<String> getHandle() {
        return Optional.ofNullable(this.handle);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIncludeCount() {
        return Optional.ofNullable(this.includeCount);
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public List<String> getRawChannelIds() {
        return this.rawChannelIds;
    }

    @Override
    @JsonProperty(value="channels")
    public Optional<String> getEncodedChannels() {
        return this.encodedChannels;
    }

    public final UsergroupUpdateParams withUsergroupId(String usergroupId) {
        if (this.usergroupId.equals(usergroupId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(usergroupId, "usergroupId");
        return new UsergroupUpdateParams(newValue, this.name, this.description, this.handle, this.includeCount, this.rawChannelIds);
    }

    public final UsergroupUpdateParams withName(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new UsergroupUpdateParams(this.usergroupId, newValue, this.description, this.handle, this.includeCount, this.rawChannelIds);
    }

    public final UsergroupUpdateParams withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new UsergroupUpdateParams(this.usergroupId, value, this.description, this.handle, this.includeCount, this.rawChannelIds);
    }

    public final UsergroupUpdateParams withDescription(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new UsergroupUpdateParams(this.usergroupId, this.name, newValue, this.handle, this.includeCount, this.rawChannelIds);
    }

    public final UsergroupUpdateParams withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new UsergroupUpdateParams(this.usergroupId, this.name, value, this.handle, this.includeCount, this.rawChannelIds);
    }

    public final UsergroupUpdateParams withHandle(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.handle, newValue)) {
            return this;
        }
        return new UsergroupUpdateParams(this.usergroupId, this.name, this.description, newValue, this.includeCount, this.rawChannelIds);
    }

    public final UsergroupUpdateParams withHandle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.handle, value)) {
            return this;
        }
        return new UsergroupUpdateParams(this.usergroupId, this.name, this.description, value, this.includeCount, this.rawChannelIds);
    }

    public final UsergroupUpdateParams withIncludeCount(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.includeCount, newValue)) {
            return this;
        }
        return new UsergroupUpdateParams(this.usergroupId, this.name, this.description, this.handle, newValue, this.rawChannelIds);
    }

    public final UsergroupUpdateParams withIncludeCount(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.includeCount, value)) {
            return this;
        }
        return new UsergroupUpdateParams(this.usergroupId, this.name, this.description, this.handle, value, this.rawChannelIds);
    }

    public final UsergroupUpdateParams withRawChannelIds(String ... elements) {
        List<String> newValue = UsergroupUpdateParams.createUnmodifiableList(false, UsergroupUpdateParams.createSafeList(Arrays.asList(elements), true, false));
        return new UsergroupUpdateParams(this.usergroupId, this.name, this.description, this.handle, this.includeCount, newValue);
    }

    public final UsergroupUpdateParams withRawChannelIds(Iterable<String> elements) {
        if (this.rawChannelIds == elements) {
            return this;
        }
        List<String> newValue = UsergroupUpdateParams.createUnmodifiableList(false, UsergroupUpdateParams.createSafeList(elements, true, false));
        return new UsergroupUpdateParams(this.usergroupId, this.name, this.description, this.handle, this.includeCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsergroupUpdateParams && this.equalTo((UsergroupUpdateParams)another);
    }

    private boolean equalTo(UsergroupUpdateParams another) {
        return this.usergroupId.equals(another.usergroupId) && Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && Objects.equals(this.handle, another.handle) && Objects.equals(this.includeCount, another.includeCount) && this.rawChannelIds.equals(another.rawChannelIds) && this.encodedChannels.equals(another.encodedChannels);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.usergroupId.hashCode();
        h = h * 17 + Objects.hashCode(this.name);
        h = h * 17 + Objects.hashCode(this.description);
        h = h * 17 + Objects.hashCode(this.handle);
        h = h * 17 + Objects.hashCode(this.includeCount);
        h = h * 17 + this.rawChannelIds.hashCode();
        h = h * 17 + this.encodedChannels.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsergroupUpdateParams{");
        builder.append("usergroupId=").append(this.usergroupId);
        if (this.name != null) {
            builder.append(", ");
            builder.append("name=").append(this.name);
        }
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        if (this.handle != null) {
            builder.append(", ");
            builder.append("handle=").append(this.handle);
        }
        if (this.includeCount != null) {
            builder.append(", ");
            builder.append("includeCount=").append(this.includeCount);
        }
        builder.append(", ");
        builder.append("rawChannelIds=").append(this.rawChannelIds);
        builder.append(", ");
        builder.append("encodedChannels=").append(this.encodedChannels);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static UsergroupUpdateParams fromJson(Json json) {
        Builder builder = UsergroupUpdateParams.builder();
        if (json.usergroupId != null) {
            builder.setUsergroupId(json.usergroupId);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.description != null) {
            builder.setDescription(json.description);
        }
        if (json.handle != null) {
            builder.setHandle(json.handle);
        }
        if (json.includeCount != null) {
            builder.setIncludeCount(json.includeCount);
        }
        if (json.rawChannelIds != null) {
            builder.addAllRawChannelIds(json.rawChannelIds);
        }
        return builder.build();
    }

    public static UsergroupUpdateParams copyOf(AbstractUsergroupUpdateParams instance) {
        if (instance instanceof UsergroupUpdateParams) {
            return (UsergroupUpdateParams)instance;
        }
        return UsergroupUpdateParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USERGROUP_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String usergroupId;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String handle;
        @Nullable
        private Boolean includeCount;
        private List<String> rawChannelIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(HasCommaSeperatedChannelIds instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HasUsergroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractUsergroupUpdateParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof HasCommaSeperatedChannelIds) {
                instance = (HasCommaSeperatedChannelIds)object;
                this.addAllRawChannelIds(instance.getRawChannelIds());
            }
            if (object instanceof HasUsergroup) {
                instance = (HasUsergroup)object;
                if ((bits & 1L) == 0L) {
                    this.setUsergroupId(instance.getUsergroupId());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractUsergroupUpdateParams) {
                Optional<Boolean> includeCountOptional;
                Optional<String> handleOptional;
                Optional<String> descriptionOptional;
                instance = (AbstractUsergroupUpdateParams)object;
                Optional<String> nameOptional = ((AbstractUsergroupUpdateParams)instance).getName();
                if (nameOptional.isPresent()) {
                    this.setName(nameOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setUsergroupId(((AbstractUsergroupUpdateParams)instance).getUsergroupId());
                    bits |= 1L;
                }
                if ((descriptionOptional = ((AbstractUsergroupUpdateParams)instance).getDescription()).isPresent()) {
                    this.setDescription(descriptionOptional);
                }
                if ((handleOptional = ((AbstractUsergroupUpdateParams)instance).getHandle()).isPresent()) {
                    this.setHandle(handleOptional);
                }
                if ((includeCountOptional = ((AbstractUsergroupUpdateParams)instance).getIncludeCount()).isPresent()) {
                    this.setIncludeCount(includeCountOptional);
                }
            }
        }

        public final Builder setUsergroupId(String usergroupId) {
            this.usergroupId = Objects.requireNonNull(usergroupId, "usergroupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder setName(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        public final Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder setDescription(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        public final Builder setHandle(@Nullable String handle) {
            this.handle = handle;
            return this;
        }

        public final Builder setHandle(Optional<String> handle) {
            this.handle = handle.orElse(null);
            return this;
        }

        public final Builder setIncludeCount(@Nullable Boolean includeCount) {
            this.includeCount = includeCount;
            return this;
        }

        public final Builder setIncludeCount(Optional<Boolean> includeCount) {
            this.includeCount = includeCount.orElse(null);
            return this;
        }

        public final Builder addRawChannelIds(String element) {
            this.rawChannelIds.add(Objects.requireNonNull(element, "rawChannelIds element"));
            return this;
        }

        public final Builder addRawChannelIds(String ... elements) {
            for (String element : elements) {
                this.rawChannelIds.add(Objects.requireNonNull(element, "rawChannelIds element"));
            }
            return this;
        }

        public final Builder setRawChannelIds(Iterable<String> elements) {
            this.rawChannelIds.clear();
            return this.addAllRawChannelIds(elements);
        }

        public final Builder addAllRawChannelIds(Iterable<String> elements) {
            for (String element : elements) {
                this.rawChannelIds.add(Objects.requireNonNull(element, "rawChannelIds element"));
            }
            return this;
        }

        public UsergroupUpdateParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new UsergroupUpdateParams(this.usergroupId, this.name, this.description, this.handle, this.includeCount, UsergroupUpdateParams.createUnmodifiableList(true, this.rawChannelIds));
        }

        private boolean usergroupIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.usergroupIdIsSet()) {
                attributes.add("usergroupId");
            }
            return "Cannot build UsergroupUpdateParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AbstractUsergroupUpdateParams {
        @Nullable
        String usergroupId;
        Optional<String> name = Optional.empty();
        Optional<String> description = Optional.empty();
        Optional<String> handle = Optional.empty();
        Optional<Boolean> includeCount = Optional.empty();
        List<String> rawChannelIds = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="usergroup")
        public void setUsergroupId(String usergroupId) {
            this.usergroupId = usergroupId;
        }

        @JsonProperty
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @JsonProperty
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty
        public void setHandle(Optional<String> handle) {
            this.handle = handle;
        }

        @JsonProperty
        public void setIncludeCount(Optional<Boolean> includeCount) {
            this.includeCount = includeCount;
        }

        @JsonProperty
        @JsonIgnore
        public void setRawChannelIds(List<String> rawChannelIds) {
            this.rawChannelIds = rawChannelIds;
        }

        @Override
        public String getUsergroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getHandle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIncludeCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getRawChannelIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEncodedChannels() {
            throw new UnsupportedOperationException();
        }
    }
}

