/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.usergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasUsergroup;
import com.hubspot.slack.client.methods.params.usergroups.AbstractUsergroupDisableParams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class UsergroupDisableParams
extends AbstractUsergroupDisableParams {
    private final String usergroupId;
    @Nullable
    private final Boolean includeCount;

    private UsergroupDisableParams(String usergroupId) {
        this.usergroupId = Objects.requireNonNull(usergroupId, "usergroupId");
        this.includeCount = null;
    }

    private UsergroupDisableParams(String usergroupId, @Nullable Boolean includeCount) {
        this.usergroupId = usergroupId;
        this.includeCount = includeCount;
    }

    @Override
    @JsonProperty(value="usergroup")
    public String getUsergroupId() {
        return this.usergroupId;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIncludeCount() {
        return Optional.ofNullable(this.includeCount);
    }

    public final UsergroupDisableParams withUsergroupId(String usergroupId) {
        if (this.usergroupId.equals(usergroupId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(usergroupId, "usergroupId");
        return new UsergroupDisableParams(newValue, this.includeCount);
    }

    public final UsergroupDisableParams withIncludeCount(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.includeCount, newValue)) {
            return this;
        }
        return new UsergroupDisableParams(this.usergroupId, newValue);
    }

    public final UsergroupDisableParams withIncludeCount(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.includeCount, value)) {
            return this;
        }
        return new UsergroupDisableParams(this.usergroupId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsergroupDisableParams && this.equalTo((UsergroupDisableParams)another);
    }

    private boolean equalTo(UsergroupDisableParams another) {
        return this.usergroupId.equals(another.usergroupId) && Objects.equals(this.includeCount, another.includeCount);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.usergroupId.hashCode();
        h = h * 17 + Objects.hashCode(this.includeCount);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsergroupDisableParams{");
        builder.append("usergroupId=").append(this.usergroupId);
        if (this.includeCount != null) {
            builder.append(", ");
            builder.append("includeCount=").append(this.includeCount);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static UsergroupDisableParams fromJson(Json json) {
        Builder builder = UsergroupDisableParams.builder();
        if (json.usergroupId != null) {
            builder.setUsergroupId(json.usergroupId);
        }
        if (json.includeCount != null) {
            builder.setIncludeCount(json.includeCount);
        }
        return builder.build();
    }

    public static UsergroupDisableParams of(String usergroupId) {
        return new UsergroupDisableParams(usergroupId);
    }

    public static UsergroupDisableParams copyOf(AbstractUsergroupDisableParams instance) {
        if (instance instanceof UsergroupDisableParams) {
            return (UsergroupDisableParams)instance;
        }
        return UsergroupDisableParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USERGROUP_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String usergroupId;
        @Nullable
        private Boolean includeCount;

        private Builder() {
        }

        public final Builder from(AbstractUsergroupDisableParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HasUsergroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            HasUsergroup instance;
            long bits = 0L;
            if (object instanceof AbstractUsergroupDisableParams) {
                Optional<Boolean> includeCountOptional;
                instance = (AbstractUsergroupDisableParams)object;
                if ((bits & 1L) == 0L) {
                    this.setUsergroupId(((AbstractUsergroupDisableParams)instance).getUsergroupId());
                    bits |= 1L;
                }
                if ((includeCountOptional = ((AbstractUsergroupDisableParams)instance).getIncludeCount()).isPresent()) {
                    this.setIncludeCount(includeCountOptional);
                }
            }
            if (object instanceof HasUsergroup) {
                instance = (HasUsergroup)object;
                if ((bits & 1L) == 0L) {
                    this.setUsergroupId(instance.getUsergroupId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setUsergroupId(String usergroupId) {
            this.usergroupId = Objects.requireNonNull(usergroupId, "usergroupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setIncludeCount(@Nullable Boolean includeCount) {
            this.includeCount = includeCount;
            return this;
        }

        public final Builder setIncludeCount(Optional<Boolean> includeCount) {
            this.includeCount = includeCount.orElse(null);
            return this;
        }

        public UsergroupDisableParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new UsergroupDisableParams(this.usergroupId, this.includeCount);
        }

        private boolean usergroupIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.usergroupIdIsSet()) {
                attributes.add("usergroupId");
            }
            return "Cannot build UsergroupDisableParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AbstractUsergroupDisableParams {
        @Nullable
        String usergroupId;
        Optional<Boolean> includeCount = Optional.empty();

        Json() {
        }

        @JsonProperty(value="usergroup")
        public void setUsergroupId(String usergroupId) {
            this.usergroupId = usergroupId;
        }

        @JsonProperty
        public void setIncludeCount(Optional<Boolean> includeCount) {
            this.includeCount = includeCount;
        }

        @Override
        public String getUsergroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIncludeCount() {
            throw new UnsupportedOperationException();
        }
    }
}

