/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.files.FilesSharedPublicUrlParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class FilesSharedPublicUrlParams
implements FilesSharedPublicUrlParamsIF {
    private final String fileId;

    private FilesSharedPublicUrlParams(String fileId) {
        this.fileId = Objects.requireNonNull(fileId, "fileId");
    }

    private FilesSharedPublicUrlParams(FilesSharedPublicUrlParams original, String fileId) {
        this.fileId = fileId;
    }

    @Override
    @JsonProperty(value="file")
    public String getFileId() {
        return this.fileId;
    }

    public final FilesSharedPublicUrlParams withFileId(String fileId) {
        if (this.fileId.equals(fileId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(fileId, "fileId");
        return new FilesSharedPublicUrlParams(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof FilesSharedPublicUrlParams && this.equalTo((FilesSharedPublicUrlParams)another);
    }

    private boolean equalTo(FilesSharedPublicUrlParams another) {
        return this.fileId.equals(another.fileId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.fileId.hashCode();
        return h;
    }

    public String toString() {
        return "FilesSharedPublicUrlParams{fileId=" + this.fileId + "}";
    }

    @Deprecated
    @JsonCreator
    static FilesSharedPublicUrlParams fromJson(Json json) {
        Builder builder = FilesSharedPublicUrlParams.builder();
        if (json.fileId != null) {
            builder.setFileId(json.fileId);
        }
        return builder.build();
    }

    public static FilesSharedPublicUrlParams of(String fileId) {
        return new FilesSharedPublicUrlParams(fileId);
    }

    public static FilesSharedPublicUrlParams copyOf(FilesSharedPublicUrlParamsIF instance) {
        if (instance instanceof FilesSharedPublicUrlParams) {
            return (FilesSharedPublicUrlParams)instance;
        }
        return FilesSharedPublicUrlParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FILE_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String fileId;

        private Builder() {
        }

        public final Builder from(FilesSharedPublicUrlParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setFileId(instance.getFileId());
            return this;
        }

        public final Builder setFileId(String fileId) {
            this.fileId = Objects.requireNonNull(fileId, "fileId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public FilesSharedPublicUrlParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new FilesSharedPublicUrlParams(null, this.fileId);
        }

        private boolean fileIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.fileIdIsSet()) {
                attributes.add("fileId");
            }
            return "Cannot build FilesSharedPublicUrlParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements FilesSharedPublicUrlParamsIF {
        @Nullable
        String fileId;

        Json() {
        }

        @JsonProperty(value="file")
        public void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public String getFileId() {
            throw new UnsupportedOperationException();
        }
    }
}

