/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.conversations.ConversationCreateParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ConversationCreateParams
implements ConversationCreateParamsIF {
    private final String name;
    private final boolean isPrivate;

    private ConversationCreateParams(String name, boolean isPrivate) {
        this.name = name;
        this.isPrivate = isPrivate;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public boolean isPrivate() {
        return this.isPrivate;
    }

    public final ConversationCreateParams withName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        String newValue = Objects.requireNonNull(name, "name");
        return new ConversationCreateParams(newValue, this.isPrivate);
    }

    public final ConversationCreateParams withIsPrivate(boolean isPrivate) {
        if (this.isPrivate == isPrivate) {
            return this;
        }
        return new ConversationCreateParams(this.name, isPrivate);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationCreateParams && this.equalTo((ConversationCreateParams)another);
    }

    private boolean equalTo(ConversationCreateParams another) {
        return this.name.equals(another.name) && this.isPrivate == another.isPrivate;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Boolean.hashCode(this.isPrivate);
        return h;
    }

    public String toString() {
        return "ConversationCreateParams{name=" + this.name + ", isPrivate=" + this.isPrivate + "}";
    }

    @Deprecated
    @JsonCreator
    static ConversationCreateParams fromJson(Json json) {
        Builder builder = ConversationCreateParams.builder();
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.isPrivateIsSet) {
            builder.setIsPrivate(json.isPrivate);
        }
        return builder.build();
    }

    public static ConversationCreateParams copyOf(ConversationCreateParamsIF instance) {
        if (instance instanceof ConversationCreateParams) {
            return (ConversationCreateParams)instance;
        }
        return ConversationCreateParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_IS_PRIVATE = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        private boolean isPrivate;

        private Builder() {
        }

        public final Builder from(ConversationCreateParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setName(instance.getName());
            this.setIsPrivate(instance.isPrivate());
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setIsPrivate(boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ConversationCreateParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ConversationCreateParams(this.name, this.isPrivate);
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean isPrivateIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.isPrivateIsSet()) {
                attributes.add("isPrivate");
            }
            return "Cannot build ConversationCreateParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ConversationCreateParamsIF {
        @Nullable
        String name;
        boolean isPrivate;
        boolean isPrivateIsSet;

        Json() {
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setIsPrivate(boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.isPrivateIsSet = true;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPrivate() {
            throw new UnsupportedOperationException();
        }
    }
}

