/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.channels;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.base.Preconditions;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.methods.TimeIntervalFilter;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import java.util.Optional;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@Value.Immutable
@HubSpotStyle
public abstract class AbstractChannelsHistoryParams
implements HasChannel,
TimeIntervalFilter {
    @Override
    @JsonProperty(value="channel")
    public abstract String getChannelId();

    public abstract Optional<Integer> getCount();

    @Override
    @JsonProperty(value="is_inclusive")
    public abstract Optional<Boolean> isInclusive();

    @JsonProperty(value="unreads")
    public abstract Optional<Boolean> shouldIncludeUnreads();

    @Value.Check
    public void validate() {
        Optional<Boolean> inclusive = this.isInclusive();
        Optional<Integer> count = this.getCount();
        boolean setToInclusive = inclusive.isPresent() && inclusive.get() != false;
        boolean countIs1 = count.isPresent() && count.get() == 1;
        Preconditions.checkState((!setToInclusive || setToInclusive && countIs1 ? 1 : 0) != 0, (Object)"Because slack uses doubles as type to page on, we can't guarantee a message will show up exactly once and that we'll present every message if you try to page inclusively over a set of messages. To get around this, ensure you're not setting inclusive, and that you fetch messages within the range you want by bumping the bounds (and filtering the messages you get back).");
    }
}

