/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.request.timeout;

import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.request.NettyRequestSender;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.request.timeout.TimeoutTimerTask;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.request.timeout.TimeoutsHolder;
import com.hubspot.horizon.shaded.com.ning.http.util.DateUtils;
import com.hubspot.horizon.shaded.org.jboss.netty.util.Timeout;

public class ReadTimeoutTimerTask
extends TimeoutTimerTask {
    private final long readTimeout;
    private final long requestTimeoutInstant;

    public ReadTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder, long requestTimeout, long readTimeout) {
        super(nettyResponseFuture, requestSender, timeoutsHolder);
        this.readTimeout = readTimeout;
        this.requestTimeoutInstant = requestTimeout >= 0L ? nettyResponseFuture.getStart() + requestTimeout : Long.MAX_VALUE;
    }

    @Override
    public void run(Timeout timeout) throws Exception {
        if (this.done.getAndSet(true) || this.requestSender.isClosed()) {
            return;
        }
        if (this.nettyResponseFuture.isDone()) {
            this.timeoutsHolder.cancel();
            return;
        }
        long now = DateUtils.millisTime();
        long currentReadTimeoutInstant = this.readTimeout + this.nettyResponseFuture.getLastTouch();
        long durationBeforeCurrentReadTimeout = currentReadTimeoutInstant - now;
        if (durationBeforeCurrentReadTimeout <= 0L) {
            String message = "Read timeout to " + this.remoteAddress + " of " + this.readTimeout + " ms";
            long durationSinceLastTouch = now - this.nettyResponseFuture.getLastTouch();
            this.expire(message, durationSinceLastTouch);
            this.timeoutsHolder.cancel();
        } else if (currentReadTimeoutInstant < this.requestTimeoutInstant) {
            this.done.set(false);
            this.timeoutsHolder.readTimeout = this.requestSender.newTimeout(this, durationBeforeCurrentReadTimeout);
        } else {
            this.timeoutsHolder.readTimeout = null;
        }
    }
}

