/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly;

import com.hubspot.horizon.shaded.com.ning.http.client.AsyncHandler;
import com.hubspot.horizon.shaded.com.ning.http.client.ProxyServer;
import com.hubspot.horizon.shaded.com.ning.http.client.Request;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.AhcHttpContext;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.GrizzlyResponseFuture;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.GrizzlyResponseStatus;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.PayloadGenerator;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.StatusHandler;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.events.GracefulCloseEvent;
import com.hubspot.horizon.shaded.com.ning.http.client.uri.Uri;
import com.hubspot.horizon.shaded.com.ning.http.client.ws.WebSocket;
import com.hubspot.horizon.shaded.com.ning.http.util.AsyncHttpProviderUtils;
import com.hubspot.horizon.shaded.com.ning.http.util.ProxyUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.ProtocolHandler;

public final class HttpTransactionContext {
    private static final Attribute<HttpTransactionContext> REQUEST_STATE_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(HttpTransactionContext.class.getName());
    int redirectCount;
    final int maxRedirectCount;
    final boolean redirectsAllowed;
    final GrizzlyAsyncHttpProvider provider;
    final ProxyServer proxyServer;
    private final Request ahcRequest;
    Uri requestUri;
    private final Connection connection;
    PayloadGenerator payloadGenerator;
    StatusHandler statusHandler;
    StatusHandler.InvocationStatus invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
    GrizzlyResponseFuture future;
    HttpResponsePacket responsePacket;
    GrizzlyResponseStatus responseStatus;
    Uri lastRedirectUri;
    long totalBodyWritten;
    AsyncHandler.STATE currentState;
    Uri wsRequestURI;
    boolean isWSRequest;
    HandShake handshake;
    ProtocolHandler protocolHandler;
    WebSocket webSocket;
    boolean establishingTunnel;
    boolean isReuseConnection;
    volatile boolean isRequestFullySent;
    Set<CompletionHandler<HttpTransactionContext>> reqFullySentHandlers;
    private final CloseListener listener = new CloseListener<Closeable, CloseType>(){

        public void onClosed(Closeable closeable, CloseType type) throws IOException {
            if (HttpTransactionContext.this.isGracefullyFinishResponseOnClose()) {
                FilterChain fc = (FilterChain)HttpTransactionContext.this.connection.getProcessor();
                fc.fireEventUpstream(HttpTransactionContext.this.connection, (FilterChainEvent)new GracefulCloseEvent(HttpTransactionContext.this), null);
            } else if (CloseType.REMOTELY.equals((Object)type)) {
                HttpTransactionContext.this.abort(AsyncHttpProviderUtils.REMOTELY_CLOSED_EXCEPTION);
            } else {
                try {
                    closeable.assertOpen();
                }
                catch (IOException ioe) {
                    HttpTransactionContext.this.abort(ioe);
                }
            }
        }
    };

    static void bind(HttpContext httpCtx, HttpTransactionContext httpTxContext) {
        httpCtx.getCloseable().addCloseListener(httpTxContext.listener);
        REQUEST_STATE_ATTR.set((AttributeStorage)httpCtx, (Object)httpTxContext);
    }

    static void cleanupTransaction(HttpContext httpCtx, CompletionHandler<HttpTransactionContext> completionHandler) {
        HttpTransactionContext httpTxContext = HttpTransactionContext.currentTransaction(httpCtx);
        assert (httpTxContext != null);
        if (httpTxContext.isRequestFullySent) {
            HttpTransactionContext.cleanupTransaction(httpCtx, httpTxContext);
            completionHandler.completed((Object)httpTxContext);
        } else {
            httpTxContext.addRequestSentCompletionHandler(completionHandler);
            if (httpTxContext.isRequestFullySent && httpTxContext.removeRequestSentCompletionHandler(completionHandler)) {
                completionHandler.completed((Object)httpTxContext);
            }
        }
    }

    static void cleanupTransaction(HttpContext httpCtx, HttpTransactionContext httpTxContext) {
        httpCtx.getCloseable().removeCloseListener(httpTxContext.listener);
        REQUEST_STATE_ATTR.remove((AttributeStorage)httpCtx);
    }

    static HttpTransactionContext currentTransaction(HttpHeader httpHeader) {
        return HttpTransactionContext.currentTransaction(httpHeader.getProcessingState().getHttpContext());
    }

    static HttpTransactionContext currentTransaction(AttributeStorage storage) {
        return (HttpTransactionContext)REQUEST_STATE_ATTR.get(storage);
    }

    static HttpTransactionContext currentTransaction(HttpContext httpCtx) {
        return ((AhcHttpContext)httpCtx).getHttpTransactionContext();
    }

    static HttpTransactionContext startTransaction(Connection connection, GrizzlyAsyncHttpProvider provider, Request request, GrizzlyResponseFuture future) {
        return new HttpTransactionContext(provider, connection, future, request);
    }

    private HttpTransactionContext(GrizzlyAsyncHttpProvider provider, Connection connection, GrizzlyResponseFuture future, Request ahcRequest) {
        this.provider = provider;
        this.connection = connection;
        this.future = future;
        this.ahcRequest = ahcRequest;
        this.proxyServer = ProxyUtils.getProxyServer(provider.getClientConfig(), ahcRequest);
        this.redirectsAllowed = provider.getClientConfig().isFollowRedirect();
        this.maxRedirectCount = provider.getClientConfig().getMaxRedirects();
        this.requestUri = ahcRequest.getUri();
    }

    Connection getConnection() {
        return this.connection;
    }

    AsyncHandler getAsyncHandler() {
        return this.future.getAsyncHandler();
    }

    Request getAhcRequest() {
        return this.ahcRequest;
    }

    ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    HttpTransactionContext cloneAndStartTransactionFor(Connection connection) {
        return this.cloneAndStartTransactionFor(connection, this.ahcRequest);
    }

    HttpTransactionContext cloneAndStartTransactionFor(Connection connection, Request request) {
        HttpTransactionContext newContext = HttpTransactionContext.startTransaction(connection, this.provider, request, this.future);
        newContext.invocationStatus = this.invocationStatus;
        newContext.payloadGenerator = this.payloadGenerator;
        newContext.currentState = this.currentState;
        newContext.statusHandler = this.statusHandler;
        newContext.lastRedirectUri = this.lastRedirectUri;
        newContext.redirectCount = this.redirectCount;
        this.future = null;
        return newContext;
    }

    boolean isGracefullyFinishResponseOnClose() {
        HttpResponsePacket response = this.responsePacket;
        return response != null && !response.getProcessingState().isKeepAlive() && !response.isChunked() && response.getContentLength() == -1L;
    }

    void abort(Throwable t) {
        if (this.future != null) {
            this.future.abort(t);
        }
    }

    void done() {
        this.done(null);
    }

    void done(Object result) {
        if (this.future != null) {
            this.future.done(result);
        }
    }

    boolean isTunnelEstablished(Connection c) {
        return c.getAttributes().getAttribute("tunnel-established") != null;
    }

    void tunnelEstablished(Connection c) {
        c.getAttributes().setAttribute("tunnel-established", (Object)Boolean.TRUE);
    }

    void reuseConnection() {
        this.isReuseConnection = true;
    }

    boolean isReuseConnection() {
        return this.isReuseConnection;
    }

    void touchConnection() {
        this.provider.touchConnection(this.connection, this.ahcRequest);
    }

    void closeConnection() {
        this.connection.closeSilently();
    }

    private synchronized void addRequestSentCompletionHandler(CompletionHandler<HttpTransactionContext> completionHandler) {
        if (this.reqFullySentHandlers == null) {
            this.reqFullySentHandlers = new HashSet<CompletionHandler<HttpTransactionContext>>();
        }
        this.reqFullySentHandlers.add(completionHandler);
    }

    private synchronized boolean removeRequestSentCompletionHandler(CompletionHandler<HttpTransactionContext> completionHandler) {
        return this.reqFullySentHandlers != null ? this.reqFullySentHandlers.remove(completionHandler) : false;
    }

    boolean isRequestFullySent() {
        return this.isRequestFullySent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRequestFullySent() {
        this.isRequestFullySent = true;
        Object[] handlers = null;
        Object[] objectArray = this;
        synchronized (this) {
            if (this.reqFullySentHandlers != null) {
                handlers = this.reqFullySentHandlers.toArray();
                this.reqFullySentHandlers = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (handlers != null) {
                for (Object o : handlers) {
                    try {
                        ((CompletionHandler)o).completed((Object)this);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return;
        }
    }
}

