/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client;

import com.hubspot.horizon.shaded.com.ning.http.client.HttpResponseBodyPart;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class HttpResponseBodyPartsInputStream
extends InputStream {
    private final List<HttpResponseBodyPart> parts;
    private int currentPos = 0;
    private int bytePos = -1;
    private byte[] active;
    private int available = 0;

    public HttpResponseBodyPartsInputStream(List<HttpResponseBodyPart> parts) {
        this.parts = parts;
        this.active = parts.get(0).getBodyPartBytes();
        this.computeLength(parts);
    }

    private void computeLength(List<HttpResponseBodyPart> parts) {
        if (this.available == 0) {
            for (HttpResponseBodyPart p : parts) {
                this.available += p.getBodyPartBytes().length;
            }
        }
    }

    @Override
    public int available() throws IOException {
        return this.available;
    }

    @Override
    public int read() throws IOException {
        if (++this.bytePos >= this.active.length) {
            if (++this.currentPos >= this.parts.size()) {
                return -1;
            }
            this.bytePos = 0;
            this.active = this.parts.get(this.currentPos).getBodyPartBytes();
        }
        return this.active[this.bytePos] & 0xFF;
    }
}

