/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.ning.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hubspot.horizon.Header;
import com.hubspot.horizon.Headers;
import com.hubspot.horizon.HttpRequest;
import com.hubspot.horizon.internal.AbstractHttpResponse;
import com.hubspot.horizon.shaded.com.ning.http.client.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NingHttpResponse
extends AbstractHttpResponse {
    private final HttpRequest request;
    private final int statusCode;
    private final Headers headers;
    private final InputStream responseStream;
    private final ObjectMapper mapper;

    public NingHttpResponse(HttpRequest request, Response ningResponse, ObjectMapper mapper) throws IOException {
        this.request = request;
        this.statusCode = ningResponse.getStatusCode();
        this.headers = this.convertHeaders(ningResponse.getHeaders());
        this.responseStream = ningResponse.getResponseBodyAsStream();
        this.mapper = mapper;
    }

    private Headers convertHeaders(Map<String, List<String>> ningHeaders) {
        ArrayList<Header> headers = new ArrayList<Header>();
        for (Map.Entry<String, List<String>> ningHeader : ningHeaders.entrySet()) {
            String name = ningHeader.getKey();
            for (String value : ningHeader.getValue()) {
                headers.add(new Header(name, value));
            }
        }
        return new Headers(headers);
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public InputStream getAsInputStream() {
        return this.responseStream;
    }
}

