/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.ning.internal;

import com.hubspot.horizon.SSLConfig;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class NingHostnameVerifier
implements HostnameVerifier {
    private final boolean acceptAllSSL;
    private static final String[] BAD_COUNTRY_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};
    private static final Pattern IPV4_PATTERN;
    private static final Pattern IPV6_STD_PATTERN;
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN;

    public NingHostnameVerifier(SSLConfig config) {
        this.acceptAllSSL = config.isAcceptAllSSL();
    }

    @Override
    public boolean verify(String host, SSLSession session) {
        if (this.acceptAllSSL) {
            return true;
        }
        try {
            Certificate[] certs = session.getPeerCertificates();
            X509Certificate x509 = (X509Certificate)certs[0];
            this.verify(host, x509);
            return true;
        }
        catch (SSLException e) {
            return false;
        }
    }

    private void verify(String host, X509Certificate cert) throws SSLException {
        List<String> cns = NingHostnameVerifier.getCNs(cert);
        List<String> subjectAlts = NingHostnameVerifier.getSubjectAlts(cert, host);
        LinkedList<String> names = new LinkedList<String>();
        if (!cns.isEmpty()) {
            names.add(cns.get(0));
        }
        names.addAll(subjectAlts);
        if (names.isEmpty()) {
            String msg = "Certificate for <" + host + "> doesn't contain CN or DNS subjectAlt";
            throw new SSLException(msg);
        }
        StringBuilder buf = new StringBuilder();
        String hostName = host.trim().toLowerCase(Locale.US);
        boolean match = false;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String[] parts;
            boolean doWildcard;
            String cn = (String)it.next();
            cn = cn.toLowerCase(Locale.US);
            buf.append(" <");
            buf.append(cn);
            buf.append('>');
            if (it.hasNext()) {
                buf.append(" OR");
            }
            boolean bl = doWildcard = (parts = cn.split("\\.")).length >= 3 && parts[0].endsWith("*") && NingHostnameVerifier.acceptableCountryWildcard(cn) && !NingHostnameVerifier.isIPAddress(host);
            if (doWildcard) {
                String firstpart = parts[0];
                if (firstpart.length() > 1) {
                    String prefix = firstpart.substring(0, firstpart.length() - 1);
                    String suffix = cn.substring(firstpart.length());
                    String hostSuffix = hostName.substring(prefix.length());
                    match = hostName.startsWith(prefix) && hostSuffix.endsWith(suffix);
                } else {
                    match = hostName.endsWith(cn.substring(1));
                }
            } else {
                match = hostName.equals(cn);
            }
            if (!match) continue;
            break;
        }
        if (!match) {
            throw new SSLException("hostname in certificate didn't match: <" + host + "> !=" + buf);
        }
    }

    private static boolean acceptableCountryWildcard(String cn) {
        String[] parts = cn.split("\\.");
        if (parts.length != 3 || parts[2].length() != 2) {
            return true;
        }
        return Arrays.binarySearch(BAD_COUNTRY_2LDS, parts[1]) < 0;
    }

    private static List<String> getCNs(X509Certificate cert) {
        LinkedList<String> cnList = new LinkedList<String>();
        String subjectPrincipal = cert.getSubjectX500Principal().toString();
        StringTokenizer st = new StringTokenizer(subjectPrincipal, ",+");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken().trim();
            if (tok.length() <= 3 || !tok.substring(0, 3).equalsIgnoreCase("CN=")) continue;
            cnList.add(tok.substring(3));
        }
        return cnList;
    }

    private static List<String> getSubjectAlts(X509Certificate cert, @Nullable String hostname) {
        int subjectType = NingHostnameVerifier.isIPAddress(hostname) ? 7 : 2;
        LinkedList<String> subjectAltList = new LinkedList<String>();
        try {
            for (List<?> aC : cert.getSubjectAlternativeNames()) {
                String s;
                int type = (Integer)aC.get(0);
                if (type != subjectType || (s = (String)aC.get(1)) == null) continue;
                subjectAltList.add(s);
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        return subjectAltList;
    }

    private static boolean isIPAddress(@Nullable String hostname) {
        return hostname != null && (NingHostnameVerifier.isIPv4Address(hostname) || NingHostnameVerifier.isIPv6Address(hostname));
    }

    private static boolean isIPv4Address(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    private static boolean isIPv6Address(String input) {
        return NingHostnameVerifier.isIPv6StdAddress(input) || NingHostnameVerifier.isIPv6HexCompressedAddress(input);
    }

    private static boolean isIPv6StdAddress(String input) {
        return IPV6_STD_PATTERN.matcher(input).matches();
    }

    private static boolean isIPv6HexCompressedAddress(String input) {
        int colonCount = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != ':') continue;
            ++colonCount;
        }
        return colonCount <= 7 && IPV6_HEX_COMPRESSED_PATTERN.matcher(input).matches();
    }

    static {
        Arrays.sort(BAD_COUNTRY_2LDS);
        IPV4_PATTERN = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
        IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
        IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    }
}

