/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.smn.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.smn.v2.model.PollingPolicyRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class NotifyPolicyRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="protocol")
    private ProtocolEnum protocol;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="polling")
    private List<PollingPolicyRequest> polling = null;

    public NotifyPolicyRequestBody withProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
        return this;
    }

    public ProtocolEnum getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
    }

    public NotifyPolicyRequestBody withPolling(List<PollingPolicyRequest> polling) {
        this.polling = polling;
        return this;
    }

    public NotifyPolicyRequestBody addPollingItem(PollingPolicyRequest pollingItem) {
        if (this.polling == null) {
            this.polling = new ArrayList<PollingPolicyRequest>();
        }
        this.polling.add(pollingItem);
        return this;
    }

    public NotifyPolicyRequestBody withPolling(Consumer<List<PollingPolicyRequest>> pollingSetter) {
        if (this.polling == null) {
            this.polling = new ArrayList<PollingPolicyRequest>();
        }
        pollingSetter.accept(this.polling);
        return this;
    }

    public List<PollingPolicyRequest> getPolling() {
        return this.polling;
    }

    public void setPolling(List<PollingPolicyRequest> polling) {
        this.polling = polling;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NotifyPolicyRequestBody that = (NotifyPolicyRequestBody)obj;
        return Objects.equals(this.protocol, that.protocol) && Objects.equals(this.polling, that.polling);
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.polling);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotifyPolicyRequestBody {\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("    polling: ").append(this.toIndentedString(this.polling)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ProtocolEnum {
        public static final ProtocolEnum CALLNOTIFY = new ProtocolEnum("callnotify");
        private static final Map<String, ProtocolEnum> STATIC_FIELDS = ProtocolEnum.createStaticFields();
        private String value;

        private static Map<String, ProtocolEnum> createStaticFields() {
            HashMap<String, ProtocolEnum> map = new HashMap<String, ProtocolEnum>();
            map.put("callnotify", CALLNOTIFY);
            return Collections.unmodifiableMap(map);
        }

        ProtocolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ProtocolEnum(value));
        }

        public static ProtocolEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProtocolEnum) {
                return this.value.equals(((ProtocolEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

