/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.image.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class ImageHighresolutionMattingInference {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="return_type")
    private ReturnTypeEnum returnType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="coord")
    private List<Integer> coord = null;

    public ImageHighresolutionMattingInference withReturnType(ReturnTypeEnum returnType) {
        this.returnType = returnType;
        return this;
    }

    public ReturnTypeEnum getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ReturnTypeEnum returnType) {
        this.returnType = returnType;
    }

    public ImageHighresolutionMattingInference withCoord(List<Integer> coord) {
        this.coord = coord;
        return this;
    }

    public ImageHighresolutionMattingInference addCoordItem(Integer coordItem) {
        if (this.coord == null) {
            this.coord = new ArrayList<Integer>();
        }
        this.coord.add(coordItem);
        return this;
    }

    public ImageHighresolutionMattingInference withCoord(Consumer<List<Integer>> coordSetter) {
        if (this.coord == null) {
            this.coord = new ArrayList<Integer>();
        }
        coordSetter.accept(this.coord);
        return this;
    }

    public List<Integer> getCoord() {
        return this.coord;
    }

    public void setCoord(List<Integer> coord) {
        this.coord = coord;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImageHighresolutionMattingInference that = (ImageHighresolutionMattingInference)obj;
        return Objects.equals(this.returnType, that.returnType) && Objects.equals(this.coord, that.coord);
    }

    public int hashCode() {
        return Objects.hash(this.returnType, this.coord);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageHighresolutionMattingInference {\n");
        sb.append("    returnType: ").append(this.toIndentedString(this.returnType)).append("\n");
        sb.append("    coord: ").append(this.toIndentedString(this.coord)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ReturnTypeEnum {
        public static final ReturnTypeEnum FOREGROUND = new ReturnTypeEnum("foreground");
        public static final ReturnTypeEnum ALPHA = new ReturnTypeEnum("alpha");
        private static final Map<String, ReturnTypeEnum> STATIC_FIELDS = ReturnTypeEnum.createStaticFields();
        private String value;

        private static Map<String, ReturnTypeEnum> createStaticFields() {
            HashMap<String, ReturnTypeEnum> map = new HashMap<String, ReturnTypeEnum>();
            map.put("foreground", FOREGROUND);
            map.put("alpha", ALPHA);
            return Collections.unmodifiableMap(map);
        }

        ReturnTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReturnTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ReturnTypeEnum(value));
        }

        public static ReturnTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ReturnTypeEnum) {
                return this.value.equals(((ReturnTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

