package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huaweicloud.sdk.core.SdkResponse;

import java.util.Objects;
import java.util.function.Consumer;

/**
 * Response Object
 */
public class UpdateLoginProtectResponse extends SdkResponse {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "login_protect")

    private UpdateLoginProtectRespon loginProtect;

    public UpdateLoginProtectResponse withLoginProtect(UpdateLoginProtectRespon loginProtect) {
        this.loginProtect = loginProtect;
        return this;
    }

    public UpdateLoginProtectResponse withLoginProtect(Consumer<UpdateLoginProtectRespon> loginProtectSetter) {
        if (this.loginProtect == null) {
            this.loginProtect = new UpdateLoginProtectRespon();
            loginProtectSetter.accept(this.loginProtect);
        }

        return this;
    }

    /**
     * Get loginProtect
     * @return loginProtect
     */
    public UpdateLoginProtectRespon getLoginProtect() {
        return loginProtect;
    }

    public void setLoginProtect(UpdateLoginProtectRespon loginProtect) {
        this.loginProtect = loginProtect;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || getClass() != obj.getClass()) {
            return false;
        }
        UpdateLoginProtectResponse that = (UpdateLoginProtectResponse) obj;
        return Objects.equals(this.loginProtect, that.loginProtect);
    }

    @Override
    public int hashCode() {
        return Objects.hash(loginProtect);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateLoginProtectResponse {\n");
        sb.append("    loginProtect: ").append(toIndentedString(loginProtect)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
