package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

/**
 * 
 */
public class RegionLocales {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "zh-cn")

    private String zhCn;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "en-us")

    private String enUs;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "pt-br")

    private String ptBr;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "es-us")

    private String esUs;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "es-es")

    private String esEs;

    public RegionLocales withZhCn(String zhCn) {
        this.zhCn = zhCn;
        return this;
    }

    /**
     * 区域的中文名称。
     * @return zhCn
     */
    public String getZhCn() {
        return zhCn;
    }

    public void setZhCn(String zhCn) {
        this.zhCn = zhCn;
    }

    public RegionLocales withEnUs(String enUs) {
        this.enUs = enUs;
        return this;
    }

    /**
     * 区域的英文名称。
     * @return enUs
     */
    public String getEnUs() {
        return enUs;
    }

    public void setEnUs(String enUs) {
        this.enUs = enUs;
    }

    public RegionLocales withPtBr(String ptBr) {
        this.ptBr = ptBr;
        return this;
    }

    /**
     * 区域的葡萄牙语名称。
     * @return ptBr
     */
    public String getPtBr() {
        return ptBr;
    }

    public void setPtBr(String ptBr) {
        this.ptBr = ptBr;
    }

    public RegionLocales withEsUs(String esUs) {
        this.esUs = esUs;
        return this;
    }

    /**
     * 区域的美国西班牙语名称。
     * @return esUs
     */
    public String getEsUs() {
        return esUs;
    }

    public void setEsUs(String esUs) {
        this.esUs = esUs;
    }

    public RegionLocales withEsEs(String esEs) {
        this.esEs = esEs;
        return this;
    }

    /**
     * 区域的西班牙语名称。
     * @return esEs
     */
    public String getEsEs() {
        return esEs;
    }

    public void setEsEs(String esEs) {
        this.esEs = esEs;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || getClass() != obj.getClass()) {
            return false;
        }
        RegionLocales that = (RegionLocales) obj;
        return Objects.equals(this.zhCn, that.zhCn) && Objects.equals(this.enUs, that.enUs)
            && Objects.equals(this.ptBr, that.ptBr) && Objects.equals(this.esUs, that.esUs)
            && Objects.equals(this.esEs, that.esEs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(zhCn, enUs, ptBr, esUs, esEs);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegionLocales {\n");
        sb.append("    zhCn: ").append(toIndentedString(zhCn)).append("\n");
        sb.append("    enUs: ").append(toIndentedString(enUs)).append("\n");
        sb.append("    ptBr: ").append(toIndentedString(ptBr)).append("\n");
        sb.append("    esUs: ").append(toIndentedString(esUs)).append("\n");
        sb.append("    esEs: ").append(toIndentedString(esEs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
