package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * oidc详细信息
 */
public class UpdateOpenIdConnectConfig {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "access_mode")

    private String accessMode;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "idp_url")

    private String idpUrl;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "client_id")

    private String clientId;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "authorization_endpoint")

    private String authorizationEndpoint;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "scope")

    private String scope;

    /**
     * 授权请求返回的类型；值为id_token ；编程访问和管理控制台访问方式值不可为空，编程访问方式值可为空 
     */
    public static final class ResponseTypeEnum {

        /**
         * Enum ID_TOKEN for value: "id_token"
         */
        public static final ResponseTypeEnum ID_TOKEN = new ResponseTypeEnum("id_token");

        private static final Map<String, ResponseTypeEnum> STATIC_FIELDS = createStaticFields();

        private static Map<String, ResponseTypeEnum> createStaticFields() {
            Map<String, ResponseTypeEnum> map = new HashMap<>();
            map.put("id_token", ID_TOKEN);
            return Collections.unmodifiableMap(map);
        }

        private String value;

        ResponseTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ResponseTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return java.util.Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ResponseTypeEnum(value));
        }

        public static ResponseTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return java.util.Optional.ofNullable(STATIC_FIELDS.get(value))
                .orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ResponseTypeEnum) {
                return this.value.equals(((ResponseTypeEnum) obj).value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "response_type")

    private ResponseTypeEnum responseType;

    /**
     * 授权请求返回方式，可选值 form_post 或 fragment ；编程访问和管理控制台访问方式值为可选值，编程访问方式值可为空
     */
    public static final class ResponseModeEnum {

        /**
         * Enum FRAGMENT for value: "fragment"
         */
        public static final ResponseModeEnum FRAGMENT = new ResponseModeEnum("fragment");

        /**
         * Enum FORM_POST for value: "form_post"
         */
        public static final ResponseModeEnum FORM_POST = new ResponseModeEnum("form_post");

        private static final Map<String, ResponseModeEnum> STATIC_FIELDS = createStaticFields();

        private static Map<String, ResponseModeEnum> createStaticFields() {
            Map<String, ResponseModeEnum> map = new HashMap<>();
            map.put("fragment", FRAGMENT);
            map.put("form_post", FORM_POST);
            return Collections.unmodifiableMap(map);
        }

        private String value;

        ResponseModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ResponseModeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return java.util.Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ResponseModeEnum(value));
        }

        public static ResponseModeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return java.util.Optional.ofNullable(STATIC_FIELDS.get(value))
                .orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ResponseModeEnum) {
                return this.value.equals(((ResponseModeEnum) obj).value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "response_mode")

    private ResponseModeEnum responseMode;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "signing_key")

    private String signingKey;

    public UpdateOpenIdConnectConfig withAccessMode(String accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    /**
     * 访问方式: program_console: 支持编程访问和管理控制台访问方式; program: 支持编程访问方式
     * @return accessMode
     */
    public String getAccessMode() {
        return accessMode;
    }

    public void setAccessMode(String accessMode) {
        this.accessMode = accessMode;
    }

    public UpdateOpenIdConnectConfig withIdpUrl(String idpUrl) {
        this.idpUrl = idpUrl;
        return this;
    }

    /**
     * OpenID Connect身份提供商标识，对应ID token 中 iss
     * @return idpUrl
     */
    public String getIdpUrl() {
        return idpUrl;
    }

    public void setIdpUrl(String idpUrl) {
        this.idpUrl = idpUrl;
    }

    public UpdateOpenIdConnectConfig withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * 在OpenID Connect身份提供商注册的客户端ID
     * @return clientId
     */
    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public UpdateOpenIdConnectConfig withAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    /**
     * OpenID Connect身份提供商授权地址；编程访问和管理控制台访问方式值不可为空，编程访问方式值可为空
     * @return authorizationEndpoint
     */
    public String getAuthorizationEndpoint() {
        return authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public UpdateOpenIdConnectConfig withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * 授权请求信息范围，编程访问和管理控制台访问方式必选，编程访问方式不可选，可选值：openid 、email、profile，IDP自定义scope，字符集a-zA-Z_0-9 ，1-10个可选值组合空格分割，至少包括openid，顺序无关，总长度最长255字符，例如：\"openid\"、\"openid email\"、\"openid profile\" 、\"openid email profile\"
     * @return scope
     */
    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public UpdateOpenIdConnectConfig withResponseType(ResponseTypeEnum responseType) {
        this.responseType = responseType;
        return this;
    }

    /**
     * 授权请求返回的类型；值为id_token ；编程访问和管理控制台访问方式值不可为空，编程访问方式值可为空 
     * @return responseType
     */
    public ResponseTypeEnum getResponseType() {
        return responseType;
    }

    public void setResponseType(ResponseTypeEnum responseType) {
        this.responseType = responseType;
    }

    public UpdateOpenIdConnectConfig withResponseMode(ResponseModeEnum responseMode) {
        this.responseMode = responseMode;
        return this;
    }

    /**
     * 授权请求返回方式，可选值 form_post 或 fragment ；编程访问和管理控制台访问方式值为可选值，编程访问方式值可为空
     * @return responseMode
     */
    public ResponseModeEnum getResponseMode() {
        return responseMode;
    }

    public void setResponseMode(ResponseModeEnum responseMode) {
        this.responseMode = responseMode;
    }

    public UpdateOpenIdConnectConfig withSigningKey(String signingKey) {
        this.signingKey = signingKey;
        return this;
    }

    /**
     * OpenID Connect身份提供商ID Token签名的公钥
     * @return signingKey
     */
    public String getSigningKey() {
        return signingKey;
    }

    public void setSigningKey(String signingKey) {
        this.signingKey = signingKey;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || getClass() != obj.getClass()) {
            return false;
        }
        UpdateOpenIdConnectConfig that = (UpdateOpenIdConnectConfig) obj;
        return Objects.equals(this.accessMode, that.accessMode) && Objects.equals(this.idpUrl, that.idpUrl)
            && Objects.equals(this.clientId, that.clientId)
            && Objects.equals(this.authorizationEndpoint, that.authorizationEndpoint)
            && Objects.equals(this.scope, that.scope) && Objects.equals(this.responseType, that.responseType)
            && Objects.equals(this.responseMode, that.responseMode) && Objects.equals(this.signingKey, that.signingKey);
    }

    @Override
    public int hashCode() {
        return Objects
            .hash(accessMode, idpUrl, clientId, authorizationEndpoint, scope, responseType, responseMode, signingKey);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateOpenIdConnectConfig {\n");
        sb.append("    accessMode: ").append(toIndentedString(accessMode)).append("\n");
        sb.append("    idpUrl: ").append(toIndentedString(idpUrl)).append("\n");
        sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
        sb.append("    authorizationEndpoint: ").append(toIndentedString(authorizationEndpoint)).append("\n");
        sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
        sb.append("    responseType: ").append(toIndentedString(responseType)).append("\n");
        sb.append("    responseMode: ").append(toIndentedString(responseMode)).append("\n");
        sb.append("    signingKey: ").append(toIndentedString(signingKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
