/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CreateOpenIdConnectConfig {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="access_mode")
    private String accessMode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="idp_url")
    private String idpUrl;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="authorization_endpoint")
    private String authorizationEndpoint;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="scope")
    private String scope;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="response_type")
    private ResponseTypeEnum responseType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="response_mode")
    private ResponseModeEnum responseMode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="signing_key")
    private String signingKey;

    public CreateOpenIdConnectConfig withAccessMode(String accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    public String getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(String accessMode) {
        this.accessMode = accessMode;
    }

    public CreateOpenIdConnectConfig withIdpUrl(String idpUrl) {
        this.idpUrl = idpUrl;
        return this;
    }

    public String getIdpUrl() {
        return this.idpUrl;
    }

    public void setIdpUrl(String idpUrl) {
        this.idpUrl = idpUrl;
    }

    public CreateOpenIdConnectConfig withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CreateOpenIdConnectConfig withAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public CreateOpenIdConnectConfig withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public CreateOpenIdConnectConfig withResponseType(ResponseTypeEnum responseType) {
        this.responseType = responseType;
        return this;
    }

    public ResponseTypeEnum getResponseType() {
        return this.responseType;
    }

    public void setResponseType(ResponseTypeEnum responseType) {
        this.responseType = responseType;
    }

    public CreateOpenIdConnectConfig withResponseMode(ResponseModeEnum responseMode) {
        this.responseMode = responseMode;
        return this;
    }

    public ResponseModeEnum getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(ResponseModeEnum responseMode) {
        this.responseMode = responseMode;
    }

    public CreateOpenIdConnectConfig withSigningKey(String signingKey) {
        this.signingKey = signingKey;
        return this;
    }

    public String getSigningKey() {
        return this.signingKey;
    }

    public void setSigningKey(String signingKey) {
        this.signingKey = signingKey;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateOpenIdConnectConfig that = (CreateOpenIdConnectConfig)obj;
        return Objects.equals(this.accessMode, that.accessMode) && Objects.equals(this.idpUrl, that.idpUrl) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.authorizationEndpoint, that.authorizationEndpoint) && Objects.equals(this.scope, that.scope) && Objects.equals(this.responseType, that.responseType) && Objects.equals(this.responseMode, that.responseMode) && Objects.equals(this.signingKey, that.signingKey);
    }

    public int hashCode() {
        return Objects.hash(this.accessMode, this.idpUrl, this.clientId, this.authorizationEndpoint, this.scope, this.responseType, this.responseMode, this.signingKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOpenIdConnectConfig {\n");
        sb.append("    accessMode: ").append(this.toIndentedString(this.accessMode)).append("\n");
        sb.append("    idpUrl: ").append(this.toIndentedString(this.idpUrl)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    authorizationEndpoint: ").append(this.toIndentedString(this.authorizationEndpoint)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    responseType: ").append(this.toIndentedString(this.responseType)).append("\n");
        sb.append("    responseMode: ").append(this.toIndentedString(this.responseMode)).append("\n");
        sb.append("    signingKey: ").append(this.toIndentedString(this.signingKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ResponseModeEnum {
        public static final ResponseModeEnum FRAGMENT = new ResponseModeEnum("fragment");
        public static final ResponseModeEnum FORM_POST = new ResponseModeEnum("form_post");
        private static final Map<String, ResponseModeEnum> STATIC_FIELDS = ResponseModeEnum.createStaticFields();
        private String value;

        private static Map<String, ResponseModeEnum> createStaticFields() {
            HashMap<String, ResponseModeEnum> map = new HashMap<String, ResponseModeEnum>();
            map.put("fragment", FRAGMENT);
            map.put("form_post", FORM_POST);
            return Collections.unmodifiableMap(map);
        }

        ResponseModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResponseModeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ResponseModeEnum(value));
        }

        public static ResponseModeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResponseModeEnum) {
                return this.value.equals(((ResponseModeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class ResponseTypeEnum {
        public static final ResponseTypeEnum ID_TOKEN = new ResponseTypeEnum("id_token");
        private static final Map<String, ResponseTypeEnum> STATIC_FIELDS = ResponseTypeEnum.createStaticFields();
        private String value;

        private static Map<String, ResponseTypeEnum> createStaticFields() {
            HashMap<String, ResponseTypeEnum> map = new HashMap<String, ResponseTypeEnum>();
            map.put("id_token", ID_TOKEN);
            return Collections.unmodifiableMap(map);
        }

        ResponseTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResponseTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ResponseTypeEnum(value));
        }

        public static ResponseTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResponseTypeEnum) {
                return this.value.equals(((ResponseTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

