/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iam.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class DeleteResourceTagsV5Request {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="resource_id")
    private String resourceId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="resource_type")
    private ResourceTypeEnum resourceType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="body")
    private List<String> body = null;

    public DeleteResourceTagsV5Request withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public DeleteResourceTagsV5Request withResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public DeleteResourceTagsV5Request withBody(List<String> body) {
        this.body = body;
        return this;
    }

    public DeleteResourceTagsV5Request addBodyItem(String bodyItem) {
        if (this.body == null) {
            this.body = new ArrayList<String>();
        }
        this.body.add(bodyItem);
        return this;
    }

    public DeleteResourceTagsV5Request withBody(Consumer<List<String>> bodySetter) {
        if (this.body == null) {
            this.body = new ArrayList<String>();
        }
        bodySetter.accept(this.body);
        return this;
    }

    public List<String> getBody() {
        return this.body;
    }

    public void setBody(List<String> body) {
        this.body = body;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteResourceTagsV5Request that = (DeleteResourceTagsV5Request)obj;
        return Objects.equals(this.resourceId, that.resourceId) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.resourceId, this.resourceType, this.body);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeleteResourceTagsV5Request {\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString(this.resourceType)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ResourceTypeEnum {
        public static final ResourceTypeEnum AGENCY = new ResourceTypeEnum("agency");
        public static final ResourceTypeEnum USER = new ResourceTypeEnum("user");
        private static final Map<String, ResourceTypeEnum> STATIC_FIELDS = ResourceTypeEnum.createStaticFields();
        private String value;

        private static Map<String, ResourceTypeEnum> createStaticFields() {
            HashMap<String, ResourceTypeEnum> map = new HashMap<String, ResourceTypeEnum>();
            map.put("agency", AGENCY);
            map.put("user", USER);
            return Collections.unmodifiableMap(map);
        }

        ResourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResourceTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ResourceTypeEnum(value));
        }

        public static ResourceTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResourceTypeEnum) {
                return this.value.equals(((ResourceTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

