/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iam.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.iam.v5.model.Description;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class Condition {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="key")
    private String key;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="value_type")
    private ValueTypeEnum valueType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="multi_valued")
    private Boolean multiValued;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="description")
    private Description description;

    public Condition withKey(String key) {
        this.key = key;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Condition withValueType(ValueTypeEnum valueType) {
        this.valueType = valueType;
        return this;
    }

    public ValueTypeEnum getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueTypeEnum valueType) {
        this.valueType = valueType;
    }

    public Condition withMultiValued(Boolean multiValued) {
        this.multiValued = multiValued;
        return this;
    }

    public Boolean getMultiValued() {
        return this.multiValued;
    }

    public void setMultiValued(Boolean multiValued) {
        this.multiValued = multiValued;
    }

    public Condition withDescription(Description description) {
        this.description = description;
        return this;
    }

    public Condition withDescription(Consumer<Description> descriptionSetter) {
        if (this.description == null) {
            this.description = new Description();
            descriptionSetter.accept(this.description);
        }
        return this;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Condition that = (Condition)obj;
        return Objects.equals(this.key, that.key) && Objects.equals(this.valueType, that.valueType) && Objects.equals(this.multiValued, that.multiValued) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.valueType, this.multiValued, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Condition {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    multiValued: ").append(this.toIndentedString(this.multiValued)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ValueTypeEnum {
        public static final ValueTypeEnum STRING = new ValueTypeEnum("string");
        public static final ValueTypeEnum NUMERIC = new ValueTypeEnum("numeric");
        public static final ValueTypeEnum DATE = new ValueTypeEnum("date");
        public static final ValueTypeEnum BOOLEAN = new ValueTypeEnum("boolean");
        public static final ValueTypeEnum IP_ADDRESS = new ValueTypeEnum("ip_address");
        private static final Map<String, ValueTypeEnum> STATIC_FIELDS = ValueTypeEnum.createStaticFields();
        private String value;

        private static Map<String, ValueTypeEnum> createStaticFields() {
            HashMap<String, ValueTypeEnum> map = new HashMap<String, ValueTypeEnum>();
            map.put("string", STRING);
            map.put("numeric", NUMERIC);
            map.put("date", DATE);
            map.put("boolean", BOOLEAN);
            map.put("ip_address", IP_ADDRESS);
            return Collections.unmodifiableMap(map);
        }

        ValueTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ValueTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ValueTypeEnum(value));
        }

        public static ValueTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ValueTypeEnum) {
                return this.value.equals(((ValueTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

