/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iam.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.iam.v5.model.ActionAssociatedResource;
import com.huaweicloud.sdk.iam.v5.model.Description;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class Action {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="access_level")
    private AccessLevelEnum accessLevel;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="permission_only")
    private Boolean permissionOnly;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="description")
    private Description description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="aliases")
    private List<String> aliases = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="resources")
    private List<ActionAssociatedResource> resources = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="condition_keys")
    private List<String> conditionKeys = null;

    public Action withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Action withAccessLevel(AccessLevelEnum accessLevel) {
        this.accessLevel = accessLevel;
        return this;
    }

    public AccessLevelEnum getAccessLevel() {
        return this.accessLevel;
    }

    public void setAccessLevel(AccessLevelEnum accessLevel) {
        this.accessLevel = accessLevel;
    }

    public Action withPermissionOnly(Boolean permissionOnly) {
        this.permissionOnly = permissionOnly;
        return this;
    }

    public Boolean getPermissionOnly() {
        return this.permissionOnly;
    }

    public void setPermissionOnly(Boolean permissionOnly) {
        this.permissionOnly = permissionOnly;
    }

    public Action withDescription(Description description) {
        this.description = description;
        return this;
    }

    public Action withDescription(Consumer<Description> descriptionSetter) {
        if (this.description == null) {
            this.description = new Description();
            descriptionSetter.accept(this.description);
        }
        return this;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public Action withAliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public Action addAliasesItem(String aliasesItem) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        this.aliases.add(aliasesItem);
        return this;
    }

    public Action withAliases(Consumer<List<String>> aliasesSetter) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        aliasesSetter.accept(this.aliases);
        return this;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public Action withResources(List<ActionAssociatedResource> resources) {
        this.resources = resources;
        return this;
    }

    public Action addResourcesItem(ActionAssociatedResource resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<ActionAssociatedResource>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    public Action withResources(Consumer<List<ActionAssociatedResource>> resourcesSetter) {
        if (this.resources == null) {
            this.resources = new ArrayList<ActionAssociatedResource>();
        }
        resourcesSetter.accept(this.resources);
        return this;
    }

    public List<ActionAssociatedResource> getResources() {
        return this.resources;
    }

    public void setResources(List<ActionAssociatedResource> resources) {
        this.resources = resources;
    }

    public Action withConditionKeys(List<String> conditionKeys) {
        this.conditionKeys = conditionKeys;
        return this;
    }

    public Action addConditionKeysItem(String conditionKeysItem) {
        if (this.conditionKeys == null) {
            this.conditionKeys = new ArrayList<String>();
        }
        this.conditionKeys.add(conditionKeysItem);
        return this;
    }

    public Action withConditionKeys(Consumer<List<String>> conditionKeysSetter) {
        if (this.conditionKeys == null) {
            this.conditionKeys = new ArrayList<String>();
        }
        conditionKeysSetter.accept(this.conditionKeys);
        return this;
    }

    public List<String> getConditionKeys() {
        return this.conditionKeys;
    }

    public void setConditionKeys(List<String> conditionKeys) {
        this.conditionKeys = conditionKeys;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Action that = (Action)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.accessLevel, that.accessLevel) && Objects.equals(this.permissionOnly, that.permissionOnly) && Objects.equals(this.description, that.description) && Objects.equals(this.aliases, that.aliases) && Objects.equals(this.resources, that.resources) && Objects.equals(this.conditionKeys, that.conditionKeys);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.accessLevel, this.permissionOnly, this.description, this.aliases, this.resources, this.conditionKeys);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Action {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    accessLevel: ").append(this.toIndentedString(this.accessLevel)).append("\n");
        sb.append("    permissionOnly: ").append(this.toIndentedString(this.permissionOnly)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    aliases: ").append(this.toIndentedString(this.aliases)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    conditionKeys: ").append(this.toIndentedString(this.conditionKeys)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class AccessLevelEnum {
        public static final AccessLevelEnum LIST = new AccessLevelEnum("list");
        public static final AccessLevelEnum READ = new AccessLevelEnum("read");
        public static final AccessLevelEnum WRITE = new AccessLevelEnum("write");
        public static final AccessLevelEnum PERMISSION_MANAGEMENT = new AccessLevelEnum("permission_management");
        public static final AccessLevelEnum TAGGING = new AccessLevelEnum("tagging");
        private static final Map<String, AccessLevelEnum> STATIC_FIELDS = AccessLevelEnum.createStaticFields();
        private String value;

        private static Map<String, AccessLevelEnum> createStaticFields() {
            HashMap<String, AccessLevelEnum> map = new HashMap<String, AccessLevelEnum>();
            map.put("list", LIST);
            map.put("read", READ);
            map.put("write", WRITE);
            map.put("permission_management", PERMISSION_MANAGEMENT);
            map.put("tagging", TAGGING);
            return Collections.unmodifiableMap(map);
        }

        AccessLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccessLevelEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new AccessLevelEnum(value));
        }

        public static AccessLevelEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof AccessLevelEnum) {
                return this.value.equals(((AccessLevelEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

