/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huaweicloud.sdk.iam.v3.model.TokenCatalog;
import com.huaweicloud.sdk.iam.v3.model.TokenDomainResult;
import com.huaweicloud.sdk.iam.v3.model.TokenProjectResult;
import com.huaweicloud.sdk.iam.v3.model.TokenRole;
import com.huaweicloud.sdk.iam.v3.model.TokenUserResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class TokenResult {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="catalog")
    private List<TokenCatalog> catalog = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="domain")
    private TokenDomainResult domain;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="expires_at")
    private String expiresAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="issued_at")
    private String issuedAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="methods")
    private List<String> methods = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="project")
    private TokenProjectResult project;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="roles")
    private List<TokenRole> roles = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="user")
    private TokenUserResult user;

    public TokenResult withCatalog(List<TokenCatalog> catalog) {
        this.catalog = catalog;
        return this;
    }

    public TokenResult addCatalogItem(TokenCatalog catalogItem) {
        if (this.catalog == null) {
            this.catalog = new ArrayList<TokenCatalog>();
        }
        this.catalog.add(catalogItem);
        return this;
    }

    public TokenResult withCatalog(Consumer<List<TokenCatalog>> catalogSetter) {
        if (this.catalog == null) {
            this.catalog = new ArrayList<TokenCatalog>();
        }
        catalogSetter.accept(this.catalog);
        return this;
    }

    public List<TokenCatalog> getCatalog() {
        return this.catalog;
    }

    public void setCatalog(List<TokenCatalog> catalog) {
        this.catalog = catalog;
    }

    public TokenResult withDomain(TokenDomainResult domain) {
        this.domain = domain;
        return this;
    }

    public TokenResult withDomain(Consumer<TokenDomainResult> domainSetter) {
        if (this.domain == null) {
            this.domain = new TokenDomainResult();
            domainSetter.accept(this.domain);
        }
        return this;
    }

    public TokenDomainResult getDomain() {
        return this.domain;
    }

    public void setDomain(TokenDomainResult domain) {
        this.domain = domain;
    }

    public TokenResult withExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public TokenResult withIssuedAt(String issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    public String getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(String issuedAt) {
        this.issuedAt = issuedAt;
    }

    public TokenResult withMethods(List<String> methods) {
        this.methods = methods;
        return this;
    }

    public TokenResult addMethodsItem(String methodsItem) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        this.methods.add(methodsItem);
        return this;
    }

    public TokenResult withMethods(Consumer<List<String>> methodsSetter) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        methodsSetter.accept(this.methods);
        return this;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    public TokenResult withProject(TokenProjectResult project) {
        this.project = project;
        return this;
    }

    public TokenResult withProject(Consumer<TokenProjectResult> projectSetter) {
        if (this.project == null) {
            this.project = new TokenProjectResult();
            projectSetter.accept(this.project);
        }
        return this;
    }

    public TokenProjectResult getProject() {
        return this.project;
    }

    public void setProject(TokenProjectResult project) {
        this.project = project;
    }

    public TokenResult withRoles(List<TokenRole> roles) {
        this.roles = roles;
        return this;
    }

    public TokenResult addRolesItem(TokenRole rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<TokenRole>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    public TokenResult withRoles(Consumer<List<TokenRole>> rolesSetter) {
        if (this.roles == null) {
            this.roles = new ArrayList<TokenRole>();
        }
        rolesSetter.accept(this.roles);
        return this;
    }

    public List<TokenRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<TokenRole> roles) {
        this.roles = roles;
    }

    public TokenResult withUser(TokenUserResult user) {
        this.user = user;
        return this;
    }

    public TokenResult withUser(Consumer<TokenUserResult> userSetter) {
        if (this.user == null) {
            this.user = new TokenUserResult();
            userSetter.accept(this.user);
        }
        return this;
    }

    public TokenUserResult getUser() {
        return this.user;
    }

    public void setUser(TokenUserResult user) {
        this.user = user;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TokenResult that = (TokenResult)obj;
        return Objects.equals(this.catalog, that.catalog) && Objects.equals(this.domain, that.domain) && Objects.equals(this.expiresAt, that.expiresAt) && Objects.equals(this.issuedAt, that.issuedAt) && Objects.equals(this.methods, that.methods) && Objects.equals(this.project, that.project) && Objects.equals(this.roles, that.roles) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.catalog, this.domain, this.expiresAt, this.issuedAt, this.methods, this.project, this.roles, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenResult {\n");
        sb.append("    catalog: ").append(this.toIndentedString(this.catalog)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    issuedAt: ").append(this.toIndentedString(this.issuedAt)).append("\n");
        sb.append("    methods: ").append(this.toIndentedString(this.methods)).append("\n");
        sb.append("    project: ").append(this.toIndentedString(this.project)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

