/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.iam.v3.model.AgencyTokenAssumerole;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class AgencyTokenIdentity {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="methods")
    private List<MethodsEnum> methods = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="assume_role")
    private AgencyTokenAssumerole assumeRole;

    public AgencyTokenIdentity withMethods(List<MethodsEnum> methods) {
        this.methods = methods;
        return this;
    }

    public AgencyTokenIdentity addMethodsItem(MethodsEnum methodsItem) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodsEnum>();
        }
        this.methods.add(methodsItem);
        return this;
    }

    public AgencyTokenIdentity withMethods(Consumer<List<MethodsEnum>> methodsSetter) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodsEnum>();
        }
        methodsSetter.accept(this.methods);
        return this;
    }

    public List<MethodsEnum> getMethods() {
        return this.methods;
    }

    public void setMethods(List<MethodsEnum> methods) {
        this.methods = methods;
    }

    public AgencyTokenIdentity withAssumeRole(AgencyTokenAssumerole assumeRole) {
        this.assumeRole = assumeRole;
        return this;
    }

    public AgencyTokenIdentity withAssumeRole(Consumer<AgencyTokenAssumerole> assumeRoleSetter) {
        if (this.assumeRole == null) {
            this.assumeRole = new AgencyTokenAssumerole();
            assumeRoleSetter.accept(this.assumeRole);
        }
        return this;
    }

    public AgencyTokenAssumerole getAssumeRole() {
        return this.assumeRole;
    }

    public void setAssumeRole(AgencyTokenAssumerole assumeRole) {
        this.assumeRole = assumeRole;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AgencyTokenIdentity that = (AgencyTokenIdentity)obj;
        return Objects.equals(this.methods, that.methods) && Objects.equals(this.assumeRole, that.assumeRole);
    }

    public int hashCode() {
        return Objects.hash(this.methods, this.assumeRole);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgencyTokenIdentity {\n");
        sb.append("    methods: ").append(this.toIndentedString(this.methods)).append("\n");
        sb.append("    assumeRole: ").append(this.toIndentedString(this.assumeRole)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class MethodsEnum {
        public static final MethodsEnum ASSUME_ROLE = new MethodsEnum("assume_role");
        private static final Map<String, MethodsEnum> STATIC_FIELDS = MethodsEnum.createStaticFields();
        private String value;

        private static Map<String, MethodsEnum> createStaticFields() {
            HashMap<String, MethodsEnum> map = new HashMap<String, MethodsEnum>();
            map.put("assume_role", ASSUME_ROLE);
            return Collections.unmodifiableMap(map);
        }

        MethodsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodsEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new MethodsEnum(value));
        }

        public static MethodsEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodsEnum) {
                return this.value.equals(((MethodsEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

