/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.iam.v3.model.PwdPassword;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class PwdIdentity {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="methods")
    private List<MethodsEnum> methods = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="password")
    private PwdPassword password;

    public PwdIdentity withMethods(List<MethodsEnum> methods) {
        this.methods = methods;
        return this;
    }

    public PwdIdentity addMethodsItem(MethodsEnum methodsItem) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodsEnum>();
        }
        this.methods.add(methodsItem);
        return this;
    }

    public PwdIdentity withMethods(Consumer<List<MethodsEnum>> methodsSetter) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodsEnum>();
        }
        methodsSetter.accept(this.methods);
        return this;
    }

    public List<MethodsEnum> getMethods() {
        return this.methods;
    }

    public void setMethods(List<MethodsEnum> methods) {
        this.methods = methods;
    }

    public PwdIdentity withPassword(PwdPassword password) {
        this.password = password;
        return this;
    }

    public PwdIdentity withPassword(Consumer<PwdPassword> passwordSetter) {
        if (this.password == null) {
            this.password = new PwdPassword();
            passwordSetter.accept(this.password);
        }
        return this;
    }

    public PwdPassword getPassword() {
        return this.password;
    }

    public void setPassword(PwdPassword password) {
        this.password = password;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PwdIdentity that = (PwdIdentity)obj;
        return Objects.equals(this.methods, that.methods) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.methods, this.password);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PwdIdentity {\n");
        sb.append("    methods: ").append(this.toIndentedString(this.methods)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class MethodsEnum {
        public static final MethodsEnum PASSWORD = new MethodsEnum("password");
        private static final Map<String, MethodsEnum> STATIC_FIELDS = MethodsEnum.createStaticFields();
        private String value;

        private static Map<String, MethodsEnum> createStaticFields() {
            HashMap<String, MethodsEnum> map = new HashMap<String, MethodsEnum>();
            map.put("password", PASSWORD);
            return Collections.unmodifiableMap(map);
        }

        MethodsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodsEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new MethodsEnum(value));
        }

        public static MethodsEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodsEnum) {
                return this.value.equals(((MethodsEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

