package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;
import java.util.function.Consumer;

/**
 * 创建项目的请求体。
 */
public class KeystoneCreateProjectRequestBody {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "project")

    private KeystoneCreateProjectOption project;

    public KeystoneCreateProjectRequestBody withProject(KeystoneCreateProjectOption project) {
        this.project = project;
        return this;
    }

    public KeystoneCreateProjectRequestBody withProject(Consumer<KeystoneCreateProjectOption> projectSetter) {
        if (this.project == null) {
            this.project = new KeystoneCreateProjectOption();
            projectSetter.accept(this.project);
        }

        return this;
    }

    /**
     * Get project
     * @return project
     */
    public KeystoneCreateProjectOption getProject() {
        return project;
    }

    public void setProject(KeystoneCreateProjectOption project) {
        this.project = project;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || getClass() != obj.getClass()) {
            return false;
        }
        KeystoneCreateProjectRequestBody that = (KeystoneCreateProjectRequestBody) obj;
        return Objects.equals(this.project, that.project);
    }

    @Override
    public int hashCode() {
        return Objects.hash(project);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeystoneCreateProjectRequestBody {\n");
        sb.append("    project: ").append(toIndentedString(project)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
