package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;
import java.util.function.Consumer;

/**
 * 
 */
public class AgencyAuth {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "identity")

    private AgencyAuthIdentity identity;

    public AgencyAuth withIdentity(AgencyAuthIdentity identity) {
        this.identity = identity;
        return this;
    }

    public AgencyAuth withIdentity(Consumer<AgencyAuthIdentity> identitySetter) {
        if (this.identity == null) {
            this.identity = new AgencyAuthIdentity();
            identitySetter.accept(this.identity);
        }

        return this;
    }

    /**
     * Get identity
     * @return identity
     */
    public AgencyAuthIdentity getIdentity() {
        return identity;
    }

    public void setIdentity(AgencyAuthIdentity identity) {
        this.identity = identity;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || getClass() != obj.getClass()) {
            return false;
        }
        AgencyAuth that = (AgencyAuth) obj;
        return Objects.equals(this.identity, that.identity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(identity);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgencyAuth {\n");
        sb.append("    identity: ").append(toIndentedString(identity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
