/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.functiongraph.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.functiongraph.v2.model.TriggerEventData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class UpdateTriggerRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="trigger_status")
    private TriggerStatusEnum triggerStatus;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="event_data")
    private List<TriggerEventData> eventData = null;

    public UpdateTriggerRequestBody withTriggerStatus(TriggerStatusEnum triggerStatus) {
        this.triggerStatus = triggerStatus;
        return this;
    }

    public TriggerStatusEnum getTriggerStatus() {
        return this.triggerStatus;
    }

    public void setTriggerStatus(TriggerStatusEnum triggerStatus) {
        this.triggerStatus = triggerStatus;
    }

    public UpdateTriggerRequestBody withEventData(List<TriggerEventData> eventData) {
        this.eventData = eventData;
        return this;
    }

    public UpdateTriggerRequestBody addEventDataItem(TriggerEventData eventDataItem) {
        if (this.eventData == null) {
            this.eventData = new ArrayList<TriggerEventData>();
        }
        this.eventData.add(eventDataItem);
        return this;
    }

    public UpdateTriggerRequestBody withEventData(Consumer<List<TriggerEventData>> eventDataSetter) {
        if (this.eventData == null) {
            this.eventData = new ArrayList<TriggerEventData>();
        }
        eventDataSetter.accept(this.eventData);
        return this;
    }

    public List<TriggerEventData> getEventData() {
        return this.eventData;
    }

    public void setEventData(List<TriggerEventData> eventData) {
        this.eventData = eventData;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateTriggerRequestBody that = (UpdateTriggerRequestBody)obj;
        return Objects.equals(this.triggerStatus, that.triggerStatus) && Objects.equals(this.eventData, that.eventData);
    }

    public int hashCode() {
        return Objects.hash(this.triggerStatus, this.eventData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateTriggerRequestBody {\n");
        sb.append("    triggerStatus: ").append(this.toIndentedString(this.triggerStatus)).append("\n");
        sb.append("    eventData: ").append(this.toIndentedString(this.eventData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TriggerStatusEnum {
        public static final TriggerStatusEnum ACTIVE = new TriggerStatusEnum("ACTIVE");
        public static final TriggerStatusEnum DISABLED = new TriggerStatusEnum("DISABLED");
        private static final Map<String, TriggerStatusEnum> STATIC_FIELDS = TriggerStatusEnum.createStaticFields();
        private String value;

        private static Map<String, TriggerStatusEnum> createStaticFields() {
            HashMap<String, TriggerStatusEnum> map = new HashMap<String, TriggerStatusEnum>();
            map.put("ACTIVE", ACTIVE);
            map.put("DISABLED", DISABLED);
            return Collections.unmodifiableMap(map);
        }

        TriggerStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TriggerStatusEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TriggerStatusEnum(value));
        }

        public static TriggerStatusEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TriggerStatusEnum) {
                return this.value.equals(((TriggerStatusEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

