/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.functiongraph.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.functiongraph.v2.model.Action;
import com.huaweicloud.sdk.functiongraph.v2.model.OnError;
import com.huaweicloud.sdk.functiongraph.v2.model.StateDataFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class OperationState {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="action_mode")
    private ActionModeEnum actionMode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="actions")
    private List<Action> actions = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="on_errors")
    private List<OnError> onErrors = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="id")
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="end")
    private Boolean end;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="transition")
    private String transition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="state_data_filter")
    private StateDataFilter stateDataFilter;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="duration")
    private Long duration;

    public OperationState withActionMode(ActionModeEnum actionMode) {
        this.actionMode = actionMode;
        return this;
    }

    public ActionModeEnum getActionMode() {
        return this.actionMode;
    }

    public void setActionMode(ActionModeEnum actionMode) {
        this.actionMode = actionMode;
    }

    public OperationState withActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    public OperationState addActionsItem(Action actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    public OperationState withActions(Consumer<List<Action>> actionsSetter) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        actionsSetter.accept(this.actions);
        return this;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public OperationState withOnErrors(List<OnError> onErrors) {
        this.onErrors = onErrors;
        return this;
    }

    public OperationState addOnErrorsItem(OnError onErrorsItem) {
        if (this.onErrors == null) {
            this.onErrors = new ArrayList<OnError>();
        }
        this.onErrors.add(onErrorsItem);
        return this;
    }

    public OperationState withOnErrors(Consumer<List<OnError>> onErrorsSetter) {
        if (this.onErrors == null) {
            this.onErrors = new ArrayList<OnError>();
        }
        onErrorsSetter.accept(this.onErrors);
        return this;
    }

    public List<OnError> getOnErrors() {
        return this.onErrors;
    }

    public void setOnErrors(List<OnError> onErrors) {
        this.onErrors = onErrors;
    }

    public OperationState withId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OperationState withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OperationState withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OperationState withEnd(Boolean end) {
        this.end = end;
        return this;
    }

    public Boolean getEnd() {
        return this.end;
    }

    public void setEnd(Boolean end) {
        this.end = end;
    }

    public OperationState withTransition(String transition) {
        this.transition = transition;
        return this;
    }

    public String getTransition() {
        return this.transition;
    }

    public void setTransition(String transition) {
        this.transition = transition;
    }

    public OperationState withStateDataFilter(StateDataFilter stateDataFilter) {
        this.stateDataFilter = stateDataFilter;
        return this;
    }

    public OperationState withStateDataFilter(Consumer<StateDataFilter> stateDataFilterSetter) {
        if (this.stateDataFilter == null) {
            this.stateDataFilter = new StateDataFilter();
            stateDataFilterSetter.accept(this.stateDataFilter);
        }
        return this;
    }

    public StateDataFilter getStateDataFilter() {
        return this.stateDataFilter;
    }

    public void setStateDataFilter(StateDataFilter stateDataFilter) {
        this.stateDataFilter = stateDataFilter;
    }

    public OperationState withDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OperationState that = (OperationState)obj;
        return Objects.equals(this.actionMode, that.actionMode) && Objects.equals(this.actions, that.actions) && Objects.equals(this.onErrors, that.onErrors) && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.end, that.end) && Objects.equals(this.transition, that.transition) && Objects.equals(this.stateDataFilter, that.stateDataFilter) && Objects.equals(this.duration, that.duration);
    }

    public int hashCode() {
        return Objects.hash(this.actionMode, this.actions, this.onErrors, this.id, this.name, this.type, this.end, this.transition, this.stateDataFilter, this.duration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationState {\n");
        sb.append("    actionMode: ").append(this.toIndentedString(this.actionMode)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    onErrors: ").append(this.toIndentedString(this.onErrors)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    transition: ").append(this.toIndentedString(this.transition)).append("\n");
        sb.append("    stateDataFilter: ").append(this.toIndentedString(this.stateDataFilter)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TypeEnum {
        public static final TypeEnum OPERATION = new TypeEnum("Operation");
        public static final TypeEnum SLEEP = new TypeEnum("Sleep");
        public static final TypeEnum END = new TypeEnum("End");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("Operation", OPERATION);
            map.put("Sleep", SLEEP);
            map.put("End", END);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TypeEnum(value));
        }

        public static TypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class ActionModeEnum {
        public static final ActionModeEnum SEQUENTIAL = new ActionModeEnum("sequential");
        public static final ActionModeEnum PARALLEL = new ActionModeEnum("parallel");
        private static final Map<String, ActionModeEnum> STATIC_FIELDS = ActionModeEnum.createStaticFields();
        private String value;

        private static Map<String, ActionModeEnum> createStaticFields() {
            HashMap<String, ActionModeEnum> map = new HashMap<String, ActionModeEnum>();
            map.put("sequential", SEQUENTIAL);
            map.put("parallel", PARALLEL);
            return Collections.unmodifiableMap(map);
        }

        ActionModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionModeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ActionModeEnum(value));
        }

        public static ActionModeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ActionModeEnum) {
                return this.value.equals(((ActionModeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

