/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.functiongraph.v2;

import com.huaweicloud.sdk.core.ClientBuilder;
import com.huaweicloud.sdk.core.HcClient;
import com.huaweicloud.sdk.core.exception.ConnectionException;
import com.huaweicloud.sdk.core.exchange.SdkExchange;
import com.huaweicloud.sdk.core.exchange.SdkExchangeCache;
import com.huaweicloud.sdk.core.http.HttpRequestDef;
import com.huaweicloud.sdk.functiongraph.v2.CustomClientBuilder;
import com.huaweicloud.sdk.functiongraph.v2.FunctionGraphClient;
import com.huaweicloud.sdk.functiongraph.v2.FunctionGraphMeta;
import com.huaweicloud.sdk.functiongraph.v2.model.AsyncInvokeFunctionRequest;
import com.huaweicloud.sdk.functiongraph.v2.model.AsyncInvokeFunctionResponse;
import com.huaweicloud.sdk.functiongraph.v2.model.InvokeFunctionRequest;
import com.huaweicloud.sdk.functiongraph.v2.model.InvokeFunctionResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionGraphTenantClient
extends FunctionGraphClient {
    private static final Logger logger = LoggerFactory.getLogger(FunctionGraphTenantClient.class);
    private String domainName = null;
    private final List<String> endpoints;

    public static ClientBuilder<FunctionGraphClient> newBuilder() {
        return new CustomClientBuilder<FunctionGraphClient>(FunctionGraphTenantClient::new);
    }

    public FunctionGraphTenantClient(HcClient hcClient) {
        super(hcClient);
        this.endpoints = hcClient.getEndpoints();
        if (this.endpoints != null && this.endpoints.size() > 0) {
            this.domainName = this.endpoints.get(this.endpoints.size() - 1);
        }
    }

    private <R, S> S invokeFunctionWithRetries(R request, HttpRequestDef<R, S> meta, Class<S> responseType) {
        CopyOnWriteArrayList<String> shuffleEndpoints = new CopyOnWriteArrayList<String>(this.endpoints);
        Collections.shuffle(shuffleEndpoints);
        Object response = null;
        SdkExchange sdkExchange = new SdkExchange();
        int retryCount = 0;
        for (int i = 0; i < shuffleEndpoints.size(); ++i) {
            String endpoint = shuffleEndpoints.get(i);
            try {
                this.hcClient.withEndpoints(Collections.singletonList(endpoint));
                response = this.hcClient.syncInvokeHttp(request, meta, sdkExchange, this.genApigHeader());
                break;
            }
            catch (ConnectionException e) {
                String exchangeId = SdkExchangeCache.putExchange((SdkExchange)sdkExchange);
                logger.error("request failed, exchangeId: " + exchangeId + " endpoint: " + endpoint, (Object)(" message: " + e.getMessage() + " retry times: " + ++retryCount));
                if (i != shuffleEndpoints.size() - 1) continue;
                throw e;
            }
        }
        return (S)response;
    }

    @Override
    public AsyncInvokeFunctionResponse asyncInvokeFunction(AsyncInvokeFunctionRequest request) {
        return this.invokeFunctionWithRetries(request, FunctionGraphMeta.asyncInvokeFunction, AsyncInvokeFunctionResponse.class);
    }

    @Override
    public InvokeFunctionResponse invokeFunction(InvokeFunctionRequest request) {
        return this.invokeFunctionWithRetries(request, FunctionGraphMeta.invokeFunction, InvokeFunctionResponse.class);
    }

    private Map<String, String> genApigHeader() {
        HashMap<String, String> extraHeaders = new HashMap<String, String>();
        if (this.domainName == null) {
            return new HashMap<String, String>();
        }
        String host = this.domainName.replace("https://", "");
        extraHeaders.put("Host", host);
        return extraHeaders;
    }
}

