/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.functiongraph.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.functiongraph.v2.model.FuncCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class UpdateFunctionCodeRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="code_type")
    private CodeTypeEnum codeType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="code_url")
    private String codeUrl;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="code_filename")
    private String codeFilename;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="func_code")
    private FuncCode funcCode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="depend_version_list")
    private List<String> dependVersionList = null;

    public UpdateFunctionCodeRequestBody withCodeType(CodeTypeEnum codeType) {
        this.codeType = codeType;
        return this;
    }

    public CodeTypeEnum getCodeType() {
        return this.codeType;
    }

    public void setCodeType(CodeTypeEnum codeType) {
        this.codeType = codeType;
    }

    public UpdateFunctionCodeRequestBody withCodeUrl(String codeUrl) {
        this.codeUrl = codeUrl;
        return this;
    }

    public String getCodeUrl() {
        return this.codeUrl;
    }

    public void setCodeUrl(String codeUrl) {
        this.codeUrl = codeUrl;
    }

    public UpdateFunctionCodeRequestBody withCodeFilename(String codeFilename) {
        this.codeFilename = codeFilename;
        return this;
    }

    public String getCodeFilename() {
        return this.codeFilename;
    }

    public void setCodeFilename(String codeFilename) {
        this.codeFilename = codeFilename;
    }

    public UpdateFunctionCodeRequestBody withFuncCode(FuncCode funcCode) {
        this.funcCode = funcCode;
        return this;
    }

    public UpdateFunctionCodeRequestBody withFuncCode(Consumer<FuncCode> funcCodeSetter) {
        if (this.funcCode == null) {
            this.funcCode = new FuncCode();
            funcCodeSetter.accept(this.funcCode);
        }
        return this;
    }

    public FuncCode getFuncCode() {
        return this.funcCode;
    }

    public void setFuncCode(FuncCode funcCode) {
        this.funcCode = funcCode;
    }

    public UpdateFunctionCodeRequestBody withDependVersionList(List<String> dependVersionList) {
        this.dependVersionList = dependVersionList;
        return this;
    }

    public UpdateFunctionCodeRequestBody addDependVersionListItem(String dependVersionListItem) {
        if (this.dependVersionList == null) {
            this.dependVersionList = new ArrayList<String>();
        }
        this.dependVersionList.add(dependVersionListItem);
        return this;
    }

    public UpdateFunctionCodeRequestBody withDependVersionList(Consumer<List<String>> dependVersionListSetter) {
        if (this.dependVersionList == null) {
            this.dependVersionList = new ArrayList<String>();
        }
        dependVersionListSetter.accept(this.dependVersionList);
        return this;
    }

    public List<String> getDependVersionList() {
        return this.dependVersionList;
    }

    public void setDependVersionList(List<String> dependVersionList) {
        this.dependVersionList = dependVersionList;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateFunctionCodeRequestBody that = (UpdateFunctionCodeRequestBody)obj;
        return Objects.equals(this.codeType, that.codeType) && Objects.equals(this.codeUrl, that.codeUrl) && Objects.equals(this.codeFilename, that.codeFilename) && Objects.equals(this.funcCode, that.funcCode) && Objects.equals(this.dependVersionList, that.dependVersionList);
    }

    public int hashCode() {
        return Objects.hash(this.codeType, this.codeUrl, this.codeFilename, this.funcCode, this.dependVersionList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateFunctionCodeRequestBody {\n");
        sb.append("    codeType: ").append(this.toIndentedString(this.codeType)).append("\n");
        sb.append("    codeUrl: ").append(this.toIndentedString(this.codeUrl)).append("\n");
        sb.append("    codeFilename: ").append(this.toIndentedString(this.codeFilename)).append("\n");
        sb.append("    funcCode: ").append(this.toIndentedString(this.funcCode)).append("\n");
        sb.append("    dependVersionList: ").append(this.toIndentedString(this.dependVersionList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class CodeTypeEnum {
        public static final CodeTypeEnum INLINE = new CodeTypeEnum("inline");
        public static final CodeTypeEnum ZIP = new CodeTypeEnum("zip");
        public static final CodeTypeEnum OBS = new CodeTypeEnum("obs");
        public static final CodeTypeEnum JAR = new CodeTypeEnum("jar");
        public static final CodeTypeEnum CUSTOM_IMAGE_SWR = new CodeTypeEnum("Custom-Image-Swr");
        private static final Map<String, CodeTypeEnum> STATIC_FIELDS = CodeTypeEnum.createStaticFields();
        private String value;

        private static Map<String, CodeTypeEnum> createStaticFields() {
            HashMap<String, CodeTypeEnum> map = new HashMap<String, CodeTypeEnum>();
            map.put("inline", INLINE);
            map.put("zip", ZIP);
            map.put("obs", OBS);
            map.put("jar", JAR);
            map.put("Custom-Image-Swr", CUSTOM_IMAGE_SWR);
            return Collections.unmodifiableMap(map);
        }

        CodeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CodeTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new CodeTypeEnum(value));
        }

        public static CodeTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof CodeTypeEnum) {
                return this.value.equals(((CodeTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

